/*
 * Decompiled with CFR 0.152.
 */
package applications;

import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;
import hcrypto.provider.RamProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class FileCipher {
    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.out.println("Usage: java FileCipher cipher keyspec -e|-d infile outfile [encoding]");
            System.out.println("Usage: java FileCipher Caesar 5/az+AZ -e foo.txt bar.txt");
            return;
        }
        System.out.println("Encoding=" + System.getProperty("file.encoding"));
        Provider.addProvider(new DefaultProvider("Default"));
        Provider.addProvider(new RamProvider("Ram"));
        String cipherName = args[0];
        String keyspec = args[1];
        Cipher cipher = Cipher.getInstance(cipherName);
        HistoricalKey key = HistoricalKey.getInstance(cipher.getAlgorithm(), cipher.getProvider());
        key.init(keyspec);
        cipher.init(key);
        System.out.println("Algorithm = " + cipher.getAlgorithm());
        System.out.println("Provider = " + cipher.getProvider());
        if (args[2].indexOf("e") != -1) {
            if (args.length == 6) {
                cipher.encryptFile(args[3], args[4], args[5]);
            } else {
                cipher.encryptFile(args[3], args[4]);
            }
        } else if (args.length == 6) {
            cipher.decryptFile(args[3], args[4], args[5]);
        } else {
            cipher.decryptFile(args[3], args[4]);
        }
        File oFile = new File(args[4]);
        InputStreamReader iStream = new InputStreamReader(new FileInputStream(oFile));
        int length = (int)oFile.length();
        char[] input = new char[length];
        iStream.read(input);
        iStream.close();
        String inString = new String(input);
    }
}

