/*
 * Decompiled with CFR 0.152.
 */
package applications;

import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;
import hcrypto.provider.RamProvider;
import java.util.StringTokenizer;

public class TestCipher {
    public static void main(String[] args) throws Exception {
        String providerName;
        String cipherName;
        if (args.length < 3) {
            System.out.println("Usage: java TestCipher algorithm keyspec plaintext [-d]");
            System.out.println("Usage: java TestCipher Caesar 5/az+AZ/az+AZ thisisatest");
            System.out.println("Usage: java TestCipher Vigenere keyword/az+AZ thisisatestofVigenereCipher");
            System.out.println("Usage: java TestCipher Transposition 3012/printable thisisatest");
            return;
        }
        Provider.addProvider(new DefaultProvider("Default"));
        Provider.addProvider(new RamProvider("Ram"));
        StringTokenizer st = new StringTokenizer(Provider.getCipherNames(), ",");
        System.out.println("Available algorithms (Provider): ");
        while (st.hasMoreTokens()) {
            System.out.println(st.nextToken());
        }
        if (args[0].indexOf(47) != -1) {
            cipherName = args[0].substring(0, args[0].indexOf(47));
            providerName = args[0].substring(args[0].indexOf(47) + 1);
        } else {
            cipherName = args[0];
            providerName = "Default";
        }
        String keyspec = args[1];
        Cipher cipher = Cipher.getInstance(cipherName, providerName);
        HistoricalKey key = HistoricalKey.getInstance(cipher.getAlgorithm(), cipher.getProvider());
        key.init(keyspec);
        System.out.println("\nThe keyword is: " + key.getKeyword());
        cipher.init(key);
        System.out.println("Algorithm = " + cipher.getAlgorithm());
        System.out.println("Provider = " + cipher.getProvider());
        String secret = args[2];
        System.out.println(secret);
        String c1encrypt = args.length == 4 && args[3].equals("-d") ? cipher.decrypt(secret) : cipher.encrypt(secret);
        System.out.println(c1encrypt);
        cipher.init(key);
        if (args.length == 4 && args[3].equals("-d")) {
            System.out.println(cipher.encrypt(c1encrypt));
        } else {
            System.out.println(cipher.decrypt(c1encrypt));
        }
        System.out.println();
    }
}

