/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import hcrypto.analyzer.CryptoAnalyzer;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AnalyzerFrame
extends Frame
implements ActionListener {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 300;
    protected TextArea display;
    private CryptoAnalyzer analyzer;
    private MenuBar menubar;
    private Menu controls;
    private MenuItem stopItem;
    private MenuItem startItem;
    private String crypto;
    private String paramStr;
    private boolean stopThread = false;

    public AnalyzerFrame() {
        super("AnalyzerWindow");
        this.buildGUI();
    }

    public AnalyzerFrame(CryptoAnalyzer a, String text, String params) {
        super("AnalyzerWindow");
        this.analyzer = a;
        this.crypto = text;
        this.paramStr = params;
        this.buildGUI();
        this.analyzer.setup(this.crypto, this);
        this.stopThread = false;
        Thread t = new Thread(this.analyzer);
        t.start();
    }

    public void actionPerformed(ActionEvent e) {
        MenuItem m = (MenuItem)e.getSource();
        if (m == this.stopItem) {
            this.stopThread = true;
            this.analyzer.stopThread();
        } else if (m == this.startItem) {
            this.analyzer.stopThread();
            this.analyzer.setup(this.crypto, this);
            this.stopThread = false;
            Thread t = new Thread(this.analyzer);
            t.start();
        }
    }

    protected void buildGUI() {
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.controls = new Menu("Controls");
        this.menubar.add(this.controls);
        this.startItem = new MenuItem("Start");
        this.startItem.addActionListener(this);
        this.controls.add(this.startItem);
        this.stopItem = new MenuItem("Stop");
        this.stopItem.addActionListener(this);
        this.controls.add(this.stopItem);
        if (this.analyzer == null) {
            this.stopItem.setEnabled(false);
            this.startItem.setEnabled(false);
        }
        this.display = new TextArea(10, 40);
        this.display.setEditable(false);
        this.add(this.display);
        this.setSize(400, 300);
        this.setVisible(true);
        AnalyzerFrame.centerWindow(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AnalyzerFrame.this.setVisible(false);
            }
        });
    }

    public static void centerWindow(Window win) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = win.getSize();
        int x = (screenSize.width - winSize.width) / 2;
        int y = (screenSize.height - winSize.height) / 4;
        if (y < 0) {
            y = 0;
        }
        win.setLocation(x, y);
    }

    public void setAnalyzer(CryptoAnalyzer a) {
        this.analyzer = a;
    }

    public void setCryptText(String s) {
        this.crypto = s;
    }

    public void setParamString(String s) {
        this.paramStr = s;
    }

    public TextArea getTextArea() {
        return this.display;
    }

    public void setText(String text) {
        this.display.setText(text);
    }

    public void append(String text) {
        this.display.append(text);
    }

    public boolean threadIsStopped() {
        return this.stopThread;
    }
}

