/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import applications.cryptotoolj.AnalyzerFrame;
import applications.cryptotoolj.CryptoToolJ;
import applications.cryptotoolj.KeyDialog;
import applications.cryptotoolj.Menus;
import applications.cryptotoolj.TextAreaPlus;
import applications.cryptotoolj.Tools;
import applications.cryptotoolj.WindowManager;
import hcrypto.analyzer.AffineAnalyzer;
import hcrypto.analyzer.CaesarAnalyzer;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.DigramAnalyzer;
import hcrypto.analyzer.VigenereAnalyzer;
import hcrypto.analyzer.WordBasedAnalyzer;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.evolutionary.NgramGaAnalyzer;
import hcrypto.analyzer.evolutionary.WordBasedGaAnalyzer;
import hcrypto.analyzer.tool.EnglishFacts;
import hcrypto.analyzer.tool.PatternWordSearcher;
import hcrypto.analyzer.tool.TextAnalyzer;
import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.provider.Provider;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CipherFrame
extends Frame
implements ActionListener,
ItemListener,
WindowListener,
ClipboardOwner {
    public static final int WIDTH = 500;
    public static final int HEIGHT = 500;
    private CryptoToolJ cryptoTool;
    private Cipher cipher;
    private HistoricalKey key;
    private String keyClassName;
    private TextAreaPlus inputField;
    private TextAreaPlus outputField;
    private JTextField encodingField;
    private JButton encodeButton;
    private JButton decodeButton;
    private JButton keyButton;
    private JPanel inputPanel;
    private JPanel buttonPanel;
    private JPanel outputPanel;
    private Choice selectionBox;
    private String keywordString;
    private String keyPromptString;
    private String windowId = "";
    public boolean isActivated = false;

    public CipherFrame(CryptoToolJ ctj) {
        super("Cipher");
        this.cryptoTool = ctj;
        this.createCipherFrame();
        this.addWindowListener(this);
        this.setMenuBar(Menus.getMenuBar());
        this.setResizable(true);
        this.setSize(500, 500);
        this.pack();
        this.setVisible(true);
        Tools.centerWindow(this);
        this.requestFocus();
    }

    public void renameWithWindowId(String id) {
        String s = this.getTitle();
        int index = s.indexOf(":");
        this.setTitle(String.valueOf(s.substring(0, index)) + id + s.substring(index));
    }

    private void createCipherFrame() {
        File file;
        String[] plugins;
        this.selectionBox = new Choice();
        StringTokenizer st = new StringTokenizer(Provider.getCipherNames(), ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            this.selectionBox.addItem(s);
        }
        this.selectionBox.select("Substitution (Default)");
        this.selectionBox.addItemListener(this);
        if (!this.cryptoTool.isApplet() && (plugins = (file = new File("plugins")).list()) != null) {
            int k = 0;
            while (k < plugins.length) {
                String className = plugins[k];
                if (className.endsWith("Engine.class")) {
                    String algoName = className.substring(0, className.indexOf("Engine.class"));
                    algoName = String.valueOf(algoName) + " (Plugin)";
                    this.selectionBox.addItem(algoName);
                }
                ++k;
            }
        }
        this.setSelectedCipher();
        this.setTitle("Cipher: " + this.cipher.getAlgorithm() + " (" + this.cipher.getProvider() + ")");
        TitledBorder bI = BorderFactory.createTitledBorder("Input Text");
        TitledBorder bO = BorderFactory.createTitledBorder("Output Text");
        this.inputPanel = new JPanel();
        this.outputPanel = new JPanel();
        this.inputField = new TextAreaPlus(this, "Input Text Area", bI);
        this.inputPanel.add(this.inputField);
        this.inputPanel.setBorder(bI);
        this.inputField.setEditable(true);
        this.outputField = new TextAreaPlus(this, "Output Text Area", bO);
        this.outputField.setEditable(true);
        this.outputPanel.add(this.outputField);
        this.outputPanel.setBorder(bO);
        this.buttonPanel = new JPanel();
        this.keyButton = new JButton("Set Key");
        this.encodeButton = new JButton("Encrypt");
        this.decodeButton = new JButton("Decrypt");
        this.encodingField = new JTextField("default");
        this.encodeButton.setEnabled(false);
        this.decodeButton.setEnabled(false);
        this.keyButton.addActionListener(this);
        this.encodeButton.addActionListener(this);
        this.decodeButton.addActionListener(this);
        this.buttonPanel.add(this.selectionBox);
        this.buttonPanel.add(this.keyButton);
        this.buttonPanel.add(this.encodeButton);
        this.buttonPanel.add(this.decodeButton);
        this.buttonPanel.add(new Label("Encoding:"));
        this.buttonPanel.add(this.encodingField);
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.inputPanel, "Center");
        this.add((Component)this.outputPanel, "South");
    }

    private void setSelectedCipher() {
        String cipherSelection = this.selectionBox.getSelectedItem();
        String algorithm = cipherSelection.substring(0, cipherSelection.indexOf(" "));
        String provider = cipherSelection.substring(cipherSelection.indexOf("(") + 1, cipherSelection.length() - 1);
        if (provider.indexOf("Plugin") != -1) {
            try {
                System.out.println("Using Plugin algorithm " + algorithm);
                this.cipher = Cipher.getInstance(algorithm, provider);
                this.keyClassName = "plugins." + algorithm + "Key";
                this.key = null;
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.cipher = Cipher.getInstance(algorithm, provider);
            this.keyClassName = "hcrypto.engines." + algorithm + "Key";
            this.key = null;
        }
    }

    public void openFile() {
        this.inputField.openFile(this.encodingField.getText());
        this.inputField.markFileSaved();
    }

    public boolean saveTextInTextAreas(boolean rename) {
        int result = 0;
        if (this.inputField.isDirty()) {
            result = this.inputField.saveToFile();
            if (result == 0) {
                return false;
            }
            if (result == 2) {
                this.inputField.save(this.encodingField.getText(), this.inputField.getFile() == null);
            }
        }
        if (this.outputField.isDirty()) {
            result = this.outputField.saveToFile();
            if (result == 0) {
                return false;
            }
            if (result == 2) {
                this.outputField.save(this.encodingField.getText(), this.outputField.getFile() == null);
            }
        }
        return true;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.selectionBox) {
            this.setSelectedCipher();
            String s = this.getTitle();
            int index = s.indexOf(":");
            this.setTitle(String.valueOf(s.substring(0, index)) + ":" + this.cipher.getAlgorithm() + " (" + this.cipher.getProvider() + ")");
            this.encodeButton.setEnabled(false);
            this.decodeButton.setEnabled(false);
            this.keyButton.setEnabled(true);
        }
    }

    public void showStatistics() {
        TextAnalyzer analyzer = new TextAnalyzer();
        TextAreaPlus ta = this.getTextAreaWithFocus();
        if (ta != null) {
            analyzer.setup(ta.getText());
        }
    }

    public void getEnglishFacts() {
        AnalyzerFrame f = new AnalyzerFrame();
        EnglishFacts analyzer = new EnglishFacts(f);
        f.setTitle("English Facts");
        f.setSize(500, 500);
        f.setText("Facts about English Letter Frequencies\n");
        analyzer.run();
    }

    public void getPatternWords() {
        PatternWordSearcher analyzer = new PatternWordSearcher();
        analyzer.run();
    }

    public void doCryptoAnalyzerCommand(String cmd) {
        String paramStr;
        CryptoAnalyzer analyzer = null;
        AnalyzerFrame f = new AnalyzerFrame();
        f.setTitle(cmd);
        f.setSize(500, 500);
        if (cmd.equals("Affine Analyzer")) {
            analyzer = new AffineAnalyzer(f);
        } else if (cmd.equals("Caesar Analyzer")) {
            analyzer = new CaesarAnalyzer(f);
        } else if (cmd.equals("Vigenere Analyzer")) {
            analyzer = new VigenereAnalyzer(f);
        } else if (cmd.equals("Digram Substitution Analyzer")) {
            analyzer = new DigramAnalyzer(f);
        } else if (cmd.equals("WordBased Substitution Analyzer")) {
            paramStr = "ctype=0 nloops=200 verbose=false";
            analyzer = new WordBasedAnalyzer(new GaParameters(paramStr), f);
        } else if (cmd.equals("WordBased GA Substitution Analyzer")) {
            paramStr = "size=512 ctype=0 nloops=500 verbose=false";
            analyzer = new WordBasedGaAnalyzer(new GaParameters(paramStr), f);
        } else if (cmd.equals("Ngram GA Substitution Analyzer")) {
            paramStr = "book=data/book.txt NN=4 size=512 ctype=0 nloops=500 verbose=false";
            analyzer = new NgramGaAnalyzer(new GaParameters(paramStr), f);
        }
        TextAreaPlus ta = this.getTextAreaWithFocus();
        if (ta != null) {
            analyzer.setup(ta.getText());
        }
        analyzer.run();
    }

    public void actionPerformed(ActionEvent e) {
        KeyDialog keyDialog = null;
        if (e.getSource() == this.encodeButton) {
            try {
                this.cipher.init(this.key);
                this.outputField.setText(this.cipher.encrypt(this.inputField.getText()));
            }
            catch (Exception ee) {
                System.out.println("Exception: " + ee.getMessage());
                ee.printStackTrace();
            }
        } else if (e.getSource() == this.decodeButton) {
            try {
                this.cipher.init(this.key);
                this.outputField.setText(this.cipher.decrypt(this.inputField.getText()));
            }
            catch (Exception ee) {
                System.out.println("Exception: " + ee.getMessage());
                ee.printStackTrace();
            }
        } else if (e.getSource() == this.keyButton) {
            if (this.key == null) {
                try {
                    this.keywordString = (String)Class.forName(this.keyClassName).getDeclaredField("DEFAULT_KEYWORD_STRING").get(null);
                    this.keyPromptString = (String)Class.forName(this.keyClassName).getDeclaredField("DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING").get(null);
                }
                catch (Exception ee) {
                    System.out.println(ee.getMessage());
                    ee.printStackTrace();
                }
            }
            if (keyDialog == null) {
                keyDialog = new KeyDialog((Frame)this, this.cipher.getAlphabetRangeOptions(), "Enter " + this.cipher.getAlgorithm() + " Key and Choose Alphabet Parameters");
            }
            keyDialog.setKeyText(this.keywordString);
            int dialogOption = keyDialog.showKeyDialog();
            if (dialogOption == 0) {
                try {
                    this.key = HistoricalKey.getInstance(this.cipher.getAlgorithm(), this.cipher.getProvider());
                    this.key.init(String.valueOf(keyDialog.getKeyAreaText()) + "/" + keyDialog.getSelectedAlphabetChoice());
                    if (this.key != null) {
                        this.encodeButton.setEnabled(true);
                        this.decodeButton.setEnabled(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public TextAreaPlus getTextAreaWithFocus() {
        if (this.inputField.isInFocus()) {
            return this.inputField;
        }
        if (this.outputField.isInFocus()) {
            return this.outputField;
        }
        return null;
    }

    public boolean close() {
        if (!this.saveTextInTextAreas(false)) {
            return false;
        }
        this.setVisible(false);
        WindowManager.removeWindow(this);
        this.dispose();
        return true;
    }

    public void save(boolean rename) {
        TextAreaPlus tap = this.getTextAreaWithFocus();
        if (tap == null) {
            return;
        }
        if (rename || tap.isDirty()) {
            tap.save(this.encodingField.getText(), rename);
        }
    }

    public void setWindowId(int n) {
        this.windowId = "" + n;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public void activate() {
        this.isActivated = true;
        this.toFront();
        this.cryptoTool.getMenus();
        this.setMenuBar(Menus.getMenuBar());
        Menus.updateMenus();
    }

    public void windowActivated(WindowEvent e) {
        this.isActivated = true;
        this.toFront();
        this.cryptoTool.getMenus();
        this.setMenuBar(Menus.getMenuBar());
        Menus.updateMenus();
    }

    public void windowDeactivated(WindowEvent e) {
        this.isActivated = false;
    }

    public void windowClosing(WindowEvent e) {
        this.cryptoTool.doCommand("Close Cipher...");
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }
}

