/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import applications.cryptotoolj.AnalyzerFrame;
import applications.cryptotoolj.CipherFrame;
import applications.cryptotoolj.Menus;
import applications.cryptotoolj.MessageDialog;
import applications.cryptotoolj.TextAreaPlus;
import applications.cryptotoolj.TextManager;
import applications.cryptotoolj.Tools;
import applications.cryptotoolj.WindowManager;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.tool.IndexOfCoincidence;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;
import hcrypto.provider.RamProvider;
import java.applet.Applet;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;

public class CryptoToolJ
extends Frame
implements ActionListener,
WindowListener,
ClipboardOwner {
    private Applet applet;
    private Menus menus;
    private CipherFrame cf;
    private AnalyzerFrame analyzerFrame;
    public TextArea display;
    private final String cryptoAnalyzerCmds = "Affine AnalyzerCaesar AnalyzerDigram Substitution AnalyzerWordBased Substitution AnalyzerWordBased GA Substitution AnalyzerNgram GA Substitution AnalyzerVigenere Analyzer";

    public CryptoToolJ(Applet applet) {
        super("CryptoToolJ");
        this.applet = applet;
        this.display = new TextArea();
        this.display.setEditable(false);
        this.add("Center", this.display);
        this.display.setText("Starting CryptoToolJ v0.51\n");
        if (applet != null) {
            this.display.setText("Applet Version: Plugins are not available.\n Applet Version: File I/O is disabled\n");
        }
        this.addWindowListener(this);
        this.menus = new Menus(this, applet);
        this.menus.addMenuBar();
        WindowManager.init(this, applet);
        Provider.addProvider(new DefaultProvider("Default"));
        Provider.addProvider(new RamProvider("Ram"));
        if (applet != null) {
            System.out.println("Applet version does not support plugins");
        } else {
            this.loadPluginProviders();
        }
        Point loc = this.getPreferredLocation();
        this.setBounds(loc.x, loc.y, 400, 200);
        this.setVisible(true);
        this.requestFocus();
    }

    private void loadPluginProviders() {
        System.out.println("Plugins should be here: " + Tools.getPluginDirectory());
        System.out.println("Providers should be here: " + Tools.getProviderDirectory());
        String className = "";
        try {
            String packagePrefix = String.valueOf(Tools.getProviderPackageName()) + ".";
            File file = new File(Tools.getProviderDirectory());
            String[] providers = file.list();
            if (providers != null) {
                int k = 0;
                while (k < providers.length) {
                    className = providers[k];
                    if (className.endsWith("Provider.class")) {
                        className = String.valueOf(packagePrefix) + className.substring(0, className.indexOf("."));
                        this.display.append("Adding plugin provider: " + className + "\n");
                        this.display.append("Name: " + Class.forName(className).getName() + "\n");
                        System.out.println("Adding provider " + className);
                        System.out.println("Name: " + Class.forName(className).getName());
                        Class[] paramtypes = new Class[]{Class.forName("java.lang.String")};
                        Constructor<?> constr = Class.forName(className).getConstructor(paramtypes);
                        Object[] constargs = new Object[]{new String("Plugin")};
                        Provider.addProvider((Provider)constr.newInstance(constargs));
                    }
                    ++k;
                }
            } else {
                this.display.append("No providers found in '" + packagePrefix + "'\n");
            }
        }
        catch (ClassNotFoundException e) {
            this.showStatus("Exception: Plugin not found: " + className);
        }
        catch (InstantiationException e) {
            this.showStatus("Exception: Unable to load plugin (Instantiation)");
        }
        catch (IllegalAccessException e) {
            this.showStatus("Exception: Unable to load plugin (Access)");
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
        this.display.append("Ciphers (Provider) loaded: \n");
        StringTokenizer st = new StringTokenizer(Provider.getCipherNames(), ",");
        while (st.hasMoreTokens()) {
            this.display.append(" > " + st.nextToken() + "\n");
        }
    }

    public Point getPreferredLocation() {
        int windowWidth;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        double percent = screenWidth > 832 ? 0.8 : 0.9;
        int windowX = (int)(percent * (double)(screenWidth - (windowWidth = 500)));
        if (windowX < 10) {
            windowX = 10;
        }
        int windowY = 32;
        return new Point(windowX, windowY);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            String cmd = e.getActionCommand();
            if (((Menu)item.getParent()).getLabel().equals("Analysis")) {
                this.doAnalyzerCommand(cmd);
            } else {
                this.doCommand(cmd);
            }
        }
    }

    public void doAnalyzerCommand(String cmd) {
        CipherFrame cf = WindowManager.getActiveCipherFrame();
        if (cf == null) {
            this.display.append("Error:  You must select a text area to analyze\n");
            return;
        }
        if (cmd.indexOf("Index Of Coincidence") != -1) {
            IndexOfCoincidence analyzer = new IndexOfCoincidence();
            analyzer.setup(cf.getTextAreaWithFocus().getText());
            analyzer.run();
            this.display.append(analyzer.getReport());
        } else if (cmd.indexOf("Text Histogram") != -1) {
            cf.showStatistics();
        } else if (cmd.indexOf("English FAQ") != -1) {
            cf.getEnglishFacts();
        } else if (cmd.indexOf("Pattern Word Searcher") != -1) {
            cf.getPatternWords();
        } else if ("Affine AnalyzerCaesar AnalyzerDigram Substitution AnalyzerWordBased Substitution AnalyzerWordBased GA Substitution AnalyzerNgram GA Substitution AnalyzerVigenere Analyzer".indexOf(cmd) != -1) {
            cf.doCryptoAnalyzerCommand(cmd);
        } else {
            try {
                String classname = String.valueOf(Tools.getAnalyzerPackageName()) + "." + cmd;
                System.out.println("Looking for plugin analyzer: " + classname);
                AnalyzerFrame f = new AnalyzerFrame();
                f.setTitle(cmd);
                f.setSize(300, 300);
                Class[] paramtypes = new Class[]{Class.forName("applications.cryptotoolj.AnalyzerFrame")};
                Object[] constargs = new Object[]{f};
                Constructor<?> constr = Class.forName(classname).getConstructor(paramtypes);
                CryptoAnalyzer analyzer = (CryptoAnalyzer)constr.newInstance(constargs);
                TextAreaPlus ta = cf.getTextAreaWithFocus();
                if (ta != null) {
                    analyzer.setup(cf.getTextAreaWithFocus().getText());
                    analyzer.run();
                    this.display.append(String.valueOf(analyzer.getReport()) + "\n");
                } else {
                    this.display.append("Error:  You must select a text area to analyze.\n");
                }
            }
            catch (ClassNotFoundException e) {
                this.showStatus("Exception: Analyzer not found: " + cmd);
            }
            catch (InstantiationException e) {
                this.showStatus("Exception: Unable to load analyzer (Instantiation)");
            }
            catch (IllegalAccessException e) {
                this.showStatus("Exception: Unable to load analyzer (Access)");
            }
            catch (Exception e) {
                this.showStatus("Exception: " + cmd + "\n" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void doCommand(String cmd) {
        CipherFrame cf = WindowManager.getActiveCipherFrame();
        if (cmd.equals("About CryptoToolJ...")) {
            this.showAboutBox();
        }
        if (cmd.equals("New Cipher...")) {
            cf = new CipherFrame(this);
            WindowManager.addWindow(cf);
        } else if (cmd.equals("Open File...")) {
            if (cf == null) {
                cf = new CipherFrame(this);
                WindowManager.addWindow(cf);
            }
            cf.openFile();
        } else if (cmd.equals("Close Cipher...")) {
            if (cf != null) {
                cf.close();
            }
        } else if (cmd.equals("Save")) {
            if (cf != null) {
                cf.save(false);
            }
        } else if (cmd.equals("Save As")) {
            if (cf != null) {
                cf.save(true);
            }
        } else if (cmd.equals("Print")) {
            this.showStatus("PrintCipher... not yet implemented");
        } else if (cmd.equals("Cut")) {
            TextManager.copyText(true);
        } else if (cmd.equals("Copy")) {
            TextManager.copyText(false);
        } else if (cmd.equals("Paste")) {
            TextManager.pasteText();
        } else if (cmd.equals("Select All")) {
            TextManager.selectAll();
        } else if (cmd.equals("CryptoToolJ")) {
            this.activate();
        } else if (cmd.indexOf("CipherFrame") != -1) {
            WindowManager.activateWindow(cmd);
        } else if (cmd.equals("Quit")) {
            this.quit();
        }
    }

    void showAboutBox() {
        MessageDialog d = new MessageDialog((Frame)this, "About...", "         CryptoToolJ v1.3\n \nRalph Morelli (ralph.morelli@trincoll.edu)\nTrinity College, Hartford, CT, USA\n \nCryptoToolJ is in the public domain");
    }

    private void quit() {
        this.display.append("Quitting\n");
        if (!WindowManager.closeAllWindows()) {
            this.display.append("Canceled\n");
            return;
        }
        if (this.applet == null) {
            System.exit(0);
        }
        this.display.append("Setting invisible\n");
        this.setVisible(false);
        this.applet.destroy();
    }

    public Menus getMenus() {
        return this.menus;
    }

    private void activate() {
        this.toFront();
        this.setMenuBar(Menus.getMenuBar());
        Menus.updateMenus();
    }

    public void windowClosing(WindowEvent e) {
        this.quit();
    }

    public void windowActivated(WindowEvent e) {
        this.toFront();
        this.setMenuBar(Menus.getMenuBar());
        Menus.updateMenus();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void showStatus(String msg) {
        this.display.append(String.valueOf(msg) + "\n");
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public static void main(String[] args) {
        CryptoToolJ cda = new CryptoToolJ(null);
        cda.setSize(400, 700);
    }
}

