/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import applications.cryptotoolj.Tools;
import hcrypto.cipher.HistoricalKey;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class KeyDialog
extends Dialog
implements ItemListener {
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int WIDTH = 500;
    public static final int HEIGHT = 400;
    private int option;
    private HistoricalKey key;
    private String alphabet = "az";
    private StringBuffer alphaBuffer = new StringBuffer();
    private String keyText = "";
    private Checkbox[] checkbox;
    private String plainAlphas;
    private String cryptoAlphas;
    private Label keyLabel = new Label("Enter key: ");
    private Label plainLabel = new Label("Plaintext Alphabet: ");
    private Label cryptoLabel = new Label("Cryptotext Alphabet: ");
    private Label encodingLabel = new Label("File encoding: ");
    private Button OKButton;
    private Button CancelButton;
    private Panel TextAreaPanel;
    private Panel ButtonPanel;
    private Panel keyAPanel;
    private Panel dialogPanel;
    private Panel filePanel;
    private Panel alphabetPanel;
    private Panel alphabetPanel2;
    private TextField keyArea;
    private TextField plainOther = new TextField(40);
    private TextField cryptoOther = new TextField(40);
    private TextField encodingField = new TextField("Default encoding");
    private Checkbox azB;
    private Checkbox AZB;
    private Checkbox otherB;
    private Checkbox azAZ09B;
    private Checkbox printableB;
    private Checkbox asciiB;
    private Checkbox azB2;
    private Checkbox AZB2;
    private Checkbox otherB2;
    private Checkbox azAZ09B2;
    private Checkbox printableB2;
    private Checkbox asciiB2;

    public KeyDialog(Frame parent, String alphabets, String dialogTitle) {
        super(parent, true);
        this.plainAlphas = alphabets.substring(0, alphabets.indexOf("/"));
        this.cryptoAlphas = alphabets.substring(alphabets.indexOf("/") + 1);
        this.setTitle(dialogTitle);
        this.createKeyDialog();
    }

    public int showKeyDialog() {
        this.keyArea.setText(this.keyText);
        this.setSize(500, 400);
        this.pack();
        this.setVisible(true);
        Tools.centerWindow(this);
        return this.option;
    }

    public String getSelectedAlphabetChoice() {
        return this.alphabet;
    }

    public String getKeyAreaText() {
        return this.keyArea.getText();
    }

    public void setKeyText(String keyText) {
        this.keyText = keyText;
    }

    private void createKeyDialog() {
        this.TextAreaPanel = new Panel(new BorderLayout());
        this.keyAPanel = new Panel();
        this.ButtonPanel = new Panel();
        this.dialogPanel = new Panel(new BorderLayout());
        Panel aPanels = new Panel(new GridLayout(2, 1));
        this.alphabetPanel = new Panel();
        this.alphabetPanel2 = new Panel();
        this.filePanel = new Panel();
        this.filePanel.add(this.encodingLabel);
        this.filePanel.add(this.encodingField);
        this.OKButton = new Button("OK");
        this.CancelButton = new Button("Cancel");
        this.keyArea = new TextField(40);
        this.checkbox = new Checkbox[12];
        this.checkbox[0] = this.azB = new Checkbox("az");
        this.checkbox[1] = this.AZB = new Checkbox("AZ");
        this.checkbox[2] = this.azAZ09B = new Checkbox("09");
        this.checkbox[3] = this.printableB = new Checkbox("printable ASCII");
        this.checkbox[4] = this.asciiB = new Checkbox("All ASCII");
        this.checkbox[5] = this.otherB = new Checkbox("Other: Specify");
        this.checkbox[6] = this.azB2 = new Checkbox("az");
        this.checkbox[7] = this.AZB2 = new Checkbox("AZ");
        this.checkbox[8] = this.azAZ09B2 = new Checkbox("09");
        this.checkbox[9] = this.printableB2 = new Checkbox("printable ASCII");
        this.checkbox[10] = this.asciiB2 = new Checkbox("All ASCII");
        this.checkbox[11] = this.otherB2 = new Checkbox("Other: Specify");
        this.azB.setState(true);
        this.azB2.setState(true);
        this.setalphabets(this.plainAlphas, this.cryptoAlphas);
        this.keyAPanel.add(this.keyLabel);
        this.keyAPanel.add(this.keyArea);
        this.TextAreaPanel.add((Component)this.keyAPanel, "North");
        this.ButtonPanel.add(this.OKButton);
        this.ButtonPanel.add(this.CancelButton);
        this.dialogPanel.add((Component)this.TextAreaPanel, "North");
        aPanels.setLayout(new GridLayout(3, 1));
        aPanels.add(this.alphabetPanel);
        aPanels.add(this.alphabetPanel2);
        this.dialogPanel.add((Component)aPanels, "Center");
        this.dialogPanel.add((Component)this.ButtonPanel, "South");
        this.add(this.dialogPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                KeyDialog.this.option = 1;
                KeyDialog.this.setVisible(false);
            }

            public void windowOpened(WindowEvent evt) {
                KeyDialog.this.CancelButton.requestFocus();
            }
        });
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (KeyDialog.this.keyArea.getText().length() > 0) {
                    KeyDialog.this.option = 0;
                    KeyDialog.this.alphaBuffer = new StringBuffer();
                    if (KeyDialog.this.azB.getState()) {
                        KeyDialog.this.alphaBuffer.append("az+");
                    }
                    if (KeyDialog.this.AZB.getState()) {
                        KeyDialog.this.alphaBuffer.append("AZ+");
                    }
                    if (KeyDialog.this.azAZ09B.getState()) {
                        KeyDialog.this.alphaBuffer.append("09+");
                    }
                    if (KeyDialog.this.printableB.getState()) {
                        KeyDialog.this.alphaBuffer.append("printable+");
                    }
                    if (KeyDialog.this.asciiB.getState()) {
                        KeyDialog.this.alphaBuffer.append("ascii+");
                    }
                    if (!KeyDialog.this.plainOther.getText().equals("")) {
                        KeyDialog.this.alphaBuffer.append(String.valueOf(KeyDialog.this.plainOther.getText()) + "+");
                    }
                    KeyDialog.this.alphaBuffer.setCharAt(KeyDialog.this.alphaBuffer.length() - 1, '/');
                    if (KeyDialog.this.azB2.getState()) {
                        KeyDialog.this.alphaBuffer.append("az+");
                    }
                    if (KeyDialog.this.AZB2.getState()) {
                        KeyDialog.this.alphaBuffer.append("AZ+");
                    }
                    if (KeyDialog.this.azAZ09B2.getState()) {
                        KeyDialog.this.alphaBuffer.append("09+");
                    }
                    if (KeyDialog.this.printableB2.getState()) {
                        KeyDialog.this.alphaBuffer.append("printable+");
                    }
                    if (KeyDialog.this.asciiB2.getState()) {
                        KeyDialog.this.alphaBuffer.append("ascii+");
                    }
                    if (!KeyDialog.this.cryptoOther.getText().equals("")) {
                        KeyDialog.this.alphaBuffer.append(String.valueOf(KeyDialog.this.cryptoOther.getText()) + "+");
                    }
                    KeyDialog.this.alphabet = KeyDialog.this.alphaBuffer.toString().substring(0, KeyDialog.this.alphaBuffer.length() - 1);
                    KeyDialog.this.keyText = KeyDialog.this.keyArea.getText();
                    System.out.println("KeySpec: " + KeyDialog.this.keyText + "/" + KeyDialog.this.alphabet);
                    KeyDialog.this.setVisible(false);
                }
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KeyDialog.this.option = 1;
                KeyDialog.this.setVisible(false);
            }
        });
    }

    public void itemStateChanged(ItemEvent e) {
        Checkbox cb = (Checkbox)e.getSource();
        this.adjustCheckBoxes(cb);
    }

    private void adjustCheckBoxes(Checkbox cb) {
        String label = cb.getLabel();
        if (cb == this.azB || cb == this.AZB || cb == this.azAZ09B) {
            if (cb.getState()) {
                this.printableB.setState(false);
                this.asciiB.setState(false);
            }
        } else if (cb == this.printableB) {
            if (cb.getState()) {
                this.azB.setState(false);
                this.AZB.setState(false);
                this.azAZ09B.setState(false);
                this.asciiB.setState(false);
            }
        } else if (cb == this.asciiB && cb.getState()) {
            this.azB.setState(false);
            this.AZB.setState(false);
            this.azAZ09B.setState(false);
            this.printableB.setState(false);
        }
        if (cb == this.azB2 || cb == this.AZB2 || cb == this.azAZ09B2) {
            if (cb.getState()) {
                this.printableB2.setState(false);
                this.asciiB2.setState(false);
            }
        } else if (cb == this.printableB2) {
            if (cb.getState()) {
                this.azB2.setState(false);
                this.AZB2.setState(false);
                this.azAZ09B2.setState(false);
                this.asciiB2.setState(false);
            }
        } else if (cb == this.asciiB2 && cb.getState()) {
            this.azB2.setState(false);
            this.AZB2.setState(false);
            this.azAZ09B2.setState(false);
            this.printableB2.setState(false);
        }
        if (cb == this.otherB) {
            if (cb.getState()) {
                this.plainOther.setText("EG: Range.ai+Range.kz+UnicodeBlock.GREEK");
            } else {
                this.plainOther.setText("");
            }
        }
        if (cb == this.otherB2) {
            if (cb.getState()) {
                this.cryptoOther.setText("EG: Range.ai+Range.kz+UnicodeBlock.GREEK");
            } else {
                this.cryptoOther.setText("");
            }
        }
    }

    private void setalphabets(String plainAlphas, String cryptoAlphas) {
        this.alphabetPanel.add(this.plainLabel);
        int k = 0;
        while (k < plainAlphas.length()) {
            if (plainAlphas.charAt(k) == '1') {
                this.alphabetPanel.add(this.checkbox[k]);
            }
            this.checkbox[k].addItemListener(this);
            ++k;
        }
        if (plainAlphas.charAt(plainAlphas.length() - 1) == '1') {
            this.alphabetPanel.add(this.plainOther);
        }
        this.alphabetPanel2.add(this.cryptoLabel);
        k = 0;
        while (k < cryptoAlphas.length()) {
            if (cryptoAlphas.charAt(k) == '1') {
                this.alphabetPanel2.add(this.checkbox[plainAlphas.length() + k]);
            }
            this.checkbox[plainAlphas.length() + k].addItemListener(this);
            ++k;
        }
        if (cryptoAlphas.charAt(cryptoAlphas.length() - 1) == '1') {
            this.alphabetPanel2.add(this.cryptoOther);
        }
    }
}

