/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import applications.cryptotoolj.CipherFrame;
import applications.cryptotoolj.CryptoToolJ;
import applications.cryptotoolj.Tools;
import applications.cryptotoolj.WindowManager;
import java.applet.Applet;
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.io.File;

public class Menus {
    private static final int STATIC_WINDOW_MENU_ITEMS = 2;
    private static MenuBar mbar;
    private static CryptoToolJ ctj;
    private static Applet applet;
    public static Menu windowMenu;

    public Menus(CryptoToolJ ctg, Applet applet) {
        ctj = ctg;
        Menus.applet = applet;
    }

    public void addMenuBar() {
        Menu fileMenu = new Menu("File");
        this.addMenuItem(fileMenu, "New Cipher...", 78, false);
        this.addMenuItem(fileMenu, "Open File...", 79, false);
        this.addMenuItem(fileMenu, "Close Cipher...", 87, false);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, "Save", 83, false);
        this.addMenuItem(fileMenu, "Save As", 65, false);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, "Print", 80, false);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, "Quit", 81, false);
        Menu editMenu = new Menu("Edit");
        this.addMenuItem(editMenu, "Cut", 88, false);
        this.addMenuItem(editMenu, "Copy", 67, false);
        this.addMenuItem(editMenu, "Paste", 86, false);
        this.addMenuItem(editMenu, "Select All", 0, false);
        windowMenu = new Menu("Window");
        CheckboxMenuItem item = new CheckboxMenuItem("CryptoToolJ");
        windowMenu.add(item);
        item.setState(true);
        item.addActionListener(ctj);
        windowMenu.addSeparator();
        Menu helpMenu = new Menu("Help");
        this.addMenuItem(helpMenu, "About CryptoToolJ...", 0, false);
        mbar = new MenuBar();
        mbar.add(fileMenu);
        mbar.add(editMenu);
        mbar.add(windowMenu);
        mbar.add(this.createAnalysisMenu());
        mbar.setHelpMenu(helpMenu);
        ctj.setMenuBar(mbar);
    }

    private Menu createAnalysisMenu() {
        Menu analysisMenu = new Menu("Analysis");
        this.addMenuItem(analysisMenu, "Index Of Coincidence", 73, false);
        this.addMenuItem(analysisMenu, "Text Histogram", 72, false);
        this.addMenuItem(analysisMenu, "English FAQ", 81, false);
        this.addMenuItem(analysisMenu, "Pattern Word Searcher", 87, false);
        analysisMenu.addSeparator();
        this.addMenuItem(analysisMenu, "Affine Analyzer", 70, false);
        this.addMenuItem(analysisMenu, "Caesar Analyzer", 82, false);
        this.addMenuItem(analysisMenu, "Vigenere Analyzer", 71, false);
        analysisMenu.addSeparator();
        this.addMenuItem(analysisMenu, "Digram Substitution Analyzer", 85, false);
        this.addMenuItem(analysisMenu, "Ngram GA Substitution Analyzer", 0, false);
        this.addMenuItem(analysisMenu, "WordBased Substitution Analyzer", 0, false);
        this.addMenuItem(analysisMenu, "WordBased GA Substitution Analyzer", 0, false);
        analysisMenu.addSeparator();
        if (applet == null) {
            this.addPluginAnalyzers(analysisMenu);
        }
        return analysisMenu;
    }

    private void addPluginAnalyzers(Menu m) {
        String className = "";
        try {
            System.out.println("Analyzers should be here: " + Tools.getAnalyzerDirectory());
            File file = new File(Tools.getAnalyzerDirectory());
            String[] analyzers = file.list();
            if (analyzers != null) {
                int k = 0;
                while (k < analyzers.length) {
                    className = analyzers[k];
                    if (className.endsWith("Analyzer.class")) {
                        String menuName = className.substring(0, className.indexOf("."));
                        Menus.ctj.display.append("Adding plugin analyzer: " + menuName + "\n");
                        this.addMenuItem(m, menuName, 0, false);
                    }
                    ++k;
                }
            } else {
                Menus.ctj.display.append("No analyzers found\n");
                System.out.println("No analyzers found");
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    void addMenuItem(Menu menu, String label, int shortcut, boolean shift) {
        MenuItem item = shortcut == 0 ? new MenuItem(label) : (shift ? new MenuItem(label, new MenuShortcut(shortcut, true)) : new MenuItem(label, new MenuShortcut(shortcut)));
        item.setActionCommand(label);
        menu.add(item);
        item.addActionListener(ctj);
    }

    public static MenuBar getMenuBar() {
        return mbar;
    }

    public static void updateMenus() {
        CheckboxMenuItem item = null;
        int nItems = windowMenu.getItemCount();
        CipherFrame cf = WindowManager.getActiveCipherFrame();
        if (cf != null) {
            item = (CheckboxMenuItem)windowMenu.getItem(0);
            item.setState(false);
            int i = 2;
            while (i < nItems) {
                item.setState((item = (CheckboxMenuItem)windowMenu.getItem(i)).getLabel().indexOf(cf.getWindowId()) != -1);
                ++i;
            }
            return;
        }
        item = (CheckboxMenuItem)windowMenu.getItem(0);
        item.setState(true);
        int i = 2;
        while (i < nItems) {
            item = (CheckboxMenuItem)windowMenu.getItem(i);
            item.setState(false);
            ++i;
        }
    }

    public static void extendWindowMenu(String name) {
        if (ctj == null) {
            return;
        }
        CheckboxMenuItem item = new CheckboxMenuItem(name);
        item.addActionListener(ctj);
        item.setState(true);
        windowMenu.add(item);
        item = (CheckboxMenuItem)windowMenu.getItem(0);
        item.setState(false);
    }

    public static void trimWindowMenu(String id) {
        int k = 2;
        while (k < windowMenu.getItemCount()) {
            CheckboxMenuItem item = (CheckboxMenuItem)windowMenu.getItem(k);
            if (item.getLabel().indexOf(id) != -1) {
                windowMenu.remove(item);
                return;
            }
            ++k;
        }
    }
}

