/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import applications.cryptotoolj.FileSaveMessageDialog;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.border.TitledBorder;

public class TextAreaPlus
extends TextArea
implements TextListener,
FocusListener {
    private File file = null;
    private boolean dirty = false;
    private boolean fileOpened = false;
    private boolean initializedText = false;
    private boolean inFocus = false;
    private Frame frame;
    private TitledBorder mBorder;

    public TextAreaPlus() {
    }

    public TextAreaPlus(Frame parent, String name, TitledBorder border) {
        this.frame = parent;
        this.setName(name);
        this.setText(name);
        this.addTextListener(this);
        this.addFocusListener(this);
        this.mBorder = border;
        this.dirty = false;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void openFile(String encoding) {
        FileDialog fd = new FileDialog(this.frame, "Open File", 0);
        fd.show();
        String fileName = fd.getFile();
        String dirName = fd.getDirectory();
        if (fileName != null) {
            try {
                File file = new File(dirName, fileName);
                this.setFile(file);
                InputStreamReader inStream = null;
                inStream = encoding.startsWith("default") ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                int length = (int)file.length();
                char[] input = new char[length];
                inStream.read(input);
                String encodedS = new String(input);
                this.setText(encodedS);
                String txt = this.getText();
                inStream.close();
                this.fileOpened = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                System.err.println("IOERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void setText(String s) {
        super.setText("");
        int k = 0;
        while (k < s.length()) {
            char ch = s.charAt(k);
            char chint = s.charAt(k);
            if (chint <= '\u007f') {
                this.append("" + ch);
            } else {
                this.append("\\u" + Integer.toHexString(chint));
            }
            ++k;
        }
    }

    public String getText() {
        String s = super.getText();
        return s;
    }

    public int saveToFile() {
        FileSaveMessageDialog fsmd = new FileSaveMessageDialog(this.frame, "Save " + this.getName() + " to File?");
        int result = fsmd.getResult();
        fsmd.dispose();
        return result;
    }

    public boolean save(String file_encoding, boolean rename) {
        FileDialog fd = new FileDialog(this.frame, "Save " + this.getName() + "?", 1);
        if (this.file != null) {
            fd.setFile(this.file.getName());
        }
        fd.show();
        String fileName = fd.getFile();
        String dirName = fd.getDirectory();
        if (fileName == null) {
            return false;
        }
        if (fileName != null) {
            try {
                this.file = new File(dirName, fileName);
                OutputStreamWriter outStream = null;
                if (file_encoding.startsWith("Default")) {
                    outStream = new OutputStreamWriter(new FileOutputStream(this.file));
                } else {
                    System.out.println("Using file encoding: " + file_encoding);
                    outStream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), file_encoding);
                }
                String text = this.getText();
                outStream.write(text, 0, text.length());
                outStream.close();
                this.dirty = false;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                System.err.println("IOERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public synchronized void markFileSaved() {
        this.dirty = false;
    }

    public boolean isInFocus() {
        return this.inFocus;
    }

    public File getFile() {
        return this.file;
    }

    public synchronized void textValueChanged(TextEvent e) {
        if (this.initializedText) {
            this.dirty = true;
        } else {
            this.initializedText = true;
        }
        if (this.fileOpened) {
            this.dirty = false;
            this.fileOpened = false;
        }
    }

    public void focusLost(FocusEvent e) {
        this.inFocus = false;
        this.mBorder.setTitleColor(Color.black);
        this.mBorder.setTitle(this.mBorder.getTitle().substring(0, this.mBorder.getTitle().indexOf("(")));
        this.frame.repaint();
    }

    public void focusGained(FocusEvent e) {
        this.inFocus = true;
        this.mBorder.setTitleColor(Color.green);
        this.frame.repaint();
        this.mBorder.setTitle(String.valueOf(this.mBorder.getTitle()) + "(Active)");
    }
}

