/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import applications.cryptotoolj.CipherFrame;
import applications.cryptotoolj.CryptoToolJ;
import applications.cryptotoolj.WindowManager;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class TextManager
implements ClipboardOwner {
    private static String appletClip = null;

    public static void copyText(boolean cut) {
        CipherFrame cf = WindowManager.getActiveCipherFrame();
        CryptoToolJ ctj = WindowManager.getCryptoTool();
        TextArea tf = null;
        String selection = null;
        if (cf != null) {
            tf = cf.getTextAreaWithFocus();
            if (tf == null) {
                return;
            }
        } else {
            boolean isActiveWindow;
            if (cut) {
                ctj.showStatus("Cuts not allowed in CryptoToolJ");
                return;
            }
            boolean bl = isActiveWindow = ctj.getFocusOwner() != null;
            if (!isActiveWindow) {
                ctj.showStatus("CTJ not in focus");
                return;
            }
            tf = ctj.display;
        }
        if (!ctj.isApplet()) {
            Clipboard clip = ctj.getToolkit().getSystemClipboard();
            if (clip == null) {
                ctj.showStatus("Clipboard null");
                return;
            }
            selection = tf.getSelectedText();
            StringSelection cont = new StringSelection(selection);
            clip.setContents(cont, ctj);
        } else {
            selection = tf.getSelectedText();
            appletClip = tf.getSelectedText();
        }
        if (selection.length() > 0) {
            ctj.showStatus(String.valueOf(selection.length()) + " characters copied to clipboard");
        }
        if (cut) {
            tf.replaceRange("", tf.getSelectionStart(), tf.getSelectionEnd());
        }
    }

    public static void pasteText() {
        CipherFrame cf = WindowManager.getActiveCipherFrame();
        CryptoToolJ ctj = WindowManager.getCryptoTool();
        TextArea tf = null;
        tf = cf != null ? cf.getTextAreaWithFocus() : ctj.display;
        if (tf == null) {
            return;
        }
        if (!ctj.isApplet()) {
            Clipboard clip = ctj.getToolkit().getSystemClipboard();
            if (clip == null) {
                return;
            }
            Transferable contents = clip.getContents(ctj);
            try {
                String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                tf.replaceRange(text, tf.getSelectionStart(), tf.getSelectionEnd());
            }
            catch (Exception exception) {}
        } else {
            if (appletClip == null) {
                return;
            }
            String text = appletClip;
            tf.replaceRange(text, tf.getSelectionStart(), tf.getSelectionEnd());
        }
    }

    public static void selectAll() {
        TextArea tf = null;
        CipherFrame cf = WindowManager.getActiveCipherFrame();
        CryptoToolJ ctj = WindowManager.getCryptoTool();
        tf = cf != null ? cf.getTextAreaWithFocus() : ctj.display;
        if (tf == null) {
            return;
        }
        tf.selectAll();
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }
}

