/*
 * Decompiled with CFR 0.152.
 */
package applications.cryptotoolj;

import applications.cryptotoolj.CipherFrame;
import applications.cryptotoolj.CryptoToolJ;
import applications.cryptotoolj.Menus;
import java.applet.Applet;
import java.util.Vector;

public class WindowManager {
    private static Vector windowList = new Vector();
    private static int id = 1001;
    private static CryptoToolJ ctj;
    private static Applet applet;

    public static void init(CryptoToolJ cryptotool, Applet appletIn) {
        ctj = cryptotool;
        applet = appletIn;
    }

    public static CryptoToolJ getCryptoTool() {
        return ctj;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static CipherFrame getActiveCipherFrame() {
        int k = 0;
        while (k < windowList.size()) {
            CipherFrame cf = (CipherFrame)windowList.elementAt(k);
            if (cf.isActivated) {
                return cf;
            }
            ++k;
        }
        return null;
    }

    public static int getWindowCount() {
        return windowList.size();
    }

    public static synchronized void addWindow(CipherFrame win) {
        windowList.addElement(win);
        win.setWindowId(id);
        String idStr = "" + id;
        ++id;
        Menus.extendWindowMenu("CipherFrame " + idStr);
        win.renameWithWindowId(idStr);
    }

    public static synchronized void removeWindow(CipherFrame win) {
        int index = windowList.indexOf(win);
        if (index == -1) {
            return;
        }
        Menus.trimWindowMenu(win.getWindowId());
        windowList.removeElementAt(index);
    }

    public static synchronized boolean closeAllWindows() {
        int k = 0;
        while (k < windowList.size()) {
            CipherFrame cf = (CipherFrame)windowList.elementAt(k);
            if (!cf.close()) {
                return false;
            }
            ++k;
        }
        return true;
    }

    static synchronized void activateWindow(String menuItemLabel) {
        int i = 0;
        while (i < windowList.size()) {
            CipherFrame win = (CipherFrame)windowList.elementAt(i);
            String id = win.getWindowId();
            if (menuItemLabel.indexOf(id) != -1) {
                win.activate();
                break;
            }
            ++i;
        }
    }
}

