/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.ExpertAnalyzer;
import hcrypto.analyzer.tool.FrequencyTable;
import hcrypto.analyzer.tool.TextStatistics;
import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.AffineKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;

public class AffineAnalyzer
extends CryptoAnalyzer
implements ExpertAnalyzer {
    private String text;
    private StringBuffer resultSB;
    private FrequencyTable ft;
    private TextStatistics stats = null;
    private int minA;
    private int minB;
    private AnalyzerFrame mFrame;

    public AffineAnalyzer() {
    }

    public AffineAnalyzer(AnalyzerFrame f) {
        this.mFrame = f;
    }

    public AffineAnalyzer(TextStatistics ts) throws NullPointerException {
        this.stats = ts;
        if (ts == null) {
            throw new NullPointerException("CaesarAnalyzer: TextStatistics object is not instantiated");
        }
    }

    public void setup(String text) {
        this.stats = new TextStatistics(text, true);
        this.text = text.toLowerCase();
        this.resultSB = new StringBuffer();
        this.ft = this.stats.getFrequencyTable();
        if (this.mFrame != null) {
            this.mFrame.append("Affine Analyzer: Begin Analysis\n");
        } else {
            System.out.println("Affine Analyzer: Begin Analysis\n");
        }
    }

    public void run() {
        this.doAnalysis();
        if (this.mFrame != null) {
            this.mFrame.append(this.getReport());
        } else {
            System.out.println(this.getReport());
        }
    }

    public String getReport() {
        return this.toString();
    }

    public String getKeywordString() {
        return String.valueOf(this.minA) + "," + this.minB;
    }

    public String toString() {
        return this.resultSB.toString();
    }

    public void doAnalysis(String text) {
        this.stats = new TextStatistics(text, true);
        this.text = text.toLowerCase();
        this.resultSB = new StringBuffer();
        this.ft = this.stats.getFrequencyTable();
        if (this.mFrame != null) {
            this.mFrame.append("Affine Analyzer: Begin Analysis\n");
        } else {
            System.out.println("Affine Analyzer: Begin Analysis\n");
        }
        this.doAnalysis();
    }

    public void doAnalysis() {
        try {
            Provider.addProvider(new DefaultProvider("Default"));
            this.minA = 0;
            this.minB = 0;
            double minChiSqr = Double.MAX_VALUE;
            int b = 0;
            while (b < 26) {
                int a = 1;
                while (a < 26) {
                    if (a != 13) {
                        Cipher cipher = Cipher.getInstance("Affine", "Default");
                        AffineKey key = (AffineKey)HistoricalKey.getInstance("Affine", "Default");
                        key.init(String.valueOf(a) + "," + b + "/az");
                        cipher.init(key);
                        String decryption = this.text.length() <= 5000 ? cipher.decrypt(this.text) : cipher.decrypt(this.text.substring(0, 5000));
                        double chiSquare = this.getChiSquare(decryption);
                        if (chiSquare < minChiSqr) {
                            this.minA = a;
                            this.minB = b;
                            minChiSqr = chiSquare;
                        }
                    }
                    a += 2;
                }
                ++b;
            }
            Cipher cipher = Cipher.getInstance("Affine", "Default");
            AffineKey key = (AffineKey)HistoricalKey.getInstance("Affine", "Default");
            key.init(String.valueOf(this.minA) + "," + this.minB + "/az");
            cipher.init(key);
            String decryption = this.text.length() <= 5000 ? cipher.decrypt(this.text) : cipher.decrypt(this.text.substring(0, 5000));
            this.resultSB.append("\nHere's a possible decryption for A = " + this.minA + " and B = " + this.minB + " \n");
            this.resultSB.append(String.valueOf(decryption) + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getChiSquare(String text) {
        double chi = 0.0;
        int[] tFreqs = new int[26];
        char k = '\u0000';
        while (k < '\u001a') {
            tFreqs[k] = 0;
            ++k;
        }
        k = '\u0000';
        while (k < text.length()) {
            char ch = text.charAt(k);
            if (Character.isLetter(ch)) {
                ch = Character.toLowerCase(ch);
                int n = ch - 97;
                tFreqs[n] = tFreqs[n] + 1;
            }
            ++k;
        }
        k = 'a';
        while (k <= 'z') {
            double freq = TextStatistics.getEnglishFrequency(k) - (double)tFreqs[k - 97];
            freq *= freq;
            chi += (freq /= TextStatistics.getEnglishFrequency(k));
            k = (char)(k + '\u0001');
        }
        return chi;
    }
}

