/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.ExpertAnalyzer;
import hcrypto.analyzer.tool.FrequencyTable;
import hcrypto.analyzer.tool.TextStatistics;
import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.CaesarKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;

public class CaesarAnalyzer
extends CryptoAnalyzer
implements ExpertAnalyzer {
    private String text;
    private StringBuffer resultSB;
    private FrequencyTable ft;
    private AnalyzerFrame mFrame;
    private int shift;
    private TextStatistics stats = null;

    public CaesarAnalyzer() {
    }

    public CaesarAnalyzer(AnalyzerFrame f) {
        this.mFrame = f;
    }

    public CaesarAnalyzer(TextStatistics ts) throws NullPointerException {
        this.stats = ts;
        if (ts == null) {
            throw new NullPointerException("CaesarAnalyzer: TextStatistics object is not instantiated");
        }
    }

    public void setup(String text) {
        this.stats = new TextStatistics(text, true);
        this.text = text.toLowerCase();
        this.resultSB = new StringBuffer();
        this.ft = this.stats.getFrequencyTable();
        if (this.mFrame != null) {
            this.mFrame.append("Caesar Analyzer: Begin Analysis\n");
        } else {
            System.out.println("Caesar Analyzer: Begin Analysis\n");
        }
    }

    public void run() {
        this.doAnalysis();
        if (this.mFrame != null) {
            this.mFrame.append(String.valueOf(this.resultSB.toString()) + "\n");
        } else {
            System.out.println(this.resultSB.toString());
        }
    }

    public String getReport() {
        return this.toString();
    }

    public String getKeywordString() {
        return String.valueOf(this.shift);
    }

    public String toString() {
        return this.resultSB.toString();
    }

    public void doAnalysis(String text) {
        this.stats = new TextStatistics(text, true);
        this.text = text.toLowerCase();
        this.resultSB = new StringBuffer();
        this.ft = this.stats.getFrequencyTable();
        if (this.mFrame != null) {
            this.mFrame.append("Caesar Analyzer: Begin Analysis\n");
        } else {
            System.out.println("Caesar Analyzer: Begin Analysis\n");
        }
        this.doAnalysis();
    }

    public void doAnalysis() {
        this.shift = this.getOptimalShift();
        this.resultSB.append("\nIf this is Caesar cipher, a possible shift is " + this.shift + "\n");
        try {
            this.resultSB.append("Here's a decryption based on a shift of " + this.shift + "\n\n");
            Provider.addProvider(new DefaultProvider("Default"));
            Cipher c = Cipher.getInstance("Caesar");
            CaesarKey key = (CaesarKey)HistoricalKey.getInstance("Caesar", c.getProvider());
            key.init(String.valueOf(this.shift) + "/az");
            c.init(key);
            if (this.text.length() <= 5000) {
                this.resultSB.append(String.valueOf(c.decrypt(this.text)) + "\n");
            } else {
                this.resultSB.append(String.valueOf(c.decrypt(this.text.substring(0, 5000))) + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getOptimalShift() {
        return this.getOptimalShift(0, 1);
    }

    public int getOptimalShift(int firstChar, int displ) {
        String text = this.text;
        double[] tChiSqrs = new double[26];
        int[] tFreqs = new int[26];
        int k = 0;
        while (k < 26) {
            tFreqs[k] = 0;
            ++k;
        }
        k = 0;
        while (k < 26) {
            tChiSqrs[k] = 0.0;
            ++k;
        }
        k = firstChar;
        while (k < text.length()) {
            char ch = text.charAt(k);
            if (Character.isLetter(ch)) {
                ch = Character.toLowerCase(ch);
                int n = ch - 97;
                tFreqs[n] = tFreqs[n] + 1;
            }
            k += displ;
        }
        int j = 0;
        while (j < 26) {
            char k2 = 'a';
            while (k2 <= 'z') {
                int index = (k2 - 97 + j) % 26;
                double freq = TextStatistics.getEnglishFrequency(k2) - (double)tFreqs[index];
                freq *= freq;
                tChiSqrs[j] = tChiSqrs[j] + (freq /= TextStatistics.getEnglishFrequency(k2));
                k2 = (char)(k2 + '\u0001');
            }
            ++j;
        }
        return TextStatistics.getIndexOfMinimum(tChiSqrs);
    }
}

