/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.Analyzer;
import hcrypto.analyzer.evolutionary.GaParameters;
import java.text.NumberFormat;

public class CryptoAnalyzer
implements Analyzer,
Runnable {
    public static final int SIMPLESUB = 0;
    public static final int PERMUTATION = 1;
    public static final int RAILFENCE = 2;
    public static final int PLAYFAIR = 3;
    protected GaParameters params;
    protected AnalyzerFrame display;
    protected String text;
    protected String name;
    protected String solution = "";
    protected StringBuffer resultSB;
    protected NumberFormat num;
    protected int keyCount = 0;
    protected boolean stopThread = false;

    public CryptoAnalyzer() {
    }

    public CryptoAnalyzer(GaParameters params) {
        this.params = params;
    }

    public void setup(String text, AnalyzerFrame f) {
        this.display = f;
        this.setup(text);
    }

    public void setup(String text) {
        this.num = NumberFormat.getInstance();
        this.num.setMaximumFractionDigits(2);
        if (text.indexOf("$$$") != -1) {
            this.solution = text.substring(text.indexOf("$$$") + 3);
            this.text = text.substring(0, text.indexOf("$$$"));
        } else {
            this.text = text;
            this.solution = new String();
        }
        if (this.text.length() > this.params.text_limit) {
            this.text = String.valueOf(this.text.substring(0, this.params.text_limit)) + " ";
            this.text = this.text.substring(0, this.text.lastIndexOf(32)).toLowerCase();
        } else {
            this.text = this.text.toLowerCase();
        }
        this.resultSB = new StringBuffer();
    }

    protected void reportMissingLetters(String s) {
        System.out.print("The following letters are missing from the text: ");
        int k = 0;
        while (k < 26) {
            char ch = (char)(97 + k);
            if (s.indexOf(ch) == -1) {
                System.out.print(String.valueOf(ch) + " ");
            }
            ++k;
        }
        System.out.println();
    }

    public void run() {
    }

    public void stopThread() {
        this.stopThread = true;
    }

    public boolean threadIsStopped() {
        return this.stopThread;
    }

    public String getReport() {
        return this.toString();
    }

    public String toString() {
        return this.resultSB.toString();
    }

    public static String prettyPrint(String s, int linelen) {
        boolean brk = false;
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            sb.append(s.charAt(k));
            if (k != 0 && k % linelen == 0) {
                brk = true;
            }
            if (brk && s.charAt(k) < 'a' || s.charAt(k) > 'z') {
                sb.append('\n');
                brk = false;
            }
            ++k;
        }
        return sb.toString();
    }
}

