/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.tool.FrequencyRecord;
import hcrypto.analyzer.tool.FrequencyTable;
import hcrypto.analyzer.tool.TextStatistics;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;

public class DigramAnalyzer
extends CryptoAnalyzer {
    private static final int MAX_KEY = 27;
    private String text;
    private String preparedText;
    private StringBuffer resultSB;
    private FrequencyTable ft;
    private DateFormat dateformat = DateFormat.getTimeInstance(1);
    private FrequencyRecord[] eng_freqs;
    private FrequencyRecord[] crypto_freqs;
    private double[][] english_digrams;
    private double[][] crypto_digrams;
    private int[] v_crypt;
    private int[] v_engl;
    private int[] d_key;
    private StringBuffer encipherKey;
    private long time0 = System.currentTimeMillis();
    private TextStatistics stats = null;
    private AnalyzerFrame mFrame;

    public DigramAnalyzer() {
        this.resultSB = new StringBuffer();
    }

    public DigramAnalyzer(AnalyzerFrame f) {
        this.resultSB = new StringBuffer();
        this.mFrame = f;
    }

    public DigramAnalyzer(TextStatistics ts) throws NullPointerException {
        this.stats = ts;
        this.resultSB = new StringBuffer();
        if (ts == null) {
            throw new NullPointerException("DigramAnalyzer: TextStatistics object is not instantiated");
        }
    }

    public void setup(String text) {
        this.text = text;
        this.preparedText = text.toLowerCase();
        this.ft = new FrequencyTable(this.preparedText, 6);
        this.preparedText = this.cleanText(this.preparedText);
        this.crypto_freqs = this.ft.getSortedCryptogramFrequencies();
        this.crypto_freqs[26].ch = (char)123;
        this.freqPrint("CRYPTO: ", this.crypto_freqs);
        this.v_crypt = this.makeMap(this.crypto_freqs);
        this.alphaPrint("MAP_CRYPT: ", this.v_crypt);
        this.eng_freqs = this.makeEnglishDigramTable(this.ft);
        this.freqPrint("ENGLISH: ", this.eng_freqs);
        this.v_engl = this.makeMap(this.eng_freqs);
        this.alphaPrint("MAP_ENGL: ", this.v_engl);
        this.d_key = this.initKey(this.v_crypt, this.v_engl);
        this.initDigramTables(this.eng_freqs, this.crypto_freqs);
    }

    private String cleanText(String text) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < text.length()) {
            char ch = text.charAt(k);
            if (ch == ' ') {
                sb.append('{');
            } else if (ch >= 'a' && ch <= 'z') {
                sb.append(ch);
            } else {
                System.out.println("Illegal char: " + ch);
                sb.append('{');
            }
            ++k;
        }
        return sb.toString();
    }

    private void initDigramTables(FrequencyRecord[] eng_freqs, FrequencyRecord[] crypto_freqs) {
        int total_chars = 107199;
        int[][] digram_data = TextStatistics.digram_data;
        this.crypto_digrams = new double[27][27];
        this.english_digrams = new double[27][27];
        int j = 0;
        while (j < 27) {
            int k = 0;
            while (k < 27) {
                this.english_digrams[j][k] = 1.0 * (double)digram_data[j][k] / (double)total_chars;
                this.crypto_digrams[j][k] = 0.0;
                ++k;
            }
            ++j;
        }
        String decrypt = this.decrypt(false);
        double incr = 1.0 / (double)(this.preparedText.length() - 1);
        int k = 1;
        while (k < decrypt.length()) {
            char ch1 = decrypt.charAt(k - 1);
            char ch2 = decrypt.charAt(k);
            double[] dArray = this.crypto_digrams[ch1 - 97];
            int n = ch2 - 97;
            dArray[n] = dArray[n] + incr;
            ++k;
        }
    }

    private int[] makeMap(FrequencyRecord[] freqs) {
        int[] map = new int[27];
        int j = 0;
        int k = freqs.length - 1;
        while (k >= 0) {
            map[j++] = freqs[k].ch - 97;
            --k;
        }
        map[0] = 26;
        return map;
    }

    private FrequencyRecord[] makeEnglishDigramTable(FrequencyTable ft) {
        Object[] freqs = new FrequencyRecord[27];
        int count = ft.getCharCount();
        freqs[0] = new FrequencyRecord('{', (int)Math.round(0.25 * (double)count));
        char ch = 'a';
        while (ch <= 'z') {
            freqs[ch - 97 + 1] = new FrequencyRecord(ch, (int)Math.round(TextStatistics.englishFrequency[ch] * (double)count));
            ch = (char)(ch + '\u0001');
        }
        Arrays.sort(freqs);
        return freqs;
    }

    private int[] initKey(int[] map_c, int[] map_e) {
        this.d_key = new int[27];
        int k = 0;
        while (k < 26) {
            this.d_key[k] = k;
            ++k;
        }
        this.d_key[26] = 26;
        this.alphaPrint("KEY: ", this.d_key);
        return this.d_key;
    }

    private void alphaPrint(String prompt, int[] arr) {
        System.out.print(prompt);
        int k = 0;
        while (k < arr.length) {
            System.out.print((char)(97 + arr[k]));
            ++k;
        }
        System.out.println();
    }

    private void freqPrint(String prompt, FrequencyRecord[] f) {
        System.out.println(prompt);
        int k = 0;
        while (k < f.length) {
            System.out.print(String.valueOf(f[k].ch) + ":" + f[k].count + ", ");
            ++k;
        }
        System.out.println();
        System.out.println();
    }

    public void run() {
        this.resultSB.append(String.valueOf(this.dateformat.format(new Date())) + "\n");
        this.doAnalysis();
    }

    public String getReport() {
        return this.toString();
    }

    public String toString() {
        return this.resultSB.toString();
    }

    private double getScore() {
        double sum = 0.0;
        int j = 0;
        while (j < this.crypto_digrams.length) {
            int k = 0;
            while (k < this.crypto_digrams.length) {
                sum += Math.abs(this.crypto_digrams[j][k] - this.english_digrams[this.d_key[j]][this.d_key[k]]);
                ++k;
            }
            ++j;
        }
        return sum;
    }

    public String decrypt(boolean replace_brace) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < this.preparedText.length()) {
            char ch = this.preparedText.charAt(k);
            if (ch == '{') {
                if (replace_brace) {
                    sb.append(' ');
                } else {
                    sb.append(ch);
                }
            } else {
                sb.append((char)(97 + this.d_key[ch - 97]));
            }
            ++k;
        }
        return sb.toString();
    }

    private void swap(int[] arr, int a, int b) {
        int ka = 0;
        while (ka < arr.length && arr[ka] != a) {
            ++ka;
        }
        int kb = 0;
        while (kb < arr.length && arr[kb] != b) {
            ++kb;
        }
        if (ka < arr.length && kb < arr.length) {
            int temp = arr[ka];
            arr[ka] = arr[kb];
            arr[kb] = temp;
        }
    }

    public void doAnalysis() {
        double bestscore = this.getScore();
        double score = 0.0;
        int count = 0;
        int swap_count = 0;
        System.out.println("SCORE= " + bestscore);
        int a = 1;
        int b = 1;
        int alpha = 0;
        int beta = 0;
        while (count < 3000 && b < 26) {
            alpha = this.v_crypt[a];
            beta = this.v_crypt[a + b];
            this.swap(this.d_key, alpha, beta);
            score = this.getScore();
            if (score < bestscore) {
                System.out.print("SCORE= " + score + " alpha=" + (char)(alpha + 97) + " beta=" + (char)(beta + 97));
                this.alphaPrint("  KEY: ", this.d_key);
                a = 1;
                b = 1;
                bestscore = score;
                count = 0;
                ++swap_count;
                continue;
            }
            this.swap(this.d_key, alpha, beta);
            ++count;
            if (++a + b <= 26) continue;
            a = 1;
            ++b;
        }
        this.alphaPrint("MAP_CRYPT: ", this.v_crypt);
        this.alphaPrint("KEY:", this.d_key);
        this.resultSB.append("DONE:  swap_count= " + swap_count + " count= " + count + " b= " + b + "\n");
        this.resultSB.append("TEXT: \n");
        this.resultSB.append(String.valueOf(this.text) + "\n\n");
        this.resultSB.append("DECRYPT: \n");
        this.resultSB.append(String.valueOf(DigramAnalyzer.prettyPrint(this.decrypt(true), 40)) + "\n");
        this.resultSB.append("Time Used = " + (System.currentTimeMillis() - this.time0) + "ms");
        if (this.mFrame != null) {
            this.mFrame.setText(this.resultSB.toString());
        }
    }
}

