/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.ExpertAnalyzer;
import hcrypto.analyzer.tool.KasiskiRecord;
import hcrypto.analyzer.tool.TextStatistics;
import hcrypto.cipher.Alphabet;
import hcrypto.cipher.AlphabetFactory;
import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.VigenereKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;
import java.text.NumberFormat;

public class VigenereAnalyzer
extends CryptoAnalyzer
implements ExpertAnalyzer {
    public static final int MAX_BIGRAMS = 10000;
    public static final int MAX_FACTORS = 10000;
    public static final int MAX_KEYWORD = 200;
    public static final int MAX_CONTACT = 26;
    public static final double SUPERPOSNUMBER = 6.0;
    protected int[][] contacts = new int[26][26];
    protected int keywordLengthEstStat = 0;
    protected int keywordLengthEstKasiski = 0;
    protected int nRepeatedBigrams = 0;
    protected int nSuperDisplacements = 0;
    protected int[] kasiskiFactors = new int[10000];
    protected int[] superFactors = new int[10000];
    protected int[] superDispl = new int[200];
    private KasiskiRecord[] bigrams = new KasiskiRecord[10000];
    private Alphabet alphabet;
    private String text;
    private String originalText;
    private StringBuffer resultSB;
    private AnalyzerFrame mFrame;
    private String keyword;
    private TextStatistics stats = null;

    public VigenereAnalyzer() {
    }

    public VigenereAnalyzer(AnalyzerFrame f) {
        this.mFrame = f;
    }

    public VigenereAnalyzer(TextStatistics ts) throws NullPointerException {
        this.stats = ts;
        if (ts == null) {
            throw new NullPointerException("CaesarAnalyzer: TextStatistics object is not instantiated");
        }
    }

    public void setup(String s) {
        this.stats = new TextStatistics(s, true);
        this.originalText = s;
        try {
            this.alphabet = AlphabetFactory.getInstance(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.text = TextStatistics.removeNonAlphabetics(s, this.alphabet);
        this.resultSB = new StringBuffer();
        if (this.mFrame != null) {
            this.mFrame.append("Vigenere Analyzer: Begin Analysis\n");
        } else {
            System.out.println("Vigenere Analyzer: Begin Analysis\n");
        }
    }

    public void run() {
        this.doAnalysis();
        if (this.mFrame != null) {
            this.mFrame.append(this.getReport());
        } else {
            System.out.println(this.getReport());
        }
    }

    public String getReport() {
        return this.resultSB.toString();
    }

    protected void insertBigram(char ch1, char ch2, int displ) {
        if (this.nRepeatedBigrams < 10000) {
            this.bigrams[this.nRepeatedBigrams] = new KasiskiRecord(new String("" + ch1 + ch2), displ);
            ++this.nRepeatedBigrams;
        }
    }

    protected String retrieveBigram(int k) {
        if (k < this.nRepeatedBigrams) {
            return String.valueOf(this.bigrams[k].bigram) + " " + this.bigrams[k].displ;
        }
        return "RetrieveBigramK: Invalid value of k " + k;
    }

    public void computeSuperpositionAnalysis(String s) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        int displ = 1;
        while (displ <= 200) {
            int nCoincidences = 0;
            int nComparisons = 0;
            int k = displ;
            while (k < this.text.length()) {
                ++nComparisons;
                if (this.text.charAt(k) == this.text.charAt(k - displ)) {
                    ++nCoincidences;
                }
                ++k;
            }
            double percent = 100.0 * (double)nCoincidences / (double)nComparisons;
            long nExpected = Math.round(0.0667 * (double)nComparisons);
            if (percent > 6.0) {
                this.superDispl[this.nSuperDisplacements] = displ;
                ++this.nSuperDisplacements;
            }
            ++displ;
        }
    }

    public void computeBigramDistances(String s) {
        int k = 0;
        while (k < s.length() - 1) {
            char ch1 = s.charAt(k);
            char ch2 = s.charAt(k + 1);
            if (Character.isLetter(ch1) && Character.isLetter(ch2)) {
                if (this.contacts[(ch1 = Character.toLowerCase(ch1)) - 97][(ch2 = Character.toLowerCase(ch2)) - 97] == 0) {
                    this.contacts[ch1 - 97][ch2 - 97] = -k;
                } else if (this.contacts[ch1 - 97][ch2 - 97] < 0) {
                    this.insertBigram(ch1, ch2, k + this.contacts[ch1 - 97][ch2 - 97]);
                    this.contacts[ch1 - 97][ch2 - 97] = -k;
                }
            }
            ++k;
        }
    }

    public String getKeywordString() {
        return this.keyword;
    }

    public void doAnalysis(String s) {
        this.stats = new TextStatistics(s, true);
        this.originalText = s;
        try {
            this.alphabet = AlphabetFactory.getInstance(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.text = TextStatistics.removeNonAlphabetics(s, this.alphabet);
        this.resultSB = new StringBuffer();
        if (this.mFrame != null) {
            this.mFrame.append("Vigenere Analyzer: Begin Analysis\n");
        } else {
            System.out.println("Vigenere Analyzer: Begin Analysis\n");
        }
        this.doAnalysis();
    }

    public void doAnalysis() {
        String keywd1;
        int keyLengthKasiski = 0;
        int keyLengthSuperpos = 0;
        this.computeBigramDistances(this.text);
        this.resultSB.append("\nVigenerAnalyzer: There are " + this.nRepeatedBigrams + " repeated bigrams\n");
        int k = 0;
        while (k < this.nRepeatedBigrams) {
            this.computeFactors(this.kasiskiFactors, this.bigrams[k].displ);
            ++k;
        }
        keyLengthKasiski = this.estimateKeywordLength(this.kasiskiFactors);
        this.computeSuperpositionAnalysis(this.text);
        this.resultSB.append("\nVigenerAnalyzer: There are " + this.nSuperDisplacements + " that give more than " + 6.0 + " percent coincidences.");
        k = 0;
        while (k < this.nSuperDisplacements) {
            this.computeFactors(this.superFactors, this.superDispl[k]);
            keyLengthSuperpos = this.estimateKeywordLength(this.superFactors);
            ++k;
        }
        keyLengthSuperpos = this.superDispl[0];
        this.keyword = keywd1 = this.estimateKeyword(keyLengthKasiski);
        String keywd2 = this.estimateKeyword(keyLengthSuperpos);
        this.resultSB.append("\nThe Kasiski test suggests the keyword length is " + keyLengthKasiski);
        this.resultSB.append("\n A possible keyword of that length is " + keywd1);
        this.resultSB.append("\nThe Superposition test suggests the keyword length is " + keyLengthSuperpos);
        this.resultSB.append("\n A possible keyword of that length is " + keywd2);
        this.decrypt(keywd1);
        this.decrypt(keywd2);
    }

    private void decrypt(String keyword) {
        String newkeywd = keyword;
        try {
            Provider.addProvider(new DefaultProvider("Default"));
            Cipher cipher = Cipher.getInstance("Vigenere");
            VigenereKey key = (VigenereKey)HistoricalKey.getInstance("Vigenere", cipher.getProvider());
            this.resultSB.append("\n\nHere's a partial decryption with keyword " + newkeywd + " \n");
            key.init(newkeywd, AlphabetFactory.getInstance(0), AlphabetFactory.getInstance(0));
            cipher.init(key);
            String decryption = this.text.length() <= 5000 ? cipher.decrypt(this.originalText) : cipher.decrypt(this.originalText.substring(0, 5000));
            this.resultSB.append(String.valueOf(decryption) + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int estimateKeywordLength(int[] factors) {
        int totalChars = this.stats.getCharCount();
        double ci = this.stats.getCoincidenceIndex();
        double num = 0.027 * (double)totalChars;
        double den = ci * ((double)totalChars - 1.0) - 0.0385 * (double)totalChars + 0.0667;
        this.keywordLengthEstStat = (int)Math.round(num / den);
        int pMaxFactor = 0;
        int vMaxFactor = 0;
        int k = 3;
        while (k < this.nRepeatedBigrams) {
            if (factors[k] > vMaxFactor) {
                vMaxFactor = factors[k];
                pMaxFactor = k;
            }
            ++k;
        }
        return pMaxFactor;
    }

    public String estimateKeyword(int keyLen) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < keyLen) {
            sb.append((char)(97 + this.getOptimalShift(k, keyLen)));
            ++k;
        }
        return sb.toString();
    }

    protected String computeFactors(int[] factors, int displ) {
        int k;
        StringBuffer sb = new StringBuffer();
        boolean isEven = false;
        if (displ % 2 == 0 && displ != 0) {
            isEven = true;
            sb.append("2,");
            k = 2;
            do {
                int n = k;
                factors[n] = factors[n] + 1;
                k *= 2;
            } while ((displ /= 2) % 2 == 0);
        }
        k = 3;
        while (k <= displ) {
            if (displ % k == 0) {
                sb.append(String.valueOf(k) + ",");
                int j = k;
                do {
                    int n = j;
                    factors[n] = factors[n] + 1;
                    displ /= k;
                    if (isEven) {
                        int n2 = 2 * j;
                        factors[n2] = factors[n2] + 1;
                    }
                    j *= k;
                } while (displ % k == 0);
            }
            k += 2;
        }
        if (displ != 1) {
            sb.append(String.valueOf(displ));
        }
        return sb.toString();
    }

    public int getOptimalShift(int firstChar, int displ) {
        String text = this.text;
        double[] tChiSqrs = new double[26];
        int[] tFreqs = new int[26];
        int k = 0;
        while (k < 26) {
            tFreqs[k] = 0;
            ++k;
        }
        k = 0;
        while (k < 26) {
            tChiSqrs[k] = 0.0;
            ++k;
        }
        k = firstChar;
        while (k < text.length()) {
            char ch = text.charAt(k);
            if (Character.isLetter(ch)) {
                ch = Character.toLowerCase(ch);
                int n = ch - 97;
                tFreqs[n] = tFreqs[n] + 1;
            }
            k += displ;
        }
        int j = 0;
        while (j < 26) {
            char k2 = 'a';
            while (k2 <= 'z') {
                int index = (k2 - 97 + j) % 26;
                double freq = TextStatistics.getEnglishFrequency(k2) - (double)tFreqs[index];
                freq *= freq;
                tChiSqrs[j] = tChiSqrs[j] + (freq /= TextStatistics.getEnglishFrequency(k2));
                k2 = (char)(k2 + '\u0001');
            }
            ++j;
        }
        return TextStatistics.getIndexOfMinimum(tChiSqrs);
    }
}

