/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.tool.PatternDictionary;
import hcrypto.analyzer.tool.TextUtilities;
import hcrypto.analyzer.tool.Token;
import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.SubstitutionKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.StringTokenizer;

public class WordBasedAnalyzer
extends CryptoAnalyzer {
    private static final int MAX_KEY = 26;
    private static final int MAX_DEPTH = 36;
    private static final int MAX_LOOPS = 50000;
    private int dict_type = 1;
    private String bestDecrypt;
    private StringBuffer resultSB;
    private StringBuffer paramSB;
    private Cipher cipher;
    private SubstitutionKey sKey;
    private PatternDictionary dict;
    private DateFormat dateformat = DateFormat.getTimeInstance(1);
    private StringBuffer encipherKey;
    private int nLoops = 0;
    private double bestScore = 0.0;
    private int nTokens = 0;
    private Token[] tokens;
    private long time0 = System.currentTimeMillis();
    private long keyCount = 0L;
    private AnalyzerFrame mFrame;

    public WordBasedAnalyzer(GaParameters params, AnalyzerFrame f) {
        super(params);
        this.mFrame = f;
        this.dict_type = params.eval_dict;
    }

    public WordBasedAnalyzer() {
    }

    public void setup(String text) {
        super.setup(text);
        this.num.setMaximumFractionDigits(2);
        this.init();
    }

    public void init() {
        this.dict = new PatternDictionary(this.dict_type);
        this.resultSB = new StringBuffer();
        this.paramSB = new StringBuffer();
        Provider.addProvider(new DefaultProvider("Default"));
        this.cipher = Cipher.getInstance("Substitution");
        this.sKey = (SubstitutionKey)HistoricalKey.getInstance("Substitution", this.cipher.getProvider());
        this.encipherKey = new StringBuffer();
        int k = 0;
        while (k < 26) {
            this.encipherKey.append("*");
            ++k;
        }
        this.tokens = this.initWordArray(this.text);
        Arrays.sort(this.tokens);
        this.nTokens = this.tokens.length;
        this.nLoops = 0;
        this.bestScore = 0.0;
        this.paramSB.append("WordBasedAnalyzer Analyzer: Begin Analysis");
        this.paramSB.append("STARTING ANALYSIS\t nTokens " + this.nTokens + "\t nWords " + TextUtilities.countWords(this.dict, this.text) + "\t nWordsSolution " + TextUtilities.countWords(this.dict, this.solution.toLowerCase()) + "\t nChars " + this.text.length());
        this.paramSB.append("\nDictionary: " + this.dict.getDictionaryName());
    }

    private Token[] initWordArray(String text) {
        StringTokenizer st = new StringTokenizer(TextUtilities.removeDuplicates(text.toLowerCase()), " \r\f\t\n;:\".,!@#$%'^&*(_-+=\\`~{{}}?|");
        Token[] tokens = new Token[st.countTokens()];
        int k = 0;
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            tokens[k] = new Token(word, this.dict);
            ++k;
        }
        return tokens;
    }

    public void run() {
        this.stopThread = false;
        this.doAnalysis();
        this.resultSB.append("Finished: Iterations = " + this.nLoops + " Best score is " + this.num.format(this.bestScore) + " KeyCount = " + this.keyCount);
        this.resultSB.append("\nTime Used = " + (System.currentTimeMillis() - this.time0) + "ms");
        this.resultSB.append("\n\nDECRYPTED MESSAGE :\n" + this.bestDecrypt + "\n");
        if (!this.solution.equals("")) {
            this.resultSB.append("SOLUTION          : " + this.solution + "\n");
            this.resultSB.append("PERCENT WORDS: " + this.num.format(TextUtilities.percentWords(this.solution, this.bestDecrypt)) + "\n");
            this.resultSB.append("WRONG CHARS: " + TextUtilities.countInCorrectChars(this.solution, this.bestDecrypt) + "\n");
        }
        if (this.mFrame != null) {
            this.mFrame.append(this.resultSB.toString());
        } else {
            System.out.print(this.resultSB.toString());
        }
    }

    public String getReport() {
        return this.toString();
    }

    public String toString() {
        return this.resultSB.toString();
    }

    public void doAnalysis() {
        this.resultSB.append("\n");
        this.solve(this.tokens, this.encipherKey);
    }

    private void solve(Token[] tokens, StringBuffer encipherKey) {
        this.solve(tokens, 0, encipherKey, 0.0);
    }

    private String makeKeyword(String encipherKey) {
        String alphabet = new String("abcdefghijklmnopqrstuvwxyz");
        StringBuffer keyword = new StringBuffer(encipherKey);
        int alph = 0;
        int indx = -1;
        char alphCh = 'a';
        int k = 0;
        while (k < keyword.length()) {
            char ch = keyword.charAt(k);
            if (ch == '*') {
                do {
                    alphCh = alphabet.charAt(alph);
                    ++alph;
                } while ((indx = keyword.toString().indexOf(alphCh)) != -1);
                keyword.setCharAt(k, alphCh);
            }
            ++k;
        }
        return keyword.toString();
    }

    private void testMessage(String encipherKey, double score, int depth) {
        String decrypt = null;
        String keyword = this.makeKeyword(encipherKey);
        try {
            this.sKey.init(String.valueOf(keyword) + "/az");
            this.cipher.init(this.sKey);
            decrypt = this.cipher.decrypt(this.text);
            if (score > this.bestScore) {
                this.bestScore = score;
                this.bestDecrypt = decrypt;
                if (this.params.verbose) {
                    System.out.println("Here's a decryption based on KEYWORD= " + keyword);
                    System.out.print("Depth = " + depth + " Time Used = " + (System.currentTimeMillis() - this.time0) + "ms");
                    System.out.println(" KeyCount " + this.keyCount + " score= " + score);
                    System.out.println(String.valueOf(decrypt) + "\n");
                    if (this.display != null) {
                        this.display.setText(decrypt);
                    }
                }
                if (this.mFrame != null) {
                    this.mFrame.setText(String.valueOf(this.paramSB.toString()) + "\n\n" + decrypt);
                }
                this.nLoops = 0;
            } else {
                ++this.nLoops;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void solve(Token[] tokens, int depth, StringBuffer encipherKey, double score) {
        if (depth >= Math.min(tokens.length, 36) || this.threadIsStopped()) {
            this.testMessage(encipherKey.toString(), score, depth);
        } else if (this.nLoops <= 50000) {
            String token = tokens[depth].getToken();
            String pattern = tokens[depth].getPattern();
            String[] words = tokens[depth].getPatternSet();
            String word = null;
            int k = 0;
            while (words != null && k < words.length) {
                word = words[k];
                StringBuffer newencipherKey = new StringBuffer(encipherKey.toString());
                ++this.keyCount;
                if (this.isMatch(token, word, newencipherKey)) {
                    this.solve(tokens, depth + 1, newencipherKey, score + 1.0);
                }
                ++k;
            }
            this.solve(tokens, depth + 1, encipherKey, score);
        }
    }

    private boolean isMatch(String token, String word, StringBuffer newkey) {
        int k = 0;
        while (k < token.length()) {
            char t1 = token.charAt(k);
            char w1 = word.charAt(k);
            char ew1 = newkey.charAt(w1 - 97);
            if (ew1 != '*' && ew1 != t1) {
                return false;
            }
            int indx = newkey.toString().indexOf(t1);
            char dt1 = '*';
            if (indx != -1) {
                dt1 = (char)(97 + indx);
            }
            if (dt1 != '*' && dt1 != w1) {
                return false;
            }
            newkey.setCharAt(w1 - 97, t1);
            ++k;
        }
        return true;
    }
}

