/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.CryptoAnalyzer;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.evolutionary.GaPopulation;
import hcrypto.analyzer.tool.TextUtilities;
import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.SubstitutionKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;

public class GaAnalyzer
extends CryptoAnalyzer {
    protected GaPopulation population;
    protected AnalyzerFrame mFrame;

    public GaAnalyzer() {
    }

    public GaAnalyzer(GaParameters params, AnalyzerFrame f) {
        super(params);
        this.mFrame = f;
    }

    public void setup(String text) {
        super.setup(text);
        if (this.params == null) {
            this.params = new GaParameters();
        }
    }

    public void run() {
        if (this.mFrame != null) {
            this.population.setDisplay(this.mFrame);
        }
        this.population.run();
        int n = 1;
        this.resultSB.append("\nTHE TOP " + n + "  RESULT(S):");
        int k = 1;
        while (k <= n) {
            String key = this.population.getFittest(k - 1).getKey();
            this.resultSB.append("\nKey (" + k + ") = " + this.population.getFittest(k).displayCrossData() + "\n");
            try {
                Provider.addProvider(new DefaultProvider("Default"));
                Cipher cipher = Cipher.getInstance("Substitution");
                SubstitutionKey sKey = (SubstitutionKey)HistoricalKey.getInstance("Substitution", cipher.getProvider());
                sKey.init(String.valueOf(key) + "/az");
                cipher.init(sKey);
                String decrypt = this.text.length() <= 5000 ? cipher.decrypt(this.text) : cipher.decrypt(this.text.substring(0, 5000));
                this.reportMissingLetters(decrypt);
                this.resultSB.append("-------------\nDECRYPTED MESSAGE(" + k + "):\n" + decrypt);
                if (!this.solution.equals("")) {
                    this.resultSB.append("\nSOLUTION(" + k + "):\n" + this.solution + "\n");
                    this.resultSB.append("WRONG CHARS: " + TextUtilities.countInCorrectChars(this.solution, decrypt) + "\n-------------\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mFrame != null) {
                this.mFrame.append(this.resultSB.toString());
            } else {
                System.out.println(this.resultSB.toString());
            }
            ++k;
        }
    }
}

