/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.cipher.Cipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.SubstitutionKey;
import hcrypto.provider.DefaultProvider;
import hcrypto.provider.Provider;

public abstract class GaIndividual
implements Comparable {
    protected StringBuffer key;
    protected double fitness;
    protected String ciphertext;
    protected String decrypt;
    protected Cipher cipher;
    protected SubstitutionKey sKey;
    protected GaParameters params;
    protected int mutate_policy = 1;

    public GaIndividual() {
        this.key = new StringBuffer();
    }

    public GaIndividual(String text, String initKey, GaParameters p) {
        this.ciphertext = text;
        this.params = p;
        this.key = new StringBuffer(initKey);
        try {
            Provider.addProvider(new DefaultProvider("Default"));
            this.cipher = Cipher.getInstance("Substitution");
            this.sKey = (SubstitutionKey)HistoricalKey.getInstance("Substitution", this.cipher.getProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GaIndividual(GaIndividual i) {
        this.key = new StringBuffer(i.key.toString());
        this.fitness = i.fitness;
        this.ciphertext = i.ciphertext;
        this.cipher = i.cipher;
        this.sKey = i.sKey;
        this.params = i.params;
        this.decrypt = i.decrypt;
        this.mutate_policy = i.mutate_policy;
    }

    public abstract void cross(GaIndividual var1);

    public abstract int mutate(double var1);

    public abstract void calcFitness();

    protected void swap(char ch1, char ch2) {
        int m = this.key.toString().indexOf(ch1);
        int n = this.key.toString().indexOf(ch2);
        this.key.setCharAt(m, ch2);
        this.key.setCharAt(n, ch1);
    }

    public double getFitness() {
        return this.fitness;
    }

    public String getKey() {
        return this.key.toString();
    }

    public String getDecrypt() {
        return this.decrypt;
    }

    public int compareTo(Object o) {
        GaIndividual indy = (GaIndividual)o;
        if (this.fitness < indy.fitness) {
            return 1;
        }
        if (this.fitness > indy.fitness) {
            return -1;
        }
        return 0;
    }

    public String displayCrossData() {
        return String.valueOf(this.getKey()) + " (" + this.getFitness() + ")";
    }

    public String toString() {
        return this.getKey();
    }
}

