/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import hcrypto.cipher.Alphabet;
import java.util.StringTokenizer;

public class GaParameters {
    public static final int POPULATION_SIZE = 512;
    public static final int MAX_GENERATIONS = 500;
    public static final int TWEAK_AT = 20;
    public static final double MUTATE_RATE = 0.1;
    public static final double CROSS_RATE = 0.75;
    public static final boolean TWEAK_ON = true;
    public static final boolean IS_VERBOSE = false;
    public static final int NO_SEEDING = 0;
    public static final int RANDOM_SEEDING = 1;
    public static final int DETERMINISTIC_SEEDING = 2;
    public static final int ELITIST_SELECTION = 0;
    public static final int PROPORTIONAL_SELECTION = 1;
    public static final int ELITIST_MUTATION = 0;
    public static final int RANDOM_MUTATION = 1;
    public String param_string;
    public String filename;
    public double cross_rate = 0.75;
    public double mutate_rate = 0.1;
    public int generations = 500;
    public boolean verbose = false;
    public int text_limit = 5000;
    public boolean tweaking = false;
    public int tweak_at = 0;
    public int size = 64;
    public int seeding = 1;
    public int eval_dict = 4;
    public int seed_dict = 3;
    public String dict_name = "words.txt";
    public double eval_A = 1.0;
    public double eval_B = 0.01;
    public double eval_C = 2.0;
    public int mutate_policy = 0;
    public int selection_policy = 0;
    public Alphabet alphabet;
    public String book;
    public int NN = 4;
    public int cipherType = 0;
    public int randSize = 26;
    public int nloops = 5;
    public double temperature = 1.0;
    public double tFactor = 0.95;
    public int nkeys = 100000;

    public GaParameters() {
        try {
            char[] arr = new char[]{'a', 'z', ' ', ' '};
            this.alphabet = new Alphabet(arr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GaParameters(String paramstr) {
        this.param_string = paramstr;
        StringTokenizer st = new StringTokenizer(paramstr);
        while (st.hasMoreTokens()) {
            this.setParameters(st.nextToken());
        }
    }

    private void setParameters(String s) {
        String p_name = s.substring(0, s.indexOf("="));
        String p_val = s.substring(s.indexOf("=") + 1);
        try {
            char[] arr = new char[]{'a', 'z', ' ', ' '};
            this.alphabet = new Alphabet(arr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (p_name.equals("file")) {
            this.filename = p_val;
        } else if (p_name.equals("crossrate")) {
            this.cross_rate = Double.parseDouble(p_val);
        } else if (p_name.equals("mutaterate")) {
            this.mutate_rate = Double.parseDouble(p_val);
        } else if (p_name.equals("generations")) {
            this.generations = Integer.parseInt(p_val);
        } else if (p_name.equals("verbose")) {
            this.verbose = p_val.equals("true");
        } else if (p_name.equals("tweaking")) {
            this.tweaking = p_val.equals("true");
        } else if (p_name.equals("textlimit")) {
            this.text_limit = Integer.parseInt(p_val);
        } else if (p_name.equals("size")) {
            this.size = Integer.parseInt(p_val);
        } else if (p_name.equals("seeding")) {
            this.seeding = Integer.parseInt(p_val);
        } else if (p_name.equals("eDict")) {
            this.eval_dict = Integer.parseInt(p_val);
        } else if (p_name.equals("sDict")) {
            this.seed_dict = Integer.parseInt(p_val);
        } else if (p_name.equals("dict")) {
            this.dict_name = p_val;
        } else if (p_name.equals("tweakat")) {
            this.tweak_at = Integer.parseInt(p_val);
            this.tweaking = this.tweak_at > 0;
        } else if (p_name.equals("A")) {
            this.eval_A = Double.parseDouble(p_val);
        } else if (p_name.equals("B")) {
            this.eval_B = Double.parseDouble(p_val);
        } else if (p_name.equals("C")) {
            this.eval_C = Double.parseDouble(p_val);
        } else if (p_name.equals("book")) {
            this.book = p_val;
        } else if (p_name.equals("ctype")) {
            this.cipherType = Integer.parseInt(p_val);
        } else if (p_name.equals("rsize")) {
            this.randSize = Integer.parseInt(p_val);
        } else if (p_name.equals("nloops")) {
            this.nloops = Integer.parseInt(p_val);
        } else if (p_name.equals("NN")) {
            this.NN = Integer.parseInt(p_val);
        } else if (p_name.equals("alpha")) {
            try {
                if (p_val.toLowerCase().equals("playfair")) {
                    char[] arr2 = new char[]{'a', 'z'};
                    this.alphabet = new Alphabet(arr2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (p_name.equals("T")) {
            this.temperature = Double.parseDouble(p_val);
        } else if (p_name.equals("TFactor")) {
            this.tFactor = Double.parseDouble(p_val);
        } else if (p_name.equals("nkeys")) {
            this.nkeys = Integer.parseInt(p_val);
        } else if (p_name.equals("mutpol")) {
            this.mutate_policy = Integer.parseInt(p_val);
        } else if (p_name.equals("selpol")) {
            this.selection_policy = Integer.parseInt(p_val);
        } else if (p_name.equals("ss")) {
            // empty if block
        }
    }

    public String toString() {
        return this.param_string;
    }
}

