/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.evolutionary.GaIndividual;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.tool.TextUtilities;
import java.text.NumberFormat;

public abstract class GaPopulation {
    protected int size = 512;
    protected double mutate_rate = 0.1;
    protected double cross_rate = 0.75;
    protected int maxtrials = 500;
    protected boolean verbose = false;
    protected int seeding = 1;
    protected boolean tweakingOn = true;
    protected int tweak_at = 20;
    protected int mutate_policy = 1;
    protected int selection_policy = 0;
    protected String ciphertext;
    protected String cleantext;
    protected String solution = "";
    protected AnalyzerFrame mFrame = null;
    protected StringBuffer resultSB;
    protected StringBuffer paramSB;
    protected NumberFormat num;
    protected GaParameters params;
    protected GaIndividual[] individual;
    protected int nochange = 0;
    protected int improved = 0;
    protected int worsened = 0;
    protected int gotall = 0;
    protected int mutated = 0;
    protected int lastScoreChange = 0;
    protected double bestScore = 0.0;
    protected double previousBestScore = 0.0;
    protected int iterations = 0;
    protected int keyCount = 0;

    public GaPopulation(String text, String solution, GaParameters params) {
        this.solution = solution;
        this.resultSB = new StringBuffer();
        this.paramSB = new StringBuffer();
        this.num = NumberFormat.getInstance();
        this.num.setMaximumFractionDigits(2);
        if (params != null) {
            this.params = params;
            this.size = params.size;
            this.mutate_rate = params.mutate_rate;
            this.mutate_policy = params.mutate_policy;
            this.selection_policy = params.selection_policy;
            this.cross_rate = params.cross_rate;
            this.verbose = params.verbose;
            this.tweakingOn = params.tweaking;
            this.maxtrials = params.generations;
            this.seeding = params.seeding;
            this.tweak_at = params.tweak_at;
        }
        this.tweakingOn = this.tweak_at > 0;
        this.ciphertext = text;
        this.cleantext = TextUtilities.cleanString(this.ciphertext);
        this.init();
    }

    public GaIndividual getFittest(int n) {
        return this.individual[n];
    }

    public abstract void init();

    public abstract void run();

    public void setDisplay(AnalyzerFrame d) {
        this.mFrame = d;
    }

    protected void selectProportional() {
        int ptr = 0;
        int k = 0;
        double max = this.individual[0].getFitness();
        max *= 1.05;
        while (ptr < this.size && this.size - ptr < 2 * this.size - k) {
            double val = this.individual[k].getFitness();
            if (Math.random() <= val / max) {
                this.individual[ptr++] = this.individual[k++];
                continue;
            }
            ++k;
        }
        while (ptr < this.size) {
            this.individual[ptr] = this.individual[k];
            ++k;
            ++ptr;
        }
    }

    protected void updateScore() {
        this.bestScore = this.individual[0].getFitness();
        if (this.bestScore < this.previousBestScore) {
            this.previousBestScore = this.bestScore;
            this.lastScoreChange = this.iterations;
        }
    }
}

