/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import hcrypto.analyzer.Analyzer;
import hcrypto.cipher.Alphabet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.NumberFormat;

public class NgramArray
implements Analyzer {
    private Alphabet alphabet;
    private int alphSize;
    private int arrSize;
    private int mask;
    private int NN;
    private int textSize;
    private double[] freq;
    private int stepSize;
    private final int NUMMOSTFREQ = 100;
    private double[] mostFreqValue = new double[100];
    private int[] mostFreqIndex = new int[100];
    private String[] mostFreqWord = new String[100];
    private double[] charFreq;

    public NgramArray(int N, String fileName, Alphabet alph) throws Exception {
        this.NN = N;
        this.alphabet = alph;
        this.stepSize = 1;
        if (this.alphabet == null) {
            throw new Exception("In NgramArray: Null alphabet");
        }
        this.alphSize = this.alphabet.getSize();
        if (this.NN >= 1 && this.NN < 5 && this.alphSize <= 32) {
            this.mask = (1 << this.NN * 5) - 1;
            this.arrSize = this.alphSize * (1 << (this.NN - 1) * 5);
            this.freq = new double[this.arrSize];
            this.charFreq = new double[this.alphSize];
            this.setup(fileName);
        } else {
            if (this.alphSize > 32) {
                throw new Exception("In NgramArray: Invalid Alphabet size = " + this.alphSize);
            }
            if (this.NN < 1 || this.NN > 4) {
                throw new Exception("In NgramArray: Invalid N-gram size = " + this.NN);
            }
        }
    }

    private void printArr(double[] arr) {
        int k = 0;
        while (k < arr.length) {
            System.out.print(String.valueOf(arr[k]) + " ");
            ++k;
        }
        System.out.println();
    }

    public NgramArray(int N, String fileName, Alphabet alph, int step) throws Exception {
        this.NN = N;
        this.alphabet = alph;
        this.stepSize = step;
        if (this.alphabet == null) {
            throw new Exception("In NgramArray: Null alphabet");
        }
        this.alphSize = this.alphabet.getSize();
        if (this.NN > 1 && this.NN < 5 && this.alphSize <= 32) {
            this.mask = (1 << this.NN * 5) - 1;
            this.arrSize = this.alphSize * (1 << (this.NN - 1) * 5);
            this.freq = new double[this.arrSize];
            this.charFreq = new double[this.alphSize];
            this.setup(fileName);
        } else {
            if (this.alphSize > 32) {
                throw new Exception("In NgramArray: Invalid Alphabet size = " + this.alphSize);
            }
            if (this.NN < 2 || this.NN > 4) {
                throw new Exception("In NgramArray: Invalid N-gram size = " + this.NN);
            }
        }
    }

    public void setup(String fileName) {
        int pos = 0;
        int index = 0;
        try {
            String line = null;
            int len = 0;
            int chNum = 0;
            BufferedReader inStream = new BufferedReader(new FileReader(fileName));
            line = inStream.readLine();
            while (line != null) {
                len = line.length();
                if (len > 0) {
                    line = line.toLowerCase();
                    pos = 0;
                    while (pos < len) {
                        char ch = line.charAt(pos);
                        if (this.alphabet.isInAlphabet(ch)) {
                            int n = this.alphabet.charToInt(ch);
                            this.charFreq[n] = this.charFreq[n] + 1.0;
                            index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                            if (++chNum >= this.NN) {
                                this.freq[index] = this.freq[index] + 1.0;
                            }
                        }
                        ++pos;
                    }
                }
                line = inStream.readLine();
            }
            this.textSize = chNum;
            int k = 0;
            while (k < this.charFreq.length) {
                int n = k++;
                this.charFreq[n] = this.charFreq[n] / (double)this.textSize;
            }
            this.setupMostFreqWords();
        }
        catch (Exception exc) {
            System.out.println("In NgramArray  setup() - " + exc.toString());
            exc.printStackTrace();
        }
    }

    private String removeWhiteSpace(String s) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) != ' ') {
                sb.append(s.charAt(k));
            }
            ++k;
        }
        return new String(sb.toString());
    }

    public String getReport() {
        return this.toString();
    }

    public void run() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("Alphabet size = " + this.alphSize + "\n");
        sb.append("This array stores reciprocals of frequencies of " + this.NN + "-grams\n");
        sb.append("Array size = " + this.arrSize + "\n");
        sb.append("Number of alphabet chars in the text file= " + this.textSize + "\n");
        try {
            if (this.NN == 4) {
                int index = 0;
                char ch = 't';
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                ch = 'h';
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                ch = 'e';
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                ch = 'n';
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                sb.append("freq of /then/ = " + this.freq[index] + "\n");
            }
        }
        catch (Exception exc) {
            System.out.println("in ngramArray toString() - " + exc.toString());
        }
        return sb.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }

    public int getAlphSize() {
        return this.alphSize;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public int getNN() {
        return this.NN;
    }

    public double getNGramProb(String ngram) throws Exception {
        if (ngram.length() != this.NN) {
            throw new Exception("Invalid Ngram length= " + ngram.length());
        }
        double letterProbs = 1.0;
        int index = 0;
        int k = 0;
        while (k < ngram.length()) {
            index = (index << 5 | this.alphabet.charToInt(ngram.charAt(k))) & this.mask;
            letterProbs *= this.charFreq[this.alphabet.charToInt(ngram.charAt(k))];
            ++k;
        }
        return (this.freq[index] + 0.01) / (double)this.textSize / letterProbs;
    }

    public double getFreq(char ch) throws Exception {
        return this.charFreq[this.alphabet.charToInt(ch)];
    }

    public double getNgramFreq(String ngram) throws Exception {
        if (ngram.length() != this.NN) {
            throw new Exception("Invalid Ngram Size for this NgramArray");
        }
        int index = 0;
        int k = 0;
        while (k < ngram.length()) {
            index = (index << 5 | this.alphabet.charToInt(ngram.charAt(k))) & this.mask;
            ++k;
        }
        return this.freq[index] / (double)this.textSize;
    }

    public int getArrSize() {
        return this.arrSize;
    }

    public void setStepSize(int newStep) {
        if (newStep > 0) {
            this.stepSize = newStep;
        }
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public String getMostFreqWord(int k) {
        return this.mostFreqWord[k];
    }

    private void setupMostFreqWords() {
        try {
            int j = 0;
            while (j < 100) {
                this.mostFreqValue[j] = 0.0;
                this.mostFreqIndex[j] = 0;
                ++j;
            }
            int k = 0;
            while (k < this.arrSize) {
                if (this.freq[k] > this.mostFreqValue[99]) {
                    j = 99;
                    while (j > 0 && this.freq[k] > this.mostFreqValue[j - 1]) {
                        this.mostFreqValue[j] = this.mostFreqValue[j - 1];
                        this.mostFreqIndex[j] = this.mostFreqIndex[j - 1];
                        --j;
                    }
                    this.mostFreqValue[j] = this.freq[k];
                    this.mostFreqIndex[j] = k;
                }
                ++k;
            }
            j = 0;
            while (j < 100) {
                int m = this.mostFreqIndex[j];
                String temp = "";
                k = 0;
                while (k < this.NN) {
                    temp = String.valueOf(this.alphabet.intToChar(m % 32)) + temp;
                    m /= 32;
                    ++k;
                }
                this.mostFreqWord[j] = temp;
                ++j;
            }
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
        }
    }

    public void writeFreqWordsToFile(String fileName) {
        try {
            FileWriter outStream = new FileWriter(fileName);
            int k = 0;
            while (k < 100) {
                outStream.write("_" + this.getMostFreqWord(k));
                if ((k + 1) % 5 == 0) {
                    outStream.write("_\n");
                }
                ++k;
            }
            outStream.close();
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
        }
    }

    public double absDiffBigramDist(String ctext) throws Exception {
        if (this.NN != 2 || this.alphSize != 27) {
            throw new Exception("Invalid Alphabet (not 27 letters or NN != 2 in absDiffBigramDist()");
        }
        double total = 0.0;
        double[][] bigramFreq = new double[27][27];
        int len = ctext.length();
        boolean index = false;
        int ind1 = 0;
        int ind2 = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                ind1 = ind2;
                ind2 = this.alphabet.charToInt(ch);
                if (++charCount >= this.NN && charCount % this.stepSize == 0) {
                    double[] dArray = bigramFreq[ind1];
                    int n = ind2;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            ++k;
        }
        int i = 0;
        while (i < 27) {
            int j = 0;
            while (j < 27) {
                total += Math.abs(this.freq[32 * i + j] / (double)(this.textSize - 1) - bigramFreq[i][j] / (double)(charCount - 1));
                ++j;
            }
            ++i;
        }
        return total;
    }

    public double sqrDiffBigramDist(String ctext) throws Exception {
        if (this.NN != 2 || this.alphSize != 27) {
            throw new Exception("Invalid Alphabet (not 27 letters or NN != 2 in absDiffBigramDist()");
        }
        double total = 0.0;
        double[][] bigramFreq = new double[27][27];
        int len = ctext.length();
        boolean index = false;
        int ind1 = 0;
        int ind2 = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                ind1 = ind2;
                ind2 = this.alphabet.charToInt(ch);
                if (++charCount >= this.NN && charCount % this.stepSize == 0) {
                    double[] dArray = bigramFreq[ind1];
                    int n = ind2;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            ++k;
        }
        int i = 0;
        while (i < 27) {
            int j = 0;
            while (j < 27) {
                total += (this.freq[32 * i + j] / (double)(this.textSize - 1) - bigramFreq[i][j] / (double)(charCount - 1)) * (this.freq[32 * i + j] / (double)(this.textSize - 1) - bigramFreq[i][j] / (double)(charCount - 1));
                ++j;
            }
            ++i;
        }
        return total;
    }

    public double recipDist(String ctext) throws Exception {
        double total = 0.0;
        int len = ctext.length();
        int index = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                if (++charCount >= this.NN && charCount % this.stepSize == 0) {
                    total += 1.0 / (1.0 + this.freq[index]);
                }
            }
            ++k;
        }
        return total;
    }

    public double recipDistSkip(String ctext) throws Exception {
        double total = 0.0;
        int len = ctext.length();
        int index = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                if (++charCount >= this.NN && (charCount - this.NN) % this.stepSize == 0) {
                    total += 1.0 / (0.2 + this.freq[index]);
                }
            }
            ++k;
        }
        return total;
    }

    public double recipDist(String ctext, int[] indx) throws Exception {
        double min = 1000000.0;
        int minLoc = 0;
        int maxLoc = 0;
        double max = 0.0;
        double total = 0.0;
        int len = ctext.length();
        int index = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                if (++charCount >= this.NN && charCount % this.stepSize == 0) {
                    double score = 1.0 / (1.0 + this.freq[index]);
                    total += score;
                    if (score > max) {
                        max = score;
                        maxLoc = k;
                    } else if (score < min) {
                        min = score;
                        minLoc = k;
                    }
                }
            }
            ++k;
        }
        indx[0] = maxLoc;
        indx[1] = minLoc;
        return total;
    }

    public double recipDist(String ctext, double[] scores) throws Exception {
        double total = 0.0;
        int len = ctext.length();
        int index = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                if (++charCount >= this.NN && charCount % this.stepSize == 0) {
                    double score = 1.0 / (1.0 + this.freq[index]);
                    total += score;
                    scores[k] = score;
                }
            }
            ++k;
        }
        return total;
    }

    public double recipDist(int[] cnums) throws Exception {
        int k = 0;
        while (k < cnums.length) {
            System.out.print(" " + cnums[k]);
            ++k;
        }
        System.out.println("\n");
        double total = 0.0;
        int len = cnums.length;
        if (len < this.NN) {
            return total;
        }
        int index = 0;
        int k2 = 0;
        while (k2 < len) {
            index = (index << 5 | cnums[k2]) & this.mask;
            if (k2 + 1 >= this.NN && (k2 + 1) % this.stepSize == 0) {
                total += 1.0 / (1.0 + this.freq[index]);
            }
            ++k2;
        }
        return total;
    }

    public double freqDist(String ctext) throws Exception {
        double total = 0.0;
        int len = ctext.length();
        int index = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                if (++charCount >= this.NN && charCount % this.stepSize == 0) {
                    total += this.freq[index];
                }
            }
            ++k;
        }
        return total / (double)this.textSize;
    }

    public double freqDist(int[] cnums) throws Exception {
        double total = 0.0;
        int len = cnums.length;
        if (len < this.NN) {
            return total;
        }
        int index = 0;
        int k = 0;
        while (k < len) {
            index = (index << 5 | cnums[k]) & this.mask;
            if (k + 1 >= this.NN && (k + 1) % this.stepSize == 0) {
                total += this.freq[index];
            }
            ++k;
        }
        return total / (double)this.textSize;
    }

    public double sqrDist(String ctext) throws Exception {
        double total = 0.0;
        int len = ctext.length();
        int index = 0;
        int charCount = 0;
        int k = 0;
        while (k < len) {
            char ch = ctext.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                index = (index << 5 | this.alphabet.charToInt(ch)) & this.mask;
                if (++charCount >= this.NN && charCount % this.stepSize == 0) {
                    total += this.freq[index] * this.freq[index];
                }
            }
            ++k;
        }
        return total / (double)(this.textSize * this.textSize);
    }

    public double sqrDist(int[] cnums) throws Exception {
        double total = 0.0;
        int len = cnums.length;
        if (len < this.NN) {
            return total;
        }
        int index = 0;
        int k = 0;
        while (k < len) {
            index = (index << 5 | cnums[k]) & this.mask;
            if (k + 1 >= this.NN && (k + 1) % this.stepSize == 0) {
                total += this.freq[index] * this.freq[index];
            }
            ++k;
        }
        return total / (double)(this.textSize * this.textSize);
    }

    public static void main(String[] args) {
        try {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(6);
            nf.setMinimumFractionDigits(6);
            StringBuffer sb = new StringBuffer();
            char[] arr = new char[]{'a', 'z', ' ', ' '};
            Alphabet alph = new Alphabet(arr);
            NgramArray nga = new NgramArray(2, "book.txt", alph);
            System.out.println(nga.getReport());
            String test = "now is the time for all good men to come to the aid of their country";
            System.out.println("test = " + test);
            sb.append("recipDist(test) = " + nf.format(nga.recipDist(test)) + "\n");
            sb.append("freqDist(test) = " + nf.format(nga.freqDist(test)) + "\n");
            sb.append("sqrDist(test) = " + nf.format(nga.sqrDist(test)) + "\n");
            sb.append("absDiffBigramDist(test) = " + nf.format(nga.absDiffBigramDist(test)) + "\n");
            sb.append("sqrDiffBigramDist(test) = " + nf.format(nga.sqrDiffBigramDist(test)) + "\n");
            System.out.println(sb.toString());
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
        }
    }
}

