/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import hcrypto.analyzer.evolutionary.GaIndividual;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.evolutionary.NgramArray;

public class NgramGaIndividual
extends GaIndividual
implements Comparable {
    private final char SPACE = (char)32;
    private NgramArray ngramArr;
    private int NN;
    private int[] index = new int[2];
    private double[] scores;

    public NgramGaIndividual(String text, String key, GaParameters params, NgramArray nga) {
        super(text, key, params);
        this.ngramArr = nga;
        this.NN = this.ngramArr.getNN();
        this.scores = new double[text.length()];
        this.mutate_policy = params.mutate_policy;
        this.calcFitness();
    }

    public NgramGaIndividual(GaIndividual i) {
        super(i);
        this.ngramArr = ((NgramGaIndividual)i).ngramArr;
        this.NN = this.ngramArr.getNN();
        int k = 0;
        while (k < this.index.length) {
            this.index[k] = ((NgramGaIndividual)i).index[k];
            ++k;
        }
        this.scores = new double[((NgramGaIndividual)i).scores.length];
        k = 0;
        while (k < this.scores.length) {
            this.scores[k] = ((NgramGaIndividual)i).scores[k];
            ++k;
        }
    }

    public boolean equals(Object i) {
        return this.key.equals(((NgramGaIndividual)i).key);
    }

    public void cross(GaIndividual i) {
        NgramGaIndividual i1 = this;
        NgramGaIndividual i2 = (NgramGaIndividual)i;
        int p = (int)(Math.random() * (double)this.key.length());
        int pstop = p + this.NN;
        while (p < pstop && p < this.key.length()) {
            char ch1 = i1.key.charAt(p);
            char ch2 = i2.key.charAt(p);
            i1.swap(ch1, ch2);
            i2.swap(ch1, ch2);
            ++p;
        }
        i1.calcFitness();
        i2.calcFitness();
    }

    public int mutate(double rate) {
        int a = 0;
        int b = 0;
        if (Math.random() < rate) {
            NgramGaIndividual tempIndy = new NgramGaIndividual(this);
            a = (int)(Math.random() * 26.0);
            b = (int)(Math.random() * 26.0);
            char ch = this.key.charAt(a);
            this.key.setCharAt(a, this.key.charAt(b));
            this.key.setCharAt(b, ch);
            this.calcFitness();
            if (this.mutate_policy == 0 && this.compareTo(tempIndy) > 0) {
                this.key = tempIndy.key;
                this.fitness = tempIndy.fitness;
                this.decrypt = tempIndy.decrypt;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public void calcFitness() {
        try {
            this.sKey.init(String.valueOf(this.key.toString()) + "/az");
            this.cipher.init(this.sKey);
            this.decrypt = this.cipher.decrypt(this.ciphertext);
            this.fitness = this.ngramArr.recipDist(this.decrypt, this.scores);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int compareTo(Object o) {
        NgramGaIndividual indy = (NgramGaIndividual)o;
        if (this.fitness < indy.fitness) {
            return -1;
        }
        if (this.fitness > indy.fitness) {
            return 1;
        }
        return 0;
    }

    public String displayCrossData() {
        return String.valueOf(this.getKey()) + " (" + this.getFitness() + ") ";
    }

    public String toString() {
        return this.getKey();
    }

    public String getKey() {
        return this.key.toString();
    }
}

