/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.evolutionary.GaIndividual;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.evolutionary.GaPopulation;
import hcrypto.analyzer.evolutionary.NgramArray;
import hcrypto.analyzer.evolutionary.NgramGaIndividual;
import hcrypto.analyzer.tool.PatternDictionary;
import hcrypto.analyzer.tool.TextUtilities;
import hcrypto.cipher.Alphabet;
import java.util.Arrays;

public class NgramGaPopulation
extends GaPopulation {
    public static final int N_SHUFFLES = 20;
    public static final int KUCERA10 = 50;
    protected PatternDictionary seed_dict;
    private int NN;
    private String book;
    private Alphabet alphabet;
    private NgramArray ngramArr;
    private int charErrs = 0;
    private StringBuffer paramSB;
    private StringBuffer resultSB;

    public NgramGaPopulation(AnalyzerFrame f, String text, String solution, GaParameters params) {
        super(text, solution, params);
        this.mFrame = f;
        this.paramSB = new StringBuffer();
        this.resultSB = new StringBuffer();
        this.NN = params.NN;
        this.book = params.book;
        this.alphabet = params.alphabet;
        this.initNgramArray();
    }

    public void init() {
    }

    private void initNgramArray() {
        try {
            char[] arr = new char[]{'a', 'z', ' ', ' '};
            this.alphabet = new Alphabet(arr);
            this.ngramArr = new NgramArray(this.NN, this.book, this.alphabet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.individual = new NgramGaIndividual[this.size * 2];
        int k = 0;
        while (k < this.individual.length) {
            this.individual[k] = new NgramGaIndividual(this.cleantext, this.makeKey(), this.params, this.ngramArr);
            ++this.keyCount;
            ++k;
        }
    }

    private String makeKey() {
        return this.shuffle("abcdefghijklmnopqrstuvwxyz");
    }

    public void run() {
        int ptr = 0;
        this.makeStartMessage();
        this.previousBestScore = Double.MAX_VALUE;
        if (this.mFrame != null) {
            this.mFrame.append(String.valueOf(this.paramSB.toString()) + this.resultSB.toString());
        } else {
            System.out.println(String.valueOf(this.paramSB.toString()) + this.resultSB.toString());
        }
        do {
            ptr = this.size;
            int k = 0;
            while (k < this.size / 2) {
                int j = (int)(Math.random() * (double)this.size);
                double rand = Math.random();
                if (rand <= this.cross_rate) {
                    NgramGaIndividual i1 = new NgramGaIndividual(this.individual[k]);
                    NgramGaIndividual i2 = new NgramGaIndividual(this.individual[j]);
                    ((GaIndividual)i1).cross(i2);
                    if (this.newSolution(i1, ptr)) {
                        this.individual[ptr++] = i1;
                    }
                    if (this.newSolution(i2, ptr)) {
                        this.individual[ptr++] = i2;
                    }
                }
                ++k;
            }
            this.mutateAll();
            ++this.iterations;
            Arrays.sort(this.individual);
            if (this.selection_policy == 1) {
                this.selectProportional();
            }
            this.updateScore();
            this.keyCount += this.individual.length;
            this.charErrs = TextUtilities.countInCorrectChars(this.solution, this.individual[0].getDecrypt());
            if (this.verbose) {
                this.displayBest();
            }
            if (this.mFrame == null) continue;
            this.resultSB = new StringBuffer(this.individual[0].getDecrypt());
            this.mFrame.setText(String.valueOf(this.paramSB.toString()) + "\n\n" + this.resultSB.toString());
        } while (this.iterations < this.maxtrials && this.iterations - this.lastScoreChange < 10);
        this.displaySummary();
    }

    private boolean newSolution(GaIndividual i, int ptr) {
        int k = 0;
        while (k < this.individual.length) {
            if (i.getKey().equals(this.individual[k].getKey())) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private void reportDuplicates() {
        int dupes = 0;
        int dupescores = 0;
        int k = 0;
        while (k < this.individual.length) {
            int j = 0;
            while (j < this.individual.length) {
                if (this.individual[j].getKey().equals(this.individual[k].getKey()) && j != k) {
                    System.out.println(String.valueOf(k) + " = " + j);
                    ++dupes;
                }
                if (this.individual[j].getFitness() == this.individual[k].getFitness() && j != k) {
                    ++dupescores;
                }
                ++j;
            }
            ++k;
        }
        System.out.println("In the population of size " + this.individual.length + " there were " + dupes + " duplicate individuals and " + dupescores + " identical scores.");
    }

    private boolean success(GaIndividual indy) {
        return this.bestScore == this.individual[this.individual.length / 2].getFitness();
    }

    public GaIndividual getFittest(int n) {
        return this.individual[n];
    }

    private void shuffle(StringBuffer sb) {
        sb = new StringBuffer(this.shuffle(sb.toString()));
    }

    private String shuffle(String s) {
        StringBuffer sb = new StringBuffer(s);
        int k = 0;
        while (k < 20) {
            int a = (int)(Math.random() * (double)sb.length());
            int b = (int)(Math.random() * (double)sb.length());
            char ch = sb.charAt(a);
            sb.setCharAt(a, sb.charAt(b));
            sb.setCharAt(b, ch);
            ++k;
        }
        return sb.toString();
    }

    private void shuffle(int[] arr) {
        int k = 0;
        while (k < arr.length - 1) {
            int m = (int)(Math.random() * (double)(arr.length - 1));
            int temp = arr[k];
            arr[k] = arr[m];
            arr[m] = temp;
            ++k;
        }
    }

    private void tweak() {
        if (this.verbose) {
            System.out.println("************************ Tweaking ***************************");
        }
        int k = 0;
        while (k < this.individual.length) {
            this.individual[k] = new NgramGaIndividual(this.cleantext, this.makeKey(), this.params, this.ngramArr);
            ++k;
        }
        Arrays.sort(this.individual);
        this.displayAll();
        this.lastScoreChange = this.iterations;
        this.previousBestScore = Double.MAX_VALUE;
        this.bestScore = this.individual[0].getFitness();
    }

    private void displayCrossData(GaIndividual parent, GaIndividual child) {
        System.out.println("    abcdefghijklmnopqrstuvwxyz");
        System.out.println("P : " + parent.displayCrossData());
        System.out.println("C : " + child.displayCrossData());
    }

    private void makeStartMessage() {
        this.paramSB.append("\nSTARTING ANALYSIS\tBook: " + this.book + "\t nChars " + this.cleantext.length() + "\t nIndivs " + this.size);
        if (this.selection_policy == 0) {
            this.paramSB.append("\nSelection: ELITIST  ");
        } else {
            this.paramSB.append("\nSelection: PROPORTIONAL ");
        }
        if (this.mutate_policy == 1) {
            this.paramSB.append("  Mutation: RANDOM ");
        } else {
            this.paramSB.append(" Mutation:  ELITIST  ");
        }
        this.resultSB.append("\nTEXT: " + this.cleantext + "\n");
    }

    private boolean isBetter(GaIndividual child, GaIndividual parent) {
        double better = parent.getFitness() - child.getFitness();
        if (better > 0.0) {
            ++this.improved;
        } else if (better < 0.0) {
            ++this.worsened;
        } else {
            ++this.nochange;
        }
        return better > 0.0;
    }

    private void displayAll() {
        int k = 0;
        while (k < this.size) {
            System.out.println("---------------- " + k + " " + this.individual[k].displayCrossData());
            ++k;
        }
    }

    private void mutateAll() {
        this.mutated = 0;
        int k = 0;
        while (k < this.individual.length) {
            this.mutated += this.individual[k].mutate(this.mutate_rate);
            ++k;
        }
    }

    public void displayBest() {
        System.out.println(String.valueOf(this.iterations) + " " + this.num.format(this.bestScore) + " " + this.charErrs + " ERRS " + this.keyCount + " KEYS " + this.individual[0].toString() + " mutated=" + this.mutated + " median = " + this.num.format(this.individual[this.individual.length / 4].getFitness()) + " worst = " + this.num.format(this.individual[this.individual.length / 2].getFitness()));
    }

    public void displaySummary() {
        this.resultSB = new StringBuffer("\n\nFinished: Iterations = " + this.iterations + " Best score is " + this.num.format(this.bestScore) + " KeyCount = " + this.keyCount);
        if (this.mFrame != null) {
            this.mFrame.append(this.resultSB.toString());
        } else {
            System.out.println(this.resultSB);
        }
    }
}

