/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import hcrypto.analyzer.evolutionary.GaIndividual;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.tool.Dictionary;
import java.util.StringTokenizer;

public class WordBasedGaIndividual
extends GaIndividual
implements Comparable {
    public StringBuffer unusedLetters = new StringBuffer();
    public StringBuffer usedLetters = new StringBuffer();
    public String usedLettersNoDups = "";
    public String used_decrypt = "";
    public String unused_decrypt = "";
    public int word_count = 0;
    private Dictionary eval_dict;
    private double A;
    private double B;
    private double C;

    public WordBasedGaIndividual(String text, String initKey, Dictionary d, GaParameters p) {
        super(text, initKey, p);
        this.eval_dict = d;
        this.params = p;
        this.A = this.params.eval_A;
        this.B = this.params.eval_B;
        this.C = this.params.eval_C;
        this.mutate_policy = this.params.mutate_policy;
    }

    public WordBasedGaIndividual(GaIndividual i) {
        super(i);
        this.unusedLetters = ((WordBasedGaIndividual)i).unusedLetters;
        this.usedLetters = ((WordBasedGaIndividual)i).usedLetters;
        this.usedLettersNoDups = ((WordBasedGaIndividual)i).usedLettersNoDups;
        this.used_decrypt = ((WordBasedGaIndividual)i).used_decrypt;
        this.eval_dict = ((WordBasedGaIndividual)i).eval_dict;
        this.A = ((WordBasedGaIndividual)i).A;
        this.B = ((WordBasedGaIndividual)i).B;
        this.C = ((WordBasedGaIndividual)i).C;
    }

    public void cross(GaIndividual i) {
        char b;
        char a;
        char ch;
        WordBasedGaIndividual i1 = this;
        WordBasedGaIndividual i2 = (WordBasedGaIndividual)i;
        int k = 0;
        while (k < i1.usedLettersNoDups.length()) {
            ch = i1.usedLettersNoDups.charAt(k);
            a = i1.key.charAt(ch - 97);
            b = i2.key.charAt(ch - 97);
            i2.swap(a, b);
            ++k;
        }
        k = 0;
        while (k < i2.usedLettersNoDups.length()) {
            ch = i2.usedLettersNoDups.charAt(k);
            a = i2.key.charAt(ch - 97);
            b = i1.key.charAt(ch - 97);
            i1.swap(a, b);
            ++k;
        }
        i1.calcFitness();
        i2.calcFitness();
    }

    public int mutate(double rate) {
        if (Math.random() < rate) {
            WordBasedGaIndividual temp = new WordBasedGaIndividual(this);
            int a = (int)(Math.random() * 26.0);
            int b = (int)(Math.random() * 26.0);
            char ch = this.key.charAt(a);
            this.key.setCharAt(a, this.key.charAt(b));
            this.key.setCharAt(b, ch);
            this.calcFitness();
            if (this.mutate_policy == 0 && this.getFitness() < temp.getFitness()) {
                this.key = temp.key;
                this.fitness = temp.fitness;
                this.decrypt = temp.decrypt;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public int mutateUnused(double rate) {
        WordBasedGaIndividual temp = new WordBasedGaIndividual(this);
        int len = this.unused_decrypt.length();
        int a = (int)(Math.random() * (double)len);
        int b = (int)(Math.random() * (double)len);
        char ch = this.unused_decrypt.charAt(a);
        char ch2 = this.unused_decrypt.charAt(b);
        this.swap(ch, ch2);
        this.calcFitness();
        if (this.getFitness() < temp.getFitness()) {
            return 1;
        }
        return 0;
    }

    public void calcFitness() {
        try {
            this.sKey.init(String.valueOf(this.key.toString()) + "/az");
            this.cipher.init(this.sKey);
            this.decrypt = this.ciphertext.length() <= 5000 ? this.cipher.decrypt(this.ciphertext) : this.cipher.decrypt(this.ciphertext.substring(0, 5000));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.usedLetters = new StringBuffer();
        this.fitness = this.evaluate(this.decrypt, this.usedLetters);
        this.usedLettersNoDups = "";
        this.used_decrypt = "";
        this.unused_decrypt = "";
        int k = 0;
        while (k < this.usedLetters.length()) {
            char ch = this.usedLetters.charAt(k);
            if (this.usedLettersNoDups.indexOf(ch) == -1) {
                this.usedLettersNoDups = String.valueOf(this.usedLettersNoDups) + ch;
                this.used_decrypt = String.valueOf(this.used_decrypt) + this.key.charAt(ch - 97);
            }
            ++k;
        }
        char ch = 'a';
        while (ch <= 'z') {
            if (this.used_decrypt.indexOf(ch) == -1) {
                this.unused_decrypt = String.valueOf(this.unused_decrypt) + ch;
            }
            ch = (char)(ch + 1);
        }
    }

    public double evaluate(String text, StringBuffer usedLetters) {
        StringTokenizer st = new StringTokenizer(text);
        int count = 0;
        double freqs = 0.0;
        double chars = 0.0;
        double charsInWords = 0.0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            chars += (double)s.length();
            if (!this.eval_dict.contains(s)) continue;
            ++count;
            freqs += this.eval_dict.getFreq(s);
            charsInWords += (double)s.length();
            usedLetters.append(s);
        }
        return this.A * (double)count + this.B * charsInWords / chars + this.C * freqs;
    }

    public String displayCrossData() {
        return String.valueOf(this.getKey()) + " (" + this.getFitness() + ") " + this.usedLetters.toString();
    }

    public String toString() {
        return String.valueOf(this.getKey()) + " Used " + this.usedLetters.toString();
    }
}

