/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.evolutionary;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.evolutionary.GaIndividual;
import hcrypto.analyzer.evolutionary.GaParameters;
import hcrypto.analyzer.evolutionary.GaPopulation;
import hcrypto.analyzer.evolutionary.WordBasedGaIndividual;
import hcrypto.analyzer.tool.Dictionary;
import hcrypto.analyzer.tool.PatternDictionary;
import hcrypto.analyzer.tool.TextUtilities;
import hcrypto.analyzer.tool.Token;
import hcrypto.analyzer.tool.WordPairs;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.StringTokenizer;

public class WordBasedGaPopulation
extends GaPopulation {
    private static final int NO_CHANGE_LIMIT = 20;
    private static final int N_SHUFFLES = 50;
    private StringBuffer paramSB;
    private StringBuffer resultSB;
    protected PatternDictionary seed_dict;
    protected Dictionary eval_dict;
    private Token[] tokens;
    private WordPairs[] pairs;
    private int nPairs;
    private int nTokens;
    private int nWords;
    private int nWordsSolution;
    private String message_unused;
    private int wordpairPtr;
    private int[] counter;
    private boolean[] pairchecker;
    private int nTweaks = 0;
    private NumberFormat num;
    private int keyCount = 0;
    private int charErrs = 0;
    private double percentTokens = 0.0;

    public WordBasedGaPopulation(AnalyzerFrame f, String text, String solution, GaParameters params) {
        super(text, solution, params);
        this.mFrame = f;
        this.num = NumberFormat.getInstance();
        this.num.setMaximumFractionDigits(2);
    }

    public void init() {
        this.resultSB = new StringBuffer();
        this.paramSB = new StringBuffer();
        System.out.println("SEED DICTIONARY");
        this.seed_dict = new PatternDictionary(this.params.seed_dict);
        System.out.println("EVAL DICTIONARY");
        this.eval_dict = this.params.eval_dict == 0 ? new Dictionary(this.params.dict_name) : new PatternDictionary(this.params.eval_dict);
        this.nTokens = TextUtilities.countTokens(this.cleantext);
        this.nWords = TextUtilities.countWords(this.eval_dict, this.cleantext);
        this.nWordsSolution = TextUtilities.countWords(this.eval_dict, this.solution.toLowerCase());
        System.out.println("SOLUTION: (" + this.nWordsSolution + ") " + this.solution);
        this.message_unused = TextUtilities.getUnusedLetters(this.cleantext);
        this.tokens = this.initWordArray(this.cleantext);
        Arrays.sort(this.tokens);
        this.pairs = this.makeWordPairs(this.tokens, this.nTokens * this.seed_dict.nWords());
        if (this.nPairs == 0) {
            this.seeding = 0;
        }
        this.individual = new WordBasedGaIndividual[this.size * 2];
        System.out.println("NPAIRS = " + this.nPairs + " POPULATION SIZE = " + this.size);
        String key = null;
        this.wordpairPtr = 0;
        this.counter = new int[10];
        this.pairchecker = new boolean[this.nPairs];
        switch (this.seeding) {
            case 1: {
                System.out.println("USING RANDOM SEEDING");
                break;
            }
            case 0: {
                System.out.println("USING NO SEEDING");
                break;
            }
            default: {
                System.out.println("USING DETERMINISTIC SEEDING");
            }
        }
        int k = 0;
        while (k < this.individual.length) {
            key = this.makeKey();
            this.individual[k] = new WordBasedGaIndividual(this.cleantext, key, this.eval_dict, this.params);
            ++this.keyCount;
            ++k;
        }
    }

    private Token[] initWordArray(String text) {
        StringTokenizer st = new StringTokenizer(text);
        Token[] tokens = new Token[st.countTokens()];
        int k = 0;
        while (st.hasMoreTokens()) {
            tokens[k] = new Token(st.nextToken(), this.seed_dict);
            ++k;
        }
        return tokens;
    }

    private WordPairs[] makeWordPairs(Token[] tokens, int size) {
        WordPairs[] pairs = new WordPairs[size];
        this.nPairs = 0;
        int k = 0;
        int t = 0;
        Token token = tokens[t++];
        StringTokenizer st = new StringTokenizer(this.seed_dict.getWordList(token.getToken()));
        while (st != null && k < size && t < tokens.length) {
            if (!st.hasMoreTokens()) {
                token = tokens[t++];
                st = new StringTokenizer(this.seed_dict.getWordList(token.getToken()));
            }
            if (st == null || !st.hasMoreTokens()) continue;
            String w = st.nextToken();
            pairs[k] = new WordPairs(token.getToken(), w);
            ++k;
        }
        this.nPairs = k;
        return pairs;
    }

    private String makeKey() {
        switch (this.seeding) {
            case 0: {
                return this.randomKey();
            }
        }
        return this.seedKey(this.seeding);
    }

    private String randomKey() {
        String alpha = new String("abcdefghijklmnopqrstuvwxyz");
        return this.shuffle(alpha);
    }

    private String seedKey(int seedtype) {
        StringBuffer alpha = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
        StringBuffer key = new StringBuffer("**************************");
        StringBuffer used = new StringBuffer();
        String crypto = null;
        String plain = null;
        int p = 0;
        int nWords = 0;
        boolean fits = true;
        if (seedtype == 1) {
            do {
                p = (int)(Math.random() * (double)this.nPairs);
                crypto = this.pairs[p].crypto;
                plain = this.pairs[p].plain;
                fits = this.tokenWordPairFits(key, crypto, plain);
                if (!fits) continue;
                this.pairchecker[p] = true;
                ++nWords;
                int j = 0;
                while (j < crypto.length()) {
                    key.setCharAt(plain.charAt(j) - 97, crypto.charAt(j));
                    ++j;
                }
                used.append(crypto);
            } while (fits);
        } else {
            p = this.wordpairPtr;
            this.wordpairPtr = (this.wordpairPtr + 1) % this.nPairs;
            crypto = this.pairs[p].crypto;
            plain = this.pairs[p].plain;
            fits = this.tokenWordPairFits(key, crypto, plain);
            if (fits) {
                this.pairchecker[p] = true;
                ++nWords;
                int j = 0;
                while (j < crypto.length()) {
                    key.setCharAt(plain.charAt(j) - 97, crypto.charAt(j));
                    ++j;
                }
                used.append(crypto);
            }
        }
        int n = nWords;
        this.counter[n] = this.counter[n] + 1;
        this.finalizeKey(key, used);
        return key.toString();
    }

    private boolean tokenWordPairFits(StringBuffer key, String crypto, String plain) {
        boolean fits = true;
        int k = 0;
        while (k < crypto.length()) {
            char w1 = crypto.charAt(k);
            char t1 = plain.charAt(k);
            char et1 = key.charAt(t1 - 97);
            if (et1 != '*' && et1 != w1) {
                fits = false;
            }
            if (fits) {
                int indx = key.toString().indexOf(w1);
                char dw1 = '*';
                if (indx != -1) {
                    dw1 = (char)(97 + indx);
                }
                if (dw1 != '*' && dw1 != t1) {
                    fits = false;
                }
            }
            ++k;
        }
        return fits;
    }

    private void finalizeKey(StringBuffer key, StringBuffer used) {
        String usedStr = used.toString();
        StringBuffer unused = new StringBuffer();
        char ch = 'z';
        while (ch >= 'a') {
            if (usedStr.indexOf(ch) == -1) {
                unused.append(ch);
            }
            ch = (char)(ch - '\u0001');
        }
        this.shuffle(unused);
        int m = 0;
        int k = 0;
        while (k < key.length()) {
            if (key.charAt(k) == '*') {
                key.setCharAt(k, unused.charAt(m));
                ++m;
            }
            ++k;
        }
    }

    public void run() {
        this.makeStartMessage();
        Arrays.sort(this.individual);
        do {
            int ptr = this.size;
            int k = 0;
            while (k < this.size / 2) {
                int j = (int)(Math.random() * (double)this.size);
                double rand = Math.random();
                if (rand <= this.cross_rate) {
                    WordBasedGaIndividual i1 = new WordBasedGaIndividual(this.individual[k]);
                    WordBasedGaIndividual i2 = new WordBasedGaIndividual(this.individual[j]);
                    ((GaIndividual)i1).cross(i2);
                    this.individual[ptr++] = i1;
                    this.individual[ptr++] = i2;
                }
                ++k;
            }
            this.mutateAll();
            ++this.iterations;
            Arrays.sort(this.individual);
            if (this.selection_policy == 1) {
                this.selectProportional();
            }
            this.updateScore();
            this.keyCount += this.individual.length;
            this.percentTokens = TextUtilities.percentWords(this.solution, this.individual[0].getDecrypt());
            this.charErrs = TextUtilities.countInCorrectChars(this.solution, this.individual[0].getDecrypt());
            if (this.verbose) {
                this.displayBest();
            }
            if (this.mFrame == null) continue;
            this.resultSB = new StringBuffer(this.individual[0].getDecrypt());
            this.mFrame.setText(String.valueOf(this.paramSB.toString()) + "\n\n" + this.resultSB.toString());
        } while (this.iterations < this.maxtrials && this.iterations - this.lastScoreChange < 20);
        this.displaySummary();
        System.out.println("Unused = " + ((WordBasedGaIndividual)this.individual[0]).unused_decrypt + "=" + this.message_unused);
    }

    private boolean success(GaIndividual indy) {
        return this.bestScore == this.individual[this.individual.length / 2].getFitness();
    }

    public GaIndividual getFittest(int n) {
        return this.individual[n];
    }

    private void shuffle(StringBuffer sb) {
        sb = new StringBuffer(this.shuffle(sb.toString()));
    }

    private String shuffle(String s) {
        StringBuffer sb = new StringBuffer(s);
        int k = 0;
        while (k < 50) {
            int a = (int)(Math.random() * (double)sb.length());
            int b = (int)(Math.random() * (double)sb.length());
            char ch = sb.charAt(a);
            sb.setCharAt(a, sb.charAt(b));
            sb.setCharAt(b, ch);
            ++k;
        }
        return sb.toString();
    }

    private void tweak() {
        if (this.verbose) {
            System.out.println("$$$$$$$$$$$$$$$$ Tweaking $$$$$$$$$$$$$$$$$$$$");
        }
        int k = 0;
        while (k < this.size) {
            this.individual[k] = new WordBasedGaIndividual(this.cleantext, this.makeKey(), this.eval_dict, this.params);
            ++k;
        }
        Arrays.sort(this.individual);
        this.lastScoreChange = this.iterations;
        this.previousBestScore = 0.0;
        this.bestScore = this.individual[0].getFitness();
    }

    private void displayCrossData(GaIndividual parent, GaIndividual child) {
        System.out.println("    abcdefghijklmnopqrstuvwxyz");
        System.out.println("P : " + parent.displayCrossData());
        System.out.println("C : " + child.displayCrossData());
    }

    private void makeStartMessage() {
        this.paramSB.append("STARTING ANALYSIS\t nTokens " + this.nTokens + "\t nWords " + this.nWords + "\t nWordsSolution " + this.nWordsSolution + "\t nChars " + this.cleantext.length() + "\t nIndivs " + this.size);
        this.paramSB.append("\nSeed Dictionary: " + this.seed_dict.getDictionaryName() + "\t Eval Dictionary: " + this.eval_dict.getDictionaryName());
        if (this.selection_policy == 0) {
            this.paramSB.append("\nSelection: ELITIST  ");
        } else {
            this.paramSB.append("\nSelection: PROPORTIONAL ");
        }
        if (this.mutate_policy == 1) {
            this.paramSB.append("\tMutation: RANDOM ");
        } else {
            this.paramSB.append("\tMutation:  ELITIST  ");
        }
        this.resultSB.append("\nTEXT: " + this.cleantext + "\n");
    }

    private boolean isBetter(GaIndividual child, GaIndividual parent) {
        double better = child.getFitness() - parent.getFitness();
        if (better > 0.0) {
            ++this.improved;
        } else if (better < 0.0) {
            ++this.worsened;
        } else {
            ++this.nochange;
        }
        return better > 0.0;
    }

    private void displayAll() {
        int k = 0;
        while (k < this.size) {
            System.out.println("---------------- " + k + " " + this.individual[k].displayCrossData());
            ++k;
        }
    }

    private void mutateAll() {
        this.mutated = 0;
        int k = 0;
        while (k < this.size * 2) {
            this.mutated += this.individual[k].mutate(this.mutate_rate);
            ++k;
        }
    }

    public void displayBest() {
        System.out.println(String.valueOf(this.iterations) + " " + this.num.format(this.bestScore) + " " + this.num.format(this.percentTokens) + "% " + this.charErrs + " ERRS " + this.keyCount + " KEYS " + this.individual[0].getKey() + " mutated=" + this.mutated + " median = " + this.num.format(this.individual[this.individual.length / 4].getFitness()) + " worst = " + this.num.format(this.individual[this.individual.length / 2].getFitness()));
    }

    public void displaySummary() {
        this.resultSB = new StringBuffer("\n\nFinished: Iterations = " + this.iterations + " Best score is " + this.num.format(this.bestScore) + " KeyCount = " + this.keyCount);
        if (this.mFrame != null) {
            this.mFrame.append(this.resultSB.toString());
        } else {
            System.out.println(this.resultSB);
        }
    }

    protected void updateScore() {
        this.bestScore = this.individual[0].getFitness();
        if (this.bestScore > this.previousBestScore) {
            this.previousBestScore = this.bestScore;
            this.lastScoreChange = this.iterations;
        }
    }

    public PatternDictionary getSeedDict() {
        return this.seed_dict;
    }

    public Dictionary getEvalDict() {
        return this.eval_dict;
    }
}

