/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Dictionary {
    protected static final float LOAD_FACTOR = 0.5f;
    public static final int BIG_DICT = 0;
    public static final int KUCERA_340 = 1;
    public static final int KUCERA_100 = 2;
    public static final int KUCERA_50 = 3;
    public static final int KUCERA_3500 = 4;
    public static final int MIN_FREQ = 0;
    protected Hashtable dict = new Hashtable(200000, 0.5f);
    protected int min_freq = 0;
    protected double total_freq = 0.0;
    protected String fName;

    public Dictionary() {
    }

    public Dictionary(String filename) {
        this();
        this.fName = filename;
        this.init(filename, true, this.min_freq);
    }

    public Dictionary(String filename, boolean linebreaks) {
        this();
        this.fName = filename;
        this.init(filename, linebreaks, this.min_freq);
    }

    public Dictionary(String filename, boolean linebreaks, int minfreq) {
        this();
        this.fName = filename;
        this.init(filename, linebreaks, minfreq);
    }

    public String getDictionaryName() {
        return this.fName;
    }

    /*
     * Unable to fully structure code
     */
    private void init(String filename, boolean linebreaks, int minfreq) {
        st = null;
        line = null;
        word = null;
        freqSt = "0";
        freq = minfreq;
        this.total_freq = 0.0;
        try {
            block8: {
                inStream = new BufferedReader(new FileReader(filename));
                line = inStream.readLine();
                if (!linebreaks) ** GOTO lbl32
                while (line != null) {
                    st = new StringTokenizer(line);
                    word = st.nextToken().toLowerCase();
                    if (st.hasMoreTokens()) {
                        freqSt = st.nextToken();
                        freq = Integer.parseInt(freqSt);
                        this.total_freq += (double)freq;
                    }
                    if (freq >= minfreq) {
                        this.dict.put(word, freqSt);
                    }
                    line = inStream.readLine();
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    System.out.println("Line= " + line);
                    st = new StringTokenizer(line);
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        this.dict.put(s.toLowerCase(), s.toLowerCase());
                    }
                    line = inStream.readLine();
lbl32:
                    // 2 sources

                    ** while (line != null)
                }
            }
            inStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Dictionary size = " + this.dict.size() + " with total frequencies " + this.total_freq);
    }

    public boolean contains(String word) {
        return this.dict.containsKey(word);
    }

    public double getFreq(String word) {
        String freqStr = (String)this.dict.get(word);
        if (freqStr != null) {
            return (double)Integer.parseInt(freqStr) / this.total_freq;
        }
        return 0.0;
    }

    public int size() {
        return this.dict.size();
    }

    public String getDescriptor(int i) {
        switch (i) {
            case 1: {
                return "Kucera340";
            }
            case 2: {
                return "Kucera100";
            }
            case 3: {
                return "Kucera50";
            }
            case 4: {
                return "Kucera3500";
            }
            case 5: {
                return "Kucera10";
            }
        }
        return "Invalid Dictionary number: " + i;
    }

    public static void main(String[] args) {
        Dictionary d;
        if (args.length < 1) {
            System.out.println("Usage: java Dictionary filename [nolinebreaks]");
            d = new Dictionary();
        } else {
            d = args.length == 2 ? new Dictionary(args[0], false) : new Dictionary(args[0], true);
        }
        System.out.println("The dictionary has " + d.size() + " words");
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Search for >>");
            String word = input.readLine();
            while (word.length() != 0) {
                if (d.contains(word)) {
                    System.out.println(String.valueOf(word) + " is a word with frequency " + d.getFreq(word));
                } else {
                    System.out.println(String.valueOf(word) + " is not found");
                }
                System.out.print("Search for >>");
                word = input.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

