/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import hcrypto.analyzer.Analyzer;
import hcrypto.analyzer.tool.FrequencyRecord;
import hcrypto.cipher.Alphabet;
import hcrypto.cipher.AlphabetFactory;
import java.util.Arrays;

public class FrequencyTable
implements Analyzer {
    public static final int MAX_CHARS = 128;
    private int alphabetRange = 5;
    private String text;
    Alphabet alphabet = null;
    private int charCount = 0;
    private int alphabeticsCount = 0;
    private int highestFreq;
    private FrequencyRecord[] frequencies = new FrequencyRecord[128];
    private FrequencyRecord[] sortedFrequencies = new FrequencyRecord[this.frequencies.length];
    private int[] histogram = new int[128];

    public FrequencyTable(String text) {
        this.setup(text);
    }

    public FrequencyTable(String text, int alpha) {
        this.alphabetRange = alpha;
        this.setup(text);
    }

    public void setup(String text) {
        this.text = text;
        this.count();
        this.sort();
    }

    public void run() {
    }

    public String getReport() {
        return this.toString();
    }

    public void setAlphabetRange(int range) {
        if (this.alphabetRange == range) {
            return;
        }
        this.alphabetRange = range;
        this.setup(this.text);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n");
        int k = 0;
        while (k < this.frequencies.length) {
            sb.append(String.valueOf(this.charToString(this.frequencies[k].ch)) + ":" + this.frequencies[k].count + " ");
            if ((k + 1) % 10 == 0) {
                sb.append("\n");
            }
            ++k;
        }
        sb.append("\n");
        return sb.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }

    public void count() {
        this.alphabet = null;
        int size = 128;
        this.frequencies = new FrequencyRecord[size];
        int k = 0;
        while (k < this.frequencies.length) {
            this.frequencies[k] = new FrequencyRecord((char)k, 0);
            ++k;
        }
        try {
            this.alphabet = AlphabetFactory.getInstance(this.alphabetRange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.charCount = 0;
        this.alphabeticsCount = 0;
        this.highestFreq = 0;
        k = 0;
        while (k < this.text.length()) {
            char ch = this.text.charAt(k);
            if (Character.isLetter(ch)) {
                ++this.alphabeticsCount;
            }
            if (this.alphabet.isInAlphabet(ch)) {
                ++this.charCount;
                ++this.frequencies[ch].count;
                if (this.frequencies[ch].count > this.highestFreq) {
                    this.highestFreq = this.frequencies[ch].count;
                }
            }
            ++k;
        }
    }

    public int getHighestFreq() {
        return this.highestFreq;
    }

    public String getKHighestFreqChar(int k) {
        return this.charToString(this.sortedFrequencies[k - 1].ch);
    }

    public FrequencyRecord[] getCryptogramFrequencies() {
        FrequencyRecord[] freqs = new FrequencyRecord[27];
        freqs[0] = this.frequencies[32];
        int k = 1;
        while (k <= 26) {
            freqs[k] = this.frequencies[97 + k - 1];
            ++k;
        }
        return freqs;
    }

    public FrequencyRecord[] getSortedCryptogramFrequencies() {
        Object[] freqs = this.getCryptogramFrequencies();
        Arrays.sort(freqs);
        return freqs;
    }

    public int[] getFrequencies() {
        return this.getHistogramData();
    }

    public int[] getHistogramData() {
        int k = 0;
        while (k < this.histogram.length) {
            this.histogram[k] = this.frequencies[k].count;
            ++k;
        }
        return this.histogram;
    }

    protected String charToString(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return String.valueOf(ch);
        }
        return "\\" + ch;
    }

    public int getCharCount() {
        return this.charCount;
    }

    public int getAlphabeticsCount() {
        return this.alphabeticsCount;
    }

    public int getCount(int ch) {
        return this.frequencies[ch].count;
    }

    protected void sort() {
        this.sortedFrequencies = new FrequencyRecord[this.frequencies.length];
        int k = 0;
        while (k < this.frequencies.length) {
            this.sortedFrequencies[k] = new FrequencyRecord(this.frequencies[k]);
            ++k;
        }
        Arrays.sort(this.sortedFrequencies);
    }
}

