/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import hcrypto.analyzer.tool.FrequencyTable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;

public class Histogram
extends Canvas
implements MouseMotionListener {
    public static final int WIDTH = 350;
    public static final int HEIGHT = 200;
    public static final int XMARGIN = 10;
    public static final int YMARGIN = 12;
    public static final int FIRST_CHAR = 2;
    private int[] histogram;
    private FrequencyTable freqTable;

    public Histogram(FrequencyTable ft) {
        this.freqTable = ft;
        this.histogram = ft.getHistogramData();
        this.setSize(350, 200);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        this.draw(g);
    }

    public void redraw() {
        this.repaint();
    }

    private void draw(Graphics g) {
        double maxFreq = this.freqTable.getHighestFreq();
        this.histogram = this.freqTable.getHistogramData();
        int maxbar = 174;
        g.setColor(Color.white);
        g.fillRect(0, 0, 350, 200);
        g.setColor(Color.black);
        g.drawRect(10, 12, 330, 180);
        int x = 12;
        int y = 188;
        int i = 0;
        while (i < this.histogram.length) {
            int count = this.histogram[i];
            g.drawLine(x + 2 * i, y, x + 2 * i, y - (int)((double)(maxbar * count) / maxFreq));
            ++i;
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseMoved(e.getX(), e.getY());
    }

    public void mouseMoved(int x, int y) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        Graphics g = this.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 350, 11);
        g.setColor(Color.red);
        char ch = (char)((x - 10 - 2) / 2);
        if (ch >= '\u0000' && ch < '\u0080') {
            this.setCursor(Cursor.getPredefinedCursor(1));
            g.drawString("Char: " + this.charToString(ch) + " Count: " + this.freqTable.getCount(ch) + " Freq: " + nf.format(1.0 * (double)this.freqTable.getCount(ch) / (double)this.freqTable.getCharCount()), 10, 9);
        } else {
            g.drawString("Char:   Count:   Freq:  ", 10, 9);
        }
    }

    protected String charToString(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return String.valueOf(ch);
        }
        return "\\" + ch;
    }
}

