/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import hcrypto.analyzer.Analyzer;
import hcrypto.analyzer.tool.FrequencyTable;
import java.text.NumberFormat;

public class IndexOfCoincidence
implements Analyzer {
    private String text = null;
    private FrequencyTable ft;
    private double ioc = -1.0;

    public IndexOfCoincidence() {
    }

    public IndexOfCoincidence(String text) {
        this.setup(text);
    }

    public double getIOC() {
        try {
            if (this.text == null) {
                throw new Exception("ERROR: IndexOfCoincidence is not properly initialized");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.ioc;
    }

    public void setup(String text) {
        this.text = text;
        this.ft = new FrequencyTable(text);
        this.ioc = this.computeIOC();
    }

    public void run() {
    }

    public String getReport() {
        return this.toString();
    }

    public String toString() {
        if (this.text != null) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            return "Index of Coincidence = " + nf.format(this.ioc) + "\n";
        }
        return "This analyzer has not been setup() properly";
    }

    private double computeIOC() {
        int[] frequencies = this.ft.getFrequencies();
        int count = this.ft.getAlphabeticsCount();
        double sumFreqs = 0.0;
        int k = 97;
        while (k <= 122) {
            double freq = frequencies[k] + frequencies[k - 32];
            sumFreqs += freq * (freq - 1.0);
            ++k;
        }
        return sumFreqs / ((double)count * ((double)count - 1.0));
    }
}

