/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import hcrypto.analyzer.tool.Dictionary;
import hcrypto.analyzer.tool.KuceraFrancis100;
import hcrypto.analyzer.tool.KuceraFrancis25;
import hcrypto.analyzer.tool.KuceraFrancis340;
import hcrypto.analyzer.tool.KuceraFrancis3500;
import hcrypto.analyzer.tool.KuceraFrancis50;
import hcrypto.analyzer.tool.PatternWord;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PatternDictionary
extends Dictionary {
    private int nWords = 0;

    public PatternDictionary() {
        this(4);
        this.fName = "Kucera3500";
    }

    public PatternDictionary(int i) {
        switch (i) {
            case 1: {
                this.init(KuceraFrancis340.wordlist);
                this.fName = "Kucera340";
                System.out.println("Kucera340");
                break;
            }
            case 2: {
                this.init(KuceraFrancis100.wordlist);
                this.fName = "Kucera100";
                System.out.println("Kucera100");
                break;
            }
            case 3: {
                this.init(KuceraFrancis50.wordlist);
                this.fName = "Kucera50";
                System.out.println("Kucera50");
                break;
            }
            case 4: {
                this.init(KuceraFrancis3500.wordlist);
                this.fName = "Kucera3500";
                System.out.println("Kucera3500");
                break;
            }
            case 5: {
                this.init(KuceraFrancis25.wordlist);
                this.fName = "KuceraFrancis25";
                System.out.println("KuceraFrancis25");
                break;
            }
            default: {
                this.init(KuceraFrancis340.wordlist);
                this.fName = "Kucera340";
                System.out.println("Kucera340");
            }
        }
    }

    public PatternDictionary(String filename) {
        this.init(filename);
    }

    private void init(String[][] wordlist) {
        double freq = 0.0;
        String word = null;
        double total_words = Integer.parseInt(wordlist[0][1]);
        int k = 1;
        while (k < wordlist.length) {
            word = wordlist[k][0];
            freq = (double)Integer.parseInt(wordlist[k][1]) / total_words;
            this.insert(new PatternWord(word, freq));
            ++this.nWords;
            ++k;
        }
    }

    private void init(String filename) {
        System.out.print("PatternDictionary: Reading words from " + filename);
        double freq = 0.0;
        double total_words = 0.0;
        StringTokenizer st = null;
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(filename));
            String line = inStream.readLine();
            st = new StringTokenizer(line);
            String word = st.nextToken();
            if (st.hasMoreTokens()) {
                total_words = Integer.parseInt(st.nextToken());
            }
            line = inStream.readLine();
            while (line != null) {
                st = new StringTokenizer(line);
                word = st.nextToken();
                if (st.hasMoreTokens()) {
                    freq = (double)Integer.parseInt(st.nextToken()) / total_words;
                }
                this.insert(new PatternWord(word, freq));
                ++this.nWords;
                line = inStream.readLine();
            }
            inStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(" size = " + this.dict.size());
    }

    public int nWords() {
        return this.nWords;
    }

    private void insert(PatternWord word) {
        String lcw = word.getWord();
        String key = word.getPattern();
        if (this.dict.containsKey(key)) {
            Hashtable h = (Hashtable)this.dict.get(key);
            h.put(lcw, word);
        } else {
            Hashtable<String, PatternWord> h = new Hashtable<String, PatternWord>(500, 0.5f);
            h.put(lcw, word);
            this.dict.put(key, h);
        }
    }

    public double getFrequency(String word) {
        String pattern = PatternDictionary.makePattern(word);
        Hashtable wordtable = (Hashtable)this.dict.get(pattern);
        if (wordtable != null && wordtable.containsKey(word)) {
            PatternWord pw = (PatternWord)wordtable.get(word);
            return pw.getFrequency();
        }
        return 0.0;
    }

    public static String makePattern(String s) {
        String word = s.toLowerCase();
        String patternLetters = "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int p = 0;
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < Math.min(word.length(), patternLetters.length())) {
            char ch = word.charAt(k);
            int index = word.substring(0, k).indexOf(ch);
            if (index == -1) {
                sb.append(patternLetters.charAt(p));
                ++p;
            } else {
                sb.append(sb.charAt(index));
            }
            ++k;
        }
        return sb.toString();
    }

    public double getFreq(String word) {
        return this.getFrequency(word);
    }

    public boolean contains(String word) {
        String pattern = PatternDictionary.makePattern(word);
        Hashtable wordtable = (Hashtable)this.dict.get(pattern);
        if (wordtable != null) {
            return wordtable.containsKey(word);
        }
        return false;
    }

    public boolean containsPattern(String pattern) {
        return this.dict.containsKey(pattern);
    }

    public int countWordsForPattern(String pattern) {
        Hashtable h = (Hashtable)this.dict.get(pattern);
        if (h != null) {
            return h.size();
        }
        return 0;
    }

    public String[] getPatternWordArray(String word) {
        String pattern = PatternDictionary.makePattern(word);
        if (!this.containsPattern(pattern)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.getWordList(word));
        String[] words = new String[st.countTokens()];
        int k = 0;
        while (st.hasMoreTokens()) {
            words[k++] = new String(st.nextToken());
        }
        return words;
    }

    public String getWordList(String word) {
        StringBuffer sb = new StringBuffer();
        String pattern = PatternDictionary.makePattern(word);
        Hashtable ht = (Hashtable)this.dict.get(pattern);
        if (ht == null) {
            return "";
        }
        Enumeration words = ht.keys();
        while (words.hasMoreElements()) {
            sb.append(words.nextElement());
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        PatternDictionary d;
        if (args.length < 1) {
            System.out.println("Usage: java PatternDictionary filename");
            d = new PatternDictionary();
        } else {
            d = new PatternDictionary(args[0]);
        }
        System.out.println("The pattern dictionary has " + d.nWords() + " words  and " + d.size() + " patterns");
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Search for >>");
            String word = input.readLine();
            while (word.length() != 0) {
                String pattern = PatternDictionary.makePattern(word);
                if (d.containsPattern(pattern)) {
                    System.out.println(String.valueOf(pattern) + " " + d.getFrequency(word) + " " + d.getWordList(word));
                } else {
                    System.out.println(String.valueOf(word) + " with pattern " + pattern + " is not found");
                }
                System.out.print("Search for >>");
                word = input.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

