/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

public class PatternWord
implements Comparable {
    private String word;
    private String pattern;
    private double score;
    private double frequency;

    public PatternWord(String s, double freq) {
        this.word = new String(s.toLowerCase());
        this.pattern = new String(PatternWord.makePattern(s));
        this.frequency = freq;
        this.score = this.computeScore(this.pattern);
    }

    public String getWord() {
        return this.word;
    }

    public String getPattern() {
        return this.pattern;
    }

    public double getScore() {
        return this.score;
    }

    public double getFrequency() {
        return this.frequency;
    }

    private int computeScore(String s) {
        int sum = 0;
        int k = 0;
        while (k < s.length()) {
            char digit = s.charAt(k);
            if (Character.isDigit(digit)) {
                sum += digit - 48;
            } else if (Character.isUpperCase(digit)) {
                sum += 10 + digit - 65;
            }
            ++k;
        }
        return sum;
    }

    public static String makePattern(String s) {
        String word = s.toLowerCase();
        String patternLetters = "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int p = 0;
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < Math.min(word.length(), patternLetters.length())) {
            char ch = word.charAt(k);
            int index = word.substring(0, k).indexOf(ch);
            if (index == -1) {
                sb.append(patternLetters.charAt(p));
                ++p;
            } else {
                sb.append(sb.charAt(index));
            }
            ++k;
        }
        return sb.toString();
    }

    public int compareTo(Object o) {
        PatternWord t = (PatternWord)o;
        if (this.score < t.score) {
            return 1;
        }
        if (this.score > t.score) {
            return -1;
        }
        return 0;
    }
}

