/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import applications.cryptotoolj.AnalyzerFrame;
import hcrypto.analyzer.Analyzer;
import hcrypto.analyzer.tool.FrequencyTable;
import hcrypto.analyzer.tool.Histogram;
import hcrypto.analyzer.tool.TextStatistics;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;

public class TextAnalyzer
extends AnalyzerFrame
implements Analyzer,
ItemListener {
    static final int HIST_WIDTH = 350;
    static final int HIST_HEIGHT = 200;
    static final int WIN_WIDTH = 400;
    static final int WIN_HEIGHT = 400;
    static final int BAR_HEIGHT = 12;
    private Histogram histogram;
    private FrequencyTable freqTable;
    private TextStatistics stats;
    private int alphabetRange;
    private String text;
    private Panel histoPanel;
    private Checkbox azButton;
    private Checkbox AZButton;
    private Checkbox azAZButton;
    private Checkbox azAZ09Button;
    private Checkbox printableButton;
    private Checkbox asciiButton;
    private CheckboxGroup alphabetGroup;
    private Button list;
    private Button save;
    private Button copy;
    private Label count;
    private Label alphaCount;
    private Label coIndex;
    private Label chValue;
    private Label chCount;
    private NumberFormat nf;
    public static int nBins = 256;

    public TextAnalyzer() {
        this.setTitle("Text Histogram");
        this.setSize(400, 400);
        this.setLocation(400, 100);
        this.setVisible(true);
    }

    public void setup(String text) {
        this.text = text;
        this.stats = new TextStatistics(text, true);
        this.freqTable = this.stats.getFrequencyTable();
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(3);
        this.histogram = new Histogram(this.freqTable);
        this.histoPanel.add(this.histogram);
        this.count.setText("  Chars: " + this.stats.charCount);
        this.alphaCount.setText("  Alphabetics " + this.stats.alphabeticsCount);
        this.coIndex.setText("  Coincidence Index " + this.nf.format(this.stats.coincidenceIndex));
    }

    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        this.histoPanel = new Panel();
        this.add((Component)this.histoPanel, "Center");
        Panel controlPanel = new Panel();
        Panel buttonsPanel = new Panel();
        buttonsPanel.setLayout(new GridLayout(6, 1));
        this.addButtons(buttonsPanel);
        Panel statsPanel = new Panel();
        statsPanel.setLayout(new GridLayout(5, 1));
        this.addStats(statsPanel);
        controlPanel.add(buttonsPanel);
        controlPanel.add(statsPanel);
        this.add((Component)controlPanel, "South");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TextAnalyzer.this.setVisible(false);
            }
        });
    }

    private void addStats(Panel statsPanel) {
        this.count = new Label("                     ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        statsPanel.add(this.count);
        this.alphaCount = new Label("                     ");
        this.alphaCount.setFont(new Font("Monospaced", 0, 12));
        statsPanel.add(this.alphaCount);
        this.coIndex = new Label("                     ");
        this.coIndex.setFont(new Font("Monospaced", 0, 12));
        statsPanel.add(this.coIndex);
        this.chValue = new Label("                     ");
        this.chValue.setFont(new Font("Monospaced", 0, 12));
        statsPanel.add(this.chValue);
        this.chCount = new Label("                     ");
        this.chCount.setFont(new Font("Monospaced", 0, 12));
        statsPanel.add(this.chCount);
    }

    private void addButtons(Panel buttonsPanel) {
        this.alphabetGroup = new CheckboxGroup();
        this.azButton = new Checkbox("a-z");
        this.azButton.setCheckboxGroup(this.alphabetGroup);
        this.azButton.addItemListener(this);
        buttonsPanel.add(this.azButton);
        this.AZButton = new Checkbox("A-Z");
        this.AZButton.setCheckboxGroup(this.alphabetGroup);
        this.AZButton.addItemListener(this);
        buttonsPanel.add(this.AZButton);
        this.azAZButton = new Checkbox("a-z & A-Z");
        this.azAZButton.setCheckboxGroup(this.alphabetGroup);
        this.azAZButton.addItemListener(this);
        buttonsPanel.add(this.azAZButton);
        this.azAZ09Button = new Checkbox("a-z & A-Z & 0-9");
        this.azAZ09Button.setCheckboxGroup(this.alphabetGroup);
        this.azAZ09Button.addItemListener(this);
        buttonsPanel.add(this.azAZ09Button);
        this.printableButton = new Checkbox("printable characters");
        this.printableButton.setCheckboxGroup(this.alphabetGroup);
        this.printableButton.addItemListener(this);
        buttonsPanel.add(this.printableButton);
        this.asciiButton = new Checkbox("All ASCII");
        this.asciiButton.setCheckboxGroup(this.alphabetGroup);
        this.asciiButton.setState(true);
        this.asciiButton.addItemListener(this);
        buttonsPanel.add(this.asciiButton);
    }

    public void itemStateChanged(ItemEvent evt) {
        if (this.azButton.getState()) {
            this.alphabetRange = 0;
        } else if (this.AZButton.getState()) {
            this.alphabetRange = 1;
        } else if (this.azAZButton.getState()) {
            this.alphabetRange = 2;
        } else if (this.azAZ09Button.getState()) {
            this.alphabetRange = 3;
        } else if (this.printableButton.getState()) {
            this.alphabetRange = 4;
        } else if (this.asciiButton.getState()) {
            this.alphabetRange = 5;
        }
        this.freqTable.setAlphabetRange(this.alphabetRange);
        this.stats.calcStatistics();
        this.histogram.redraw();
        this.count.setText("  Chars: " + this.stats.charCount);
        this.alphaCount.setText("  Alphabetics: " + this.stats.alphabeticsCount);
        this.coIndex.setText("  Coincidence Index: " + this.nf.format(this.stats.coincidenceIndex));
    }

    public void run() {
    }

    public String getReport() {
        return "";
    }

    public String toString() {
        return "TestAnalyzer";
    }
}

