/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import hcrypto.analyzer.Analyzer;
import hcrypto.analyzer.tool.FrequencyTable;
import hcrypto.analyzer.tool.IndexOfCoincidence;
import hcrypto.cipher.Alphabet;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class TextStatistics
implements Analyzer {
    public static final double KAPPA_R = 0.0385;
    public static final double KAPPA_P = 0.0667;
    public static final double[] englishFrequency = new double[]{5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 0.073, 0.009, 0.03, 0.044, 0.13, 0.028, 0.016, 0.035, 0.074, 0.002, 0.003, 0.035, 0.025, 0.078, 0.074, 0.027, 0.003, 0.077, 0.063, 0.093, 0.027, 0.013, 0.016, 0.005, 0.019, 0.001, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 0.073, 0.009, 0.03, 0.044, 0.13, 0.028, 0.016, 0.035, 0.074, 0.002, 0.003, 0.035, 0.025, 0.078, 0.074, 0.027, 0.003, 0.077, 0.063, 0.093, 0.027, 0.013, 0.016, 0.005, 0.019, 0.001, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4, 5.0E-4};
    public static final int digram_chars = 107199;
    public static final int[][] digram_data;
    private String text;
    private FrequencyTable freqTable;
    public int charCount = 0;
    public int alphabeticsCount = 0;
    public double coincidenceIndex = 0.0;
    private int[] histogram;

    static {
        int[][] nArrayArray = new int[27][];
        int[] nArray = new int[27];
        nArray[0] = 2;
        nArray[1] = 144;
        nArray[2] = 308;
        nArray[3] = 382;
        nArray[4] = 1;
        nArray[5] = 67;
        nArray[6] = 138;
        nArray[7] = 9;
        nArray[8] = 322;
        nArray[9] = 7;
        nArray[10] = 146;
        nArray[11] = 664;
        nArray[12] = 177;
        nArray[13] = 1576;
        nArray[14] = 1;
        nArray[15] = 100;
        nArray[17] = 802;
        nArray[18] = 683;
        nArray[19] = 785;
        nArray[20] = 87;
        nArray[21] = 233;
        nArray[22] = 57;
        nArray[23] = 14;
        nArray[24] = 319;
        nArray[25] = 12;
        nArray[26] = 50;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[27];
        nArray2[0] = 136;
        nArray2[1] = 14;
        nArray2[4] = 415;
        nArray2[8] = 78;
        nArray2[9] = 18;
        nArray2[11] = 98;
        nArray2[12] = 1;
        nArray2[14] = 240;
        nArray2[17] = 88;
        nArray2[18] = 15;
        nArray2[19] = 7;
        nArray2[20] = 256;
        nArray2[21] = 1;
        nArray2[22] = 1;
        nArray2[24] = 13;
        nArray2[26] = 36;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[27];
        nArray3[0] = 368;
        nArray3[2] = 13;
        nArray3[4] = 285;
        nArray3[7] = 412;
        nArray3[8] = 67;
        nArray3[10] = 178;
        nArray3[11] = 108;
        nArray3[13] = 1;
        nArray3[14] = 298;
        nArray3[16] = 1;
        nArray3[17] = 71;
        nArray3[18] = 7;
        nArray3[19] = 154;
        nArray3[20] = 34;
        nArray3[24] = 9;
        nArray3[26] = 47;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[27];
        nArray4[0] = 106;
        nArray4[1] = 1;
        nArray4[3] = 37;
        nArray4[4] = 375;
        nArray4[5] = 3;
        nArray4[6] = 19;
        nArray4[8] = 148;
        nArray4[9] = 1;
        nArray4[11] = 22;
        nArray4[12] = 1;
        nArray4[13] = 2;
        nArray4[14] = 137;
        nArray4[17] = 83;
        nArray4[18] = 95;
        nArray4[19] = 3;
        nArray4[20] = 52;
        nArray4[21] = 5;
        nArray4[22] = 2;
        nArray4[24] = 51;
        nArray4[26] = 2627;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[]{670, 8, 181, 767, 470, 103, 46, 15, 127, 1, 35, 332, 187, 799, 44, 90, 9, 1314, 630, 316, 8, 172, 106, 87, 189, 2, 4904};
        int[] nArray5 = new int[27];
        nArray5[0] = 145;
        nArray5[4] = 154;
        nArray5[5] = 86;
        nArray5[8] = 205;
        nArray5[11] = 69;
        nArray5[12] = 3;
        nArray5[14] = 429;
        nArray5[17] = 188;
        nArray5[18] = 4;
        nArray5[19] = 102;
        nArray5[20] = 62;
        nArray5[24] = 4;
        nArray5[26] = 110;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[27];
        nArray6[0] = 94;
        nArray6[1] = 1;
        nArray6[4] = 289;
        nArray6[6] = 19;
        nArray6[7] = 288;
        nArray6[8] = 96;
        nArray6[11] = 55;
        nArray6[12] = 1;
        nArray6[13] = 31;
        nArray6[14] = 135;
        nArray6[17] = 98;
        nArray6[18] = 42;
        nArray6[19] = 6;
        nArray6[20] = 57;
        nArray6[22] = 1;
        nArray6[24] = 2;
        nArray6[26] = 686;
        nArrayArray[6] = nArray6;
        int[] nArray7 = new int[27];
        nArray7[0] = 1164;
        nArray7[4] = 3155;
        nArray7[7] = 1;
        nArray7[8] = 824;
        nArray7[11] = 5;
        nArray7[12] = 1;
        nArray7[14] = 487;
        nArray7[15] = 2;
        nArray7[17] = 91;
        nArray7[18] = 8;
        nArray7[19] = 165;
        nArray7[20] = 75;
        nArray7[22] = 8;
        nArray7[24] = 32;
        nArray7[26] = 715;
        nArrayArray[7] = nArray7;
        int[] nArray8 = new int[27];
        nArray8[0] = 23;
        nArray8[1] = 7;
        nArray8[2] = 304;
        nArray8[3] = 260;
        nArray8[4] = 189;
        nArray8[5] = 56;
        nArray8[6] = 233;
        nArray8[8] = 1;
        nArray8[10] = 86;
        nArray8[11] = 324;
        nArray8[12] = 255;
        nArray8[13] = 1110;
        nArray8[14] = 88;
        nArray8[15] = 42;
        nArray8[16] = 2;
        nArray8[17] = 272;
        nArray8[18] = 484;
        nArray8[19] = 558;
        nArray8[20] = 5;
        nArray8[21] = 165;
        nArray8[23] = 15;
        nArray8[25] = 18;
        nArray8[26] = 4;
        nArrayArray[8] = nArray8;
        int[] nArray9 = new int[27];
        nArray9[0] = 2;
        nArray9[4] = 31;
        nArray9[8] = 9;
        nArray9[14] = 41;
        nArray9[20] = 56;
        nArrayArray[9] = nArray9;
        int[] nArray10 = new int[27];
        nArray10[0] = 2;
        nArray10[4] = 337;
        nArray10[8] = 127;
        nArray10[11] = 10;
        nArray10[12] = 1;
        nArray10[13] = 82;
        nArray10[14] = 3;
        nArray10[15] = 1;
        nArray10[18] = 50;
        nArray10[20] = 3;
        nArray10[24] = 8;
        nArray10[26] = 309;
        nArrayArray[10] = nArray10;
        int[] nArray11 = new int[27];
        nArray11[0] = 332;
        nArray11[1] = 4;
        nArray11[2] = 6;
        nArray11[3] = 289;
        nArray11[4] = 591;
        nArray11[5] = 59;
        nArray11[6] = 7;
        nArray11[8] = 390;
        nArray11[10] = 38;
        nArray11[11] = 546;
        nArray11[12] = 30;
        nArray11[13] = 1;
        nArray11[14] = 344;
        nArray11[15] = 34;
        nArray11[17] = 11;
        nArray11[18] = 121;
        nArray11[19] = 74;
        nArray11[20] = 81;
        nArray11[21] = 17;
        nArray11[22] = 19;
        nArray11[24] = 276;
        nArray11[26] = 630;
        nArrayArray[11] = nArray11;
        int[] nArray12 = new int[27];
        nArray12[0] = 394;
        nArray12[1] = 50;
        nArray12[4] = 530;
        nArray12[5] = 6;
        nArray12[8] = 165;
        nArray12[11] = 4;
        nArray12[12] = 28;
        nArray12[13] = 4;
        nArray12[14] = 289;
        nArray12[15] = 77;
        nArray12[18] = 53;
        nArray12[19] = 2;
        nArray12[20] = 85;
        nArray12[24] = 19;
        nArray12[26] = 454;
        nArrayArray[12] = nArray12;
        int[] nArray13 = new int[27];
        nArray13[0] = 100;
        nArray13[1] = 2;
        nArray13[2] = 98;
        nArray13[3] = 1213;
        nArray13[4] = 512;
        nArray13[5] = 5;
        nArray13[6] = 771;
        nArray13[7] = 5;
        nArray13[8] = 135;
        nArray13[9] = 8;
        nArray13[10] = 63;
        nArray13[11] = 80;
        nArray13[13] = 54;
        nArray13[14] = 349;
        nArray13[16] = 3;
        nArray13[17] = 2;
        nArray13[18] = 148;
        nArray13[19] = 378;
        nArray13[20] = 49;
        nArray13[21] = 3;
        nArray13[22] = 2;
        nArray13[23] = 2;
        nArray13[24] = 115;
        nArray13[26] = 1152;
        nArrayArray[13] = nArray13;
        int[] nArray14 = new int[27];
        nArray14[0] = 65;
        nArray14[1] = 67;
        nArray14[2] = 61;
        nArray14[3] = 119;
        nArray14[4] = 34;
        nArray14[5] = 80;
        nArray14[6] = 9;
        nArray14[7] = 1;
        nArray14[8] = 88;
        nArray14[9] = 3;
        nArray14[10] = 123;
        nArray14[11] = 218;
        nArray14[12] = 417;
        nArray14[13] = 598;
        nArray14[14] = 336;
        nArray14[15] = 138;
        nArray14[17] = 812;
        nArray14[18] = 195;
        nArray14[19] = 415;
        nArray14[20] = 1115;
        nArray14[21] = 136;
        nArray14[22] = 398;
        nArray14[23] = 2;
        nArray14[24] = 47;
        nArray14[25] = 5;
        nArray14[26] = 294;
        nArrayArray[14] = nArray14;
        int[] nArray15 = new int[27];
        nArray15[0] = 142;
        nArray15[2] = 1;
        nArray15[4] = 280;
        nArray15[5] = 1;
        nArray15[7] = 24;
        nArray15[8] = 97;
        nArray15[11] = 169;
        nArray15[14] = 149;
        nArray15[15] = 64;
        nArray15[17] = 110;
        nArray15[18] = 48;
        nArray15[19] = 40;
        nArray15[20] = 68;
        nArray15[22] = 3;
        nArray15[24] = 14;
        nArray15[26] = 127;
        nArrayArray[15] = nArray15;
        int[] nArray16 = new int[27];
        nArray16[20] = 66;
        nArrayArray[16] = nArray16;
        int[] nArray17 = new int[27];
        nArray17[0] = 289;
        nArray17[1] = 10;
        nArray17[2] = 22;
        nArray17[3] = 133;
        nArray17[4] = 1139;
        nArray17[5] = 13;
        nArray17[6] = 59;
        nArray17[7] = 21;
        nArray17[8] = 309;
        nArray17[10] = 53;
        nArray17[11] = 71;
        nArray17[12] = 65;
        nArray17[13] = 106;
        nArray17[14] = 504;
        nArray17[15] = 9;
        nArray17[17] = 69;
        nArray17[18] = 318;
        nArray17[19] = 190;
        nArray17[20] = 89;
        nArray17[21] = 22;
        nArray17[22] = 5;
        nArray17[24] = 145;
        nArray17[26] = 1483;
        nArrayArray[17] = nArray17;
        int[] nArray18 = new int[27];
        nArray18[0] = 196;
        nArray18[1] = 9;
        nArray18[2] = 47;
        nArray18[4] = 626;
        nArray18[6] = 1;
        nArray18[7] = 328;
        nArray18[8] = 214;
        nArray18[10] = 57;
        nArray18[11] = 48;
        nArray18[12] = 31;
        nArray18[13] = 16;
        nArray18[14] = 213;
        nArray18[15] = 107;
        nArray18[16] = 8;
        nArray18[18] = 168;
        nArray18[19] = 754;
        nArray18[20] = 175;
        nArray18[22] = 32;
        nArray18[24] = 34;
        nArray18[26] = 2228;
        nArrayArray[18] = nArray18;
        int[] nArray19 = new int[27];
        nArray19[0] = 259;
        nArray19[1] = 2;
        nArray19[2] = 31;
        nArray19[3] = 1;
        nArray19[4] = 583;
        nArray19[5] = 1;
        nArray19[6] = 2;
        nArray19[7] = 3774;
        nArray19[8] = 252;
        nArray19[11] = 75;
        nArray19[12] = 1;
        nArray19[13] = 2;
        nArray19[14] = 331;
        nArray19[17] = 187;
        nArray19[18] = 209;
        nArray19[19] = 154;
        nArray19[20] = 132;
        nArray19[22] = 84;
        nArray19[24] = 121;
        nArray19[25] = 1;
        nArray19[26] = 2343;
        nArrayArray[19] = nArray19;
        int[] nArray20 = new int[27];
        nArray20[0] = 45;
        nArray20[1] = 53;
        nArray20[2] = 114;
        nArray20[3] = 48;
        nArray20[4] = 71;
        nArray20[5] = 10;
        nArray20[6] = 148;
        nArray20[8] = 65;
        nArray20[11] = 247;
        nArray20[12] = 87;
        nArray20[13] = 278;
        nArray20[14] = 3;
        nArray20[15] = 49;
        nArray20[16] = 1;
        nArray20[17] = 402;
        nArray20[18] = 299;
        nArray20[19] = 492;
        nArray20[23] = 1;
        nArray20[24] = 7;
        nArray20[25] = 3;
        nArray20[26] = 255;
        nArrayArray[20] = nArray20;
        int[] nArray21 = new int[27];
        nArray21[0] = 27;
        nArray21[4] = 683;
        nArray21[8] = 109;
        nArray21[14] = 33;
        nArray21[20] = 1;
        nArray21[24] = 11;
        nArrayArray[21] = nArray21;
        int[] nArray22 = new int[27];
        nArray22[0] = 595;
        nArray22[1] = 3;
        nArray22[3] = 6;
        nArray22[4] = 285;
        nArray22[7] = 472;
        nArray22[8] = 374;
        nArray22[10] = 1;
        nArray22[11] = 12;
        nArray22[13] = 103;
        nArray22[14] = 264;
        nArray22[17] = 35;
        nArray22[18] = 21;
        nArray22[19] = 4;
        nArray22[20] = 2;
        nArray22[26] = 326;
        nArrayArray[22] = nArray22;
        int[] nArray23 = new int[27];
        nArray23[0] = 17;
        nArray23[2] = 9;
        nArray23[4] = 9;
        nArray23[8] = 10;
        nArray23[14] = 1;
        nArray23[15] = 22;
        nArray23[19] = 23;
        nArray23[20] = 8;
        nArray23[26] = 21;
        nArrayArray[23] = nArray23;
        int[] nArray24 = new int[27];
        nArray24[0] = 11;
        nArray24[1] = 10;
        nArray24[4] = 152;
        nArray24[6] = 1;
        nArray24[7] = 1;
        nArray24[8] = 32;
        nArray24[11] = 7;
        nArray24[12] = 1;
        nArray24[14] = 339;
        nArray24[15] = 16;
        nArray24[18] = 81;
        nArray24[19] = 2;
        nArray24[20] = 1;
        nArray24[22] = 2;
        nArray24[26] = 1171;
        nArrayArray[24] = nArray24;
        int[] nArray25 = new int[27];
        nArray25[0] = 3;
        nArray25[4] = 26;
        nArray25[8] = 2;
        nArray25[11] = 4;
        nArray25[14] = 2;
        nArray25[18] = 3;
        nArray25[24] = 3;
        nArray25[25] = 9;
        nArray25[26] = 2;
        nArrayArray[25] = nArray25;
        int[] nArray26 = new int[27];
        nArray26[0] = 1882;
        nArray26[1] = 1033;
        nArray26[2] = 864;
        nArray26[3] = 515;
        nArray26[4] = 423;
        nArray26[5] = 1059;
        nArray26[6] = 453;
        nArray26[7] = 1388;
        nArray26[8] = 237;
        nArray26[9] = 93;
        nArray26[10] = 152;
        nArray26[11] = 717;
        nArray26[12] = 876;
        nArray26[13] = 478;
        nArray26[14] = 721;
        nArray26[15] = 588;
        nArray26[16] = 42;
        nArray26[17] = 494;
        nArray26[18] = 1596;
        nArray26[19] = 3912;
        nArray26[20] = 134;
        nArray26[21] = 116;
        nArray26[22] = 1787;
        nArray26[24] = 436;
        nArray26[25] = 2;
        nArrayArray[26] = nArray26;
        digram_data = nArrayArray;
    }

    public TextStatistics() {
    }

    public TextStatistics(String text) {
        this.setup(text);
    }

    public TextStatistics(String text, boolean stripString) {
        if (stripString) {
            this.setup(this.stripString(text));
        } else {
            this.setup(text);
        }
    }

    public static double getEnglishFrequency(char ch) {
        ch = Character.toLowerCase(ch);
        return englishFrequency[ch];
    }

    public static double chiSquare(int[] expected, int[] observed) {
        double sum = 0.0;
        int k = 0;
        while (k < expected.length) {
            sum += (double)((expected[k] - observed[k]) * (expected[k] - observed[k]) / expected[k]);
            ++k;
        }
        return sum;
    }

    public static int getIndexOfMinimum(double[] a) {
        int min = 0;
        double minValue = a[0];
        int k = 0;
        while (k < a.length) {
            if (a[k] < minValue) {
                minValue = a[k];
                min = k;
            }
            ++k;
        }
        return min;
    }

    public static String removeNonAlphabetics(String s, Alphabet a) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            char ch = s.charAt(k);
            if (a.isInAlphabet(ch)) {
                sb.append(ch);
            }
            ++k;
        }
        return sb.toString();
    }

    public static String removeDuplicates(String s) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (sb.toString().indexOf(word) != -1) continue;
            sb.append(word);
            sb.append(" ");
        }
        return sb.toString();
    }

    public void setup(String text) {
        this.text = text;
        this.freqTable = new FrequencyTable(text, 0);
        this.calcStatistics();
    }

    public void run() {
    }

    public String getReport() {
        return this.toString();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        return "Statistics \nNumber of characters \t" + this.charCount + "\n" + "Alphabetic characters \t" + this.alphabeticsCount + "\n" + "Coincidence Index \t" + nf.format(this.coincidenceIndex) + "\n";
    }

    public void calcStatistics() {
        this.charCount = this.freqTable.getCharCount();
        this.alphabeticsCount = this.freqTable.getAlphabeticsCount();
        IndexOfCoincidence ioc = new IndexOfCoincidence();
        ioc.setup(this.text);
        this.coincidenceIndex = ioc.getIOC();
    }

    public double getCoincidenceIndex() {
        return this.coincidenceIndex;
    }

    public FrequencyTable getFrequencyTable() {
        return this.freqTable;
    }

    private String stripString(String s) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            if (Character.isLetter(s.charAt(k))) {
                sb.append(s.charAt(k));
            }
            ++k;
        }
        return sb.toString();
    }

    public int getCharCount() {
        return this.freqTable.getCharCount();
    }

    public int getFrequency(char inChar) {
        return this.freqTable.getCount(inChar);
    }

    public String getKHighestFreqChar(int k) {
        return this.freqTable.getKHighestFreqChar(k);
    }

    public String getFrequencyReport() {
        return this.freqTable.getReport();
    }
}

