/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import hcrypto.analyzer.tool.Dictionary;
import hcrypto.analyzer.tool.PatternDictionary;
import hcrypto.cipher.Alphabet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;

public final class TextUtilities {
    public static final int EVAL_DICT = 0;
    public static final int SEED_DICT = 1;
    public static final int N_SHUFFLES = 20;
    private static PatternDictionary dict = new PatternDictionary(4);
    private static PatternDictionary eval_dict;
    private static Dictionary big_eval_dict;

    private TextUtilities() {
    }

    public static Dictionary getDictionary() {
        try {
            try {
                throw new Exception("getDictionary() is no longer used. Use getPatternDictionary()");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public static PatternDictionary getPatternDictionary() {
        return dict;
    }

    public static PatternDictionary getPatternDictionary(int which) {
        if (which == 0) {
            return eval_dict;
        }
        return dict;
    }

    public static boolean isAWord(Dictionary dict, String word) {
        return dict.contains(word);
    }

    public static int countTokens(String text) {
        StringTokenizer st = new StringTokenizer(text);
        return st.countTokens();
    }

    public static int countWordsForPattern(String pattern) {
        return dict.countWordsForPattern(pattern);
    }

    public static String removeDuplicates(String s) {
        StringBuffer sb = new StringBuffer(" ");
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (sb.toString().indexOf(" " + word + " ") != -1) continue;
            sb.append(word);
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getUnusedLetters(String s) {
        String unused = new String("");
        char ch = 'a';
        while (ch <= 'z') {
            if (s.indexOf(ch) == -1) {
                unused = String.valueOf(unused) + ch;
            }
            ch = (char)(ch + 1);
        }
        return unused;
    }

    public static int countWords(Dictionary eval_dict, String text) {
        if (text == null) {
            return 0;
        }
        if (text.equals("")) {
            return 0;
        }
        StringTokenizer st = new StringTokenizer(text);
        int count = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!eval_dict.contains(s)) continue;
            ++count;
        }
        return count;
    }

    public static String remove(String s, char ch) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) != ch) {
                sb.append(s.charAt(k));
            }
            ++k;
        }
        return sb.toString();
    }

    public static void shuffle(StringBuffer sb) {
        sb = new StringBuffer(TextUtilities.shuffle(sb.toString()));
    }

    public static String shuffle(String s) {
        StringBuffer sb = new StringBuffer(s);
        int k = 0;
        while (k < 20) {
            int a = (int)(Math.random() * (double)sb.length());
            int b = (int)(Math.random() * (double)sb.length());
            char ch = sb.charAt(a);
            sb.setCharAt(a, sb.charAt(b));
            sb.setCharAt(b, ch);
            ++k;
        }
        return sb.toString();
    }

    public static void shuffle(int[] arr) {
        int k = 0;
        while (k < arr.length - 1) {
            int m = (int)(Math.random() * (double)(arr.length - 1));
            int temp = arr[k];
            arr[k] = arr[m];
            arr[m] = temp;
            ++k;
        }
    }

    public static String removeWhiteSpace(String s) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            char ch = s.charAt(k);
            if (ch != '\t' && ch != ' ' && ch != '\n') {
                sb.append(ch);
            }
            ++k;
        }
        return sb.toString();
    }

    public static String cleanString(String s) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            char ch = s.charAt(k);
            if (Character.isLetter(ch) || Character.isWhitespace(ch)) {
                sb.append(Character.toLowerCase(ch));
            }
            ++k;
        }
        return sb.toString();
    }

    public static String removeNonAlphabetics(String s, Alphabet a) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            char ch = s.charAt(k);
            if (a.isInAlphabet(ch)) {
                sb.append(ch);
            }
            ++k;
        }
        return sb.toString();
    }

    public static String makePattern(String s) {
        String word = s.toLowerCase();
        String patternLetters = "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int p = 0;
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < Math.min(word.length(), patternLetters.length())) {
            char ch = word.charAt(k);
            int index = word.substring(0, k).indexOf(ch);
            if (index == -1) {
                sb.append(patternLetters.charAt(p));
                ++p;
            } else {
                sb.append(sb.charAt(index));
            }
            ++k;
        }
        return sb.toString();
    }

    public static double percentWords(String s1, String s2) {
        double matches = 0.0;
        double nWords = 0.0;
        StringTokenizer st1 = new StringTokenizer(s1);
        StringTokenizer st2 = new StringTokenizer(s2);
        while (st1.hasMoreTokens()) {
            nWords += 1.0;
            if (!st1.nextToken().equals(st2.nextToken())) continue;
            matches += 1.0;
        }
        return 100.0 * matches / nWords;
    }

    public static String markWords(Dictionary eval_dict, String s) {
        StringTokenizer st = new StringTokenizer(s);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (TextUtilities.isAWord(eval_dict, token)) {
                sb.append(String.valueOf(token.toUpperCase()) + " ");
                continue;
            }
            sb.append(String.valueOf(token.toLowerCase()) + " ");
        }
        return sb.toString();
    }

    public static int countInCorrectChars(String solution, String decrypt) {
        int bound = 0;
        decrypt = decrypt.toLowerCase().trim();
        if ((solution = solution.toLowerCase().trim()).length() != decrypt.length()) {
            bound = Math.min(solution.length(), decrypt.length());
        }
        int count = 0;
        String wrongchars = new String();
        int k = 0;
        while (k < bound) {
            char ch = decrypt.charAt(k);
            if (ch != solution.charAt(k)) {
                ++count;
                wrongchars = String.valueOf(wrongchars) + ch;
            }
            ++k;
        }
        return count;
    }

    public static String randomizeSub(String inText, Alphabet alph, int[] substitution, int maxChanged) {
        int temp;
        int j = 0;
        while (j < maxChanged) {
            int k = (int)(Math.random() * (double)maxChanged);
            temp = substitution[j];
            substitution[j] = substitution[k];
            substitution[k] = temp;
            ++j;
        }
        StringBuffer outText = new StringBuffer();
        try {
            j = 0;
            while (j < inText.length()) {
                temp = alph.charToInt(inText.charAt(j));
                outText.append(alph.intToChar(substitution[temp]));
                ++j;
            }
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
        }
        return outText.toString();
    }

    public static String singleSpaces(String inText) {
        StringBuffer outText = new StringBuffer();
        char lastChar = inText.charAt(0);
        outText.append(lastChar);
        int j = 1;
        while (j < inText.length() - 1) {
            char thisChar = inText.charAt(j);
            if (thisChar != ' ' || lastChar != ' ') {
                outText.append(thisChar);
                lastChar = thisChar;
            }
            ++j;
        }
        return outText.toString();
    }

    public static void writeCiphertextFiles(String sourceFile, String outRootName, int minMessSize, int gapMessSize, int maxMessSize, int numEachSize, Alphabet alph) {
        try {
            StringBuffer pText = new StringBuffer();
            String line = null;
            int len = 0;
            int pos = 0;
            int chNum = 0;
            boolean done = false;
            boolean messDone = false;
            File outDir = new File(String.valueOf(outRootName) + "dir");
            if (outDir.mkdir()) {
                System.out.println("Directory " + outRootName + "dir created");
            } else {
                System.out.println("Directory " + outRootName + "dir either already exists or failed");
            }
            BufferedReader inStream = new BufferedReader(new FileReader(sourceFile));
            System.out.println("sourceFile= " + sourceFile + " opened");
            int curMessSize = minMessSize;
            int curMessNum = 0;
            int lineCount = (int)(Math.random() * 50.0);
            int[] substitution = new int[alph.getSize()];
            int j = 0;
            while (j < alph.getSize()) {
                substitution[j] = j;
                ++j;
            }
            while (!done) {
                line = inStream.readLine();
                if (line == null) {
                    inStream.close();
                    inStream = new BufferedReader(new FileReader(sourceFile));
                    System.out.println("sourceFile= " + sourceFile + " opened");
                    line = inStream.readLine();
                    if (line == null) {
                        throw new Exception("Bad source file in TextUtilities.writeCiphertextFiles()");
                    }
                }
                if ((len = line.length()) > 0 && --lineCount < 0) {
                    line = line.toLowerCase();
                    pos = 0;
                    while (pos < len && !messDone) {
                        char ch = line.charAt(pos);
                        if (alph.isInAlphabet(ch)) {
                            ++chNum;
                            pText.append(ch);
                        } else if (ch != '\'') {
                            pText.append(' ');
                        }
                        if (chNum >= curMessSize && (ch == ' ' || ch == '\n')) {
                            messDone = true;
                            File outFile = new File(outDir, String.valueOf(outRootName) + curMessSize + "_" + curMessNum + ".txt");
                            FileWriter outStream = new FileWriter(outFile);
                            String pString = TextUtilities.singleSpaces(pText.toString());
                            String cText = TextUtilities.randomizeSub(pString, alph, substitution, 26);
                            outStream.write(cText);
                            outStream.write("\n$$$\n");
                            outStream.write(pString);
                            outStream.close();
                        }
                        if (++pos != len || messDone) continue;
                        pText.append(' ');
                    }
                }
                if (messDone) {
                    messDone = false;
                    pText = new StringBuffer();
                    chNum = 0;
                    lineCount = (int)(Math.random() * 50.0);
                    if (++curMessNum >= numEachSize) {
                        curMessNum = 0;
                        curMessSize += gapMessSize;
                    }
                    if (curMessSize > maxMessSize) {
                        done = true;
                    }
                }
                line = inStream.readLine();
            }
            System.out.println("Finished writing Files.");
            inStream.close();
        }
        catch (Exception exc) {
            System.out.println("In TextUtilities.writeCiphertextFiles() - " + exc.toString());
            exc.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            char[] arr = new char[]{'a', 'z', ' ', ' '};
            Alphabet alph = new Alphabet(arr);
            TextUtilities.writeCiphertextFiles("oliver.txt", "oliver", 25, 25, 125, 20, alph);
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
        }
    }
}

