/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.analyzer.tool;

import hcrypto.analyzer.tool.PatternDictionary;
import hcrypto.analyzer.tool.TextUtilities;

public class Token
implements Comparable {
    private String token;
    private String pattern;
    private int score;
    private String[] patternSet;
    private PatternDictionary eval_dict;

    public Token(String s) {
        this.token = new String(s);
        this.pattern = new String(TextUtilities.makePattern(s));
        this.score = this.computeScore(this.pattern);
    }

    public Token(String s, PatternDictionary dict) {
        this.eval_dict = dict;
        this.token = new String(s);
        this.pattern = new String(PatternDictionary.makePattern(s));
        this.score = this.computeScore(this.pattern);
        this.patternSet = dict.getPatternWordArray(this.token);
    }

    public String getToken() {
        return this.token;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String[] getPatternSet() {
        return this.patternSet;
    }

    public int getScore() {
        return this.score;
    }

    private int computeScore(String s) {
        int count = this.eval_dict.countWordsForPattern(s);
        if (count == 0) {
            return Integer.MAX_VALUE;
        }
        return count;
    }

    public int compareTo(Object o) {
        Token t = (Token)o;
        if (this.score < t.score) {
            return -1;
        }
        if (this.score > t.score) {
            return 1;
        }
        return 0;
    }
}

