/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.cipher;

import hcrypto.cipher.AlphabetFactory;

public class Alphabet {
    private char[] ranges;
    protected int rangeId;
    private int size;

    public Alphabet() {
        this.ranges = new char[2];
        this.ranges[0] = 97;
        this.ranges[1] = 122;
        this.rangeId = 0;
        this.size = 26;
    }

    public Alphabet(char[] ranges) throws Exception {
        this.ranges = ranges;
        this.size = 0;
        if (ranges.length % 2 == 1) {
            throw new Exception("Invalid array of chars in an Alphabet constructor");
        }
        int k = 0;
        while (k < ranges.length) {
            if (ranges[k] <= ranges[k + 1]) {
                this.size += ranges[k + 1] - ranges[k] + 1;
            } else {
                throw new Exception("Invalid array of chars in an Alphabet constructor");
            }
            k += 2;
        }
    }

    protected Alphabet(String rangeStr) throws Exception {
        char[] theRanges = new char[rangeStr.length()];
        int k = 0;
        while (k < theRanges.length) {
            theRanges[k] = rangeStr.charAt(k);
            ++k;
        }
        this.ranges = theRanges;
        if (this.ranges.length % 2 == 1) {
            throw new Exception("Invalid array of chars in an Alphabet constructor");
        }
        this.size = 0;
        k = 0;
        while (k < this.ranges.length) {
            if (this.ranges[k] <= this.ranges[k + 1]) {
                this.size += this.ranges[k + 1] - this.ranges[k] + 1;
            } else {
                throw new Exception("Invalid array of chars in an Alphabet constructor");
            }
            k += 2;
        }
    }

    public Alphabet(Character.UnicodeBlock[] blocks) throws Exception {
        int k = 0;
        StringBuffer sb = new StringBuffer();
        char ch = '\u0000';
        boolean chInAlph = false;
        while (ch < '\uffff') {
            Character.UnicodeBlock aBlock = Character.UnicodeBlock.of(ch);
            if (aBlock != null) {
                k = 0;
                while (k < blocks.length) {
                    if (aBlock.equals(blocks[k])) {
                        chInAlph = true;
                    }
                    ++k;
                }
            }
            if (!chInAlph) {
                ch = (char)(ch + '\u0001');
                continue;
            }
            sb.append(ch);
            while (chInAlph && ch < '\uffff') {
                ch = (char)(ch + '\u0001');
                chInAlph = false;
                aBlock = Character.UnicodeBlock.of(ch);
                if (aBlock == null) continue;
                k = 0;
                while (k < blocks.length) {
                    if (aBlock.equals(blocks[k])) {
                        chInAlph = true;
                    }
                    ++k;
                }
            }
            sb.append((char)(ch - '\u0001'));
        }
        String rangeStr = sb.toString();
        char[] theRanges = new char[rangeStr.length()];
        k = 0;
        while (k < theRanges.length) {
            theRanges[k] = rangeStr.charAt(k);
            ++k;
        }
        this.ranges = theRanges;
        if (this.ranges.length % 2 == 1) {
            throw new Exception("Invalid array of chars in an Alphabet constructor");
        }
        this.size = 0;
        k = 0;
        while (k < this.ranges.length) {
            if (this.ranges[k] <= this.ranges[k + 1]) {
                this.size += this.ranges[k + 1] - this.ranges[k] + 1;
            } else {
                throw new Exception("Invalid array of chars in an Alphabet constructor");
            }
            k += 2;
        }
    }

    public Alphabet(char[] ranges, int rangeId) throws Exception {
        this.ranges = ranges;
        if (rangeId < 0 || rangeId > 8) {
            throw new Exception("Invalid alphabet range descriptor: " + rangeId);
        }
        this.rangeId = rangeId;
        this.size = 0;
        int k = 0;
        while (k < ranges.length) {
            if (ranges[k] <= ranges[k + 1]) {
                this.size += ranges[k + 1] - ranges[k] + 1;
            } else {
                throw new Exception("Invalid array of chars in an Alphabet constructor");
            }
            k += 2;
        }
    }

    public Alphabet(char[] ranges, String rangeDesc) throws Exception {
        this.ranges = ranges;
        this.rangeId = AlphabetFactory.getRangeId(rangeDesc);
        this.size = 0;
        int k = 0;
        while (k < ranges.length) {
            if (ranges[k] <= ranges[k + 1]) {
                this.size += ranges[k + 1] - ranges[k] + 1;
            } else {
                throw new Exception("Invalid array of chars in an Alphabet constructor");
            }
            k += 2;
        }
    }

    public int getRangeId() {
        return this.rangeId;
    }

    public String getRangeDesc() throws Exception {
        return AlphabetFactory.getDesc(this.rangeId);
    }

    public int getSize() {
        return this.size;
    }

    public int charToInt(char ch) throws Exception {
        if (!this.isInAlphabet(ch)) {
            throw new Exception("Character not in selected alphabet " + ch);
        }
        int counter = 0;
        int k = 0;
        while (k < this.ranges.length) {
            if (ch < this.ranges[k] || ch > this.ranges[k + 1]) {
                counter += this.ranges[k + 1] - this.ranges[k] + 1;
            } else {
                return counter + (ch - this.ranges[k]);
            }
            k += 2;
        }
        return -1;
    }

    public char intToChar(int n) throws Exception {
        if (n < 0 || n > this.size - 1) {
            throw new Exception("There are not " + n + " characters in the alphabet.");
        }
        int counter = n;
        int k = 0;
        while (k < this.ranges.length) {
            if (counter > this.ranges[k + 1] - this.ranges[k]) {
                counter -= this.ranges[k + 1] - this.ranges[k] + 1;
            } else {
                return (char)(this.ranges[k] + counter);
            }
            k += 2;
        }
        return this.ranges[0];
    }

    public boolean isInAlphabet(char ch) {
        int k = 0;
        while (k < this.ranges.length) {
            if (ch >= this.ranges[k] && ch <= this.ranges[k + 1]) {
                return true;
            }
            k += 2;
        }
        return false;
    }

    public boolean equals(Object alph2) {
        Alphabet alph = (Alphabet)alph2;
        if (this.ranges.length != alph.ranges.length) {
            return false;
        }
        int k = 0;
        while (k < this.ranges.length) {
            if (this.ranges[k] != alph.ranges[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    protected String getPadding(int n) throws Exception {
        char ch = this.intToChar(n);
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < n) {
            sb.append(ch);
            ++k;
        }
        return sb.toString();
    }

    protected String removePadding(String s, int blocksize) throws Exception {
        int num = s.length() - this.charToInt(s.charAt(s.length() - 1));
        if (num >= 0) {
            return s.substring(0, num);
        }
        return s;
    }

    public String strip(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        int k = 0;
        while (k < len) {
            if (this.isInAlphabet(str.charAt(k))) {
                sb.append(str.charAt(k));
            }
            ++k;
        }
        return sb.toString();
    }

    public static String removeDuplicateChars(String str) {
        StringBuffer retStr = new StringBuffer();
        boolean inBuff = false;
        int j = 0;
        while (j < str.length()) {
            char ch = str.charAt(j);
            inBuff = false;
            int k = 0;
            while (k < retStr.length()) {
                if (retStr.charAt(k) == ch) {
                    inBuff = true;
                }
                ++k;
            }
            if (!inBuff) {
                retStr.append(ch);
            }
            ++j;
        }
        return retStr.toString();
    }

    public String intArrayToString(int[] arr) {
        try {
            int len = arr.length;
            StringBuffer sb = new StringBuffer(len);
            int k = 0;
            while (k < len) {
                sb.append(this.intToChar(arr[k]));
                ++k;
            }
            return sb.toString();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            return "error";
        }
    }

    public void createPermutation(String str, int[] permArr) {
        try {
            str = this.strip(str);
            str = Alphabet.removeDuplicateChars(str);
            int k = 0;
            while (k < str.length()) {
                permArr[k] = this.charToInt(str.charAt(k));
                ++k;
            }
            boolean inArray = false;
            int nextIndex = str.length();
            int m = 0;
            while (m < permArr.length) {
                inArray = false;
                int n = 0;
                while (n < nextIndex) {
                    if (permArr[n] == m) {
                        inArray = true;
                        break;
                    }
                    ++n;
                }
                if (!inArray) {
                    permArr[nextIndex++] = m;
                }
                ++m;
            }
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
        }
    }

    public static int[] permShift(int[] permIn, int shift) {
        if (permIn == null) {
            return permIn;
        }
        int permSize = permIn.length;
        int[] permOut = new int[permSize];
        int m = 0;
        while (m < permSize) {
            permOut[m] = (permIn[m] + shift) % permSize;
            ++m;
        }
        return permOut;
    }

    public static int[] shiftPerm(int shift, int[] permIn) {
        if (permIn == null) {
            return permIn;
        }
        int permSize = permIn.length;
        int[] permOut = new int[permSize];
        int m = 0;
        while (m < permSize) {
            permOut[m] = permIn[(m + shift) % permSize];
            ++m;
        }
        return permOut;
    }

    public String normedShiftString(String shStr) {
        block5: {
            if (shStr != null) break block5;
            return "error";
        }
        try {
            StringBuffer sb = new StringBuffer();
            int m = 0;
            while (m < shStr.length()) {
                if (this.isInAlphabet(shStr.charAt(m))) {
                    int num = this.charToInt(shStr.charAt(m)) - this.charToInt(shStr.charAt(0));
                    num = (this.size + num) % this.size;
                    sb.append(this.intToChar(num));
                }
                ++m;
            }
            return sb.toString();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            return "error";
        }
    }

    public String eAlbNormedPermString(String permStr, String shStr) {
        try {
            int[] permIn = new int[this.size];
            this.createPermutation(permStr, permIn);
            int shift = this.charToInt(shStr.charAt(0));
            int[] permOut = Alphabet.permShift(permIn, shift);
            String strOut = this.intArrayToString(permOut);
            return strOut;
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            return "error";
        }
    }

    public String dAlbNormedPermString(String shStr, String permStr) {
        try {
            int[] permIn = new int[this.size];
            this.createPermutation(permStr, permIn);
            int shift = this.charToInt(shStr.charAt(0));
            int[] permOut = Alphabet.shiftPerm(shift, permIn);
            String strOut = this.intArrayToString(permOut);
            return strOut;
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            return "error";
        }
    }

    public static void main(String[] args) throws Exception {
        Alphabet myAlpha = AlphabetFactory.getInstance(0);
        System.out.println("size of az = " + myAlpha.getSize());
        System.out.println("charToInt('y') = " + myAlpha.charToInt('y'));
        System.out.println("intToChar(23) = " + myAlpha.intToChar(23) + "\n");
        char[] myRanges = new char[]{'A', 'Z', 'a', 'z'};
        myAlpha = new Alphabet(myRanges);
        System.out.println("size of AZaz = " + myAlpha.getSize());
        System.out.println("charToInt('Y') = " + myAlpha.charToInt('Y'));
        System.out.println("charToInt('y') = " + myAlpha.charToInt('y'));
        System.out.println("intToChar(23) = " + myAlpha.intToChar(23));
        System.out.println("intToChar(51) = " + myAlpha.intToChar(51) + "\n");
        String alphStr = "Az";
        myAlpha = new Alphabet(alphStr);
        System.out.println("size of Az = " + myAlpha.getSize());
        System.out.println("charToInt('Y') = " + myAlpha.charToInt('Y'));
        System.out.println("charToInt('y') = " + myAlpha.charToInt('y'));
        System.out.println("intToChar(23) = " + myAlpha.intToChar(23));
        System.out.println("intToChar(51) = " + myAlpha.intToChar(51));
        Character.UnicodeBlock[] theBlocks = new Character.UnicodeBlock[]{Character.UnicodeBlock.GREEK, Character.UnicodeBlock.BENGALI};
        myAlpha = new Alphabet(theBlocks);
        System.out.println("size of GREEK + BENGALI = " + myAlpha.getSize());
        System.out.println("intToChar(0) has int value = " + myAlpha.intToChar(0));
        System.out.println("intToChar(size - 1) has int value = " + myAlpha.intToChar(myAlpha.getSize() - 1));
        if (Character.UnicodeBlock.of('\ufffe') == null) {
            System.out.println("\nCharacter.UnicodeBlock.of(\\uFFFE) == null");
        } else {
            System.out.println("Character.UnicodeBlock.of(\\uFFFE).toString()= " + Character.UnicodeBlock.of('\ufffe').toString());
        }
        if (Character.UnicodeBlock.of('\uffff') == null) {
            System.out.println("\nCharacter.UnicodeBlock.of(\\uFFFF) == null");
        } else {
            System.out.println("Character.UnicodeBlock.of(\\uFFFF).toString()= " + Character.UnicodeBlock.of('\uffff').toString());
        }
        char[] ranges1 = new char[]{'A', 'Z'};
        Alphabet alph1 = new Alphabet(ranges1);
        Alphabet alph2 = new Alphabet(ranges1);
        char[] ranges3 = new char[]{'a', 'z'};
        Alphabet alph3 = new Alphabet(ranges3);
        char[] ranges4 = new char[]{'A', 'Z', 'a', 'z'};
        Alphabet alph4 = new Alphabet(ranges4);
        if (alph1.equals(alph2)) {
            System.out.println("alph1 equals alph2");
        } else {
            System.out.println("alph1 does not equal alph2");
        }
        if (alph1.equals(alph3)) {
            System.out.println("alph1 equals alph3");
        } else {
            System.out.println("alph1 does not equal alph3");
        }
        if (alph1.equals(alph4)) {
            System.out.println("alph1 equals alph4");
        } else {
            System.out.println("alph1 does not equal alph4");
        }
    }
}

