/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.cipher;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.UnicodeRanges;
import java.util.StringTokenizer;

public class AlphabetFactory {
    public static final int MAX_ALPH_NUM = 8;
    public static final int MAX_CHARS = 128;
    public static final int ALPH_az = 0;
    public static final int ALPH_AZ = 1;
    public static final int ALPH_azAZ = 2;
    public static final int ALPH_azAZ09 = 3;
    public static final int ALPH_printable = 4;
    public static final int ALPH_ascii = 5;
    public static final int ALPH_cryptogram = 6;
    public static final int ALPH_unicode = 7;
    public static final int ALPH_hebrew = 8;

    public static Alphabet getInstance(char[] ranges) throws Exception {
        return new Alphabet(ranges);
    }

    public static Alphabet getInstance(Character.UnicodeBlock[] blocks) throws Exception {
        return new Alphabet(AlphabetFactory.getRanges(blocks), 7);
    }

    public static Alphabet getInstance(int rangeId) throws Exception {
        return new Alphabet(AlphabetFactory.getRanges(rangeId), rangeId);
    }

    public static Alphabet getInstance(String alphaDesc) throws Exception {
        return new Alphabet(AlphabetFactory.getRanges(alphaDesc));
    }

    public static char getRangeLow(String alphDesc) throws Exception {
        if (alphDesc.equals("az")) {
            return 'a';
        }
        if (alphDesc.equals("AZ")) {
            return 'A';
        }
        if (alphDesc.equals("09")) {
            return '0';
        }
        if (alphDesc.equals("printable")) {
            return ' ';
        }
        if (alphDesc.equals("ascii")) {
            return '\u0000';
        }
        if (alphDesc.equals("unicode")) {
            return '\u0000';
        }
        if (alphDesc.length() == 2) {
            return alphDesc.charAt(0);
        }
        throw new Exception("AlphabetFactory.getRangeLow(): Illegal alphabet descriptor:" + alphDesc);
    }

    public static char getRangeHigh(String alphDesc) throws Exception {
        if (alphDesc.equals("az")) {
            return 'z';
        }
        if (alphDesc.equals("AZ")) {
            return 'Z';
        }
        if (alphDesc.equals("09")) {
            return '9';
        }
        if (alphDesc.equals("printable")) {
            return '~';
        }
        if (alphDesc.equals("ascii")) {
            return '\u007f';
        }
        if (alphDesc.equals("unicode")) {
            return '\u007f';
        }
        if (alphDesc.length() == 2) {
            return alphDesc.charAt(1);
        }
        throw new Exception("AlphabetFactory.getRangeHigh(): Illegal alphabet descriptor:" + alphDesc);
    }

    public static char[] getRanges(String alphaDesc) {
        StringTokenizer st = new StringTokenizer(alphaDesc, "+");
        char[] ranges = new char[st.countTokens() * 2];
        try {
            int k = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("UnicodeBlock")) {
                    ranges[k++] = UnicodeRanges.getRangeLow(token);
                    ranges[k++] = UnicodeRanges.getRangeHigh(token);
                    continue;
                }
                if (token.startsWith("Range")) {
                    String spec = token.substring(token.indexOf(46) + 1);
                    ranges[k++] = AlphabetFactory.getRangeLow(token.substring(token.indexOf(46) + 1));
                    ranges[k++] = AlphabetFactory.getRangeHigh(token.substring(token.indexOf(46) + 1));
                    continue;
                }
                ranges[k++] = AlphabetFactory.getRangeLow(token);
                ranges[k++] = AlphabetFactory.getRangeHigh(token);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ranges;
    }

    public static char[] getRanges(Character.UnicodeBlock[] blocks) {
        char[] ranges = new char[blocks.length * 2];
        int k = 0;
        while (k < blocks.length) {
            ranges[2 * k] = UnicodeRanges.getRangeLow(blocks[k]);
            ranges[2 * k + 1] = UnicodeRanges.getRangeHigh(blocks[k]);
            ++k;
        }
        return ranges;
    }

    public static char[] getRanges(int id) {
        switch (id) {
            case 0: {
                char[] ranges = new char[]{'a', 'z'};
                return ranges;
            }
            case 1: {
                char[] ranges = new char[]{'A', 'Z'};
                return ranges;
            }
            case 2: {
                char[] ranges = new char[]{'A', 'Z', 'a', 'z'};
                return ranges;
            }
            case 3: {
                char[] ranges = new char[]{'0', '9', 'A', 'Z', 'a', 'z'};
                return ranges;
            }
            case 4: {
                char[] ranges = new char[]{' ', '~'};
                return ranges;
            }
            case 5: {
                char[] ranges = new char[]{'\u0000', '\u007f'};
                return ranges;
            }
            case 6: {
                char[] ranges = new char[]{' ', ' ', 'a', 'z'};
                return ranges;
            }
            case 7: {
                char[] ranges = new char[]{'\u0000', '\u007f'};
                return ranges;
            }
            case 8: {
                char[] ranges = new char[]{'\u0590', '\u05ff'};
                return ranges;
            }
        }
        char[] ranges = new char[]{'a', 'z'};
        return ranges;
    }

    public static String getDesc(int num) {
        switch (num) {
            case 0: {
                return "az";
            }
            case 1: {
                return "AZ";
            }
            case 2: {
                return "azAZ";
            }
            case 3: {
                return "azAZ09";
            }
            case 4: {
                return "printable";
            }
            case 5: {
                return "ascii";
            }
            case 7: {
                return "unicode block(s)";
            }
            case 8: {
                return "hebrew";
            }
        }
        return "invalid alphabet id number";
    }

    public static int getRangeId(String alphDesc) throws Exception {
        if (alphDesc.equals("az")) {
            return 0;
        }
        if (alphDesc.equals("AZ")) {
            return 1;
        }
        if (alphDesc.equals("azAZ")) {
            return 2;
        }
        if (alphDesc.equals("azAZ09")) {
            return 3;
        }
        if (alphDesc.equals("printable")) {
            return 4;
        }
        if (alphDesc.equals("ascii")) {
            return 5;
        }
        if (alphDesc.equals("cryptogram")) {
            return 6;
        }
        if (alphDesc.equals("unicode")) {
            return 7;
        }
        if (alphDesc.equals("hebrew")) {
            return 8;
        }
        throw new Exception("AlphabetFactory.getRangeId() Invalid alphabet descriptor:" + alphDesc);
    }

    public static boolean isValidAlphabetSpec(String spec) {
        return spec.equals("az") || spec.equals("AZ") || spec.equals("azAZ09") || spec.equals("printable") || spec.equals("ascii") || spec.equals("unicode") || spec.equals("cryptogram") || spec.equals("hebrew");
    }
}

