/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.cipher;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.CipherEngine;
import hcrypto.cipher.HistoricalKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class BlockCipher
extends CipherEngine {
    protected int blocksize = 1;
    protected Alphabet alphabet;
    protected Alphabet cipherAlphabet;

    protected abstract void engineInit(HistoricalKey var1) throws Exception;

    protected abstract String engineEncode(String var1) throws Exception;

    protected abstract String engineDecode(String var1) throws Exception;

    protected void engineEncryptFile(String inFileName, String outFileName) throws Exception {
        try {
            File inputFile = new File(inFileName);
            File outputFile = new File(outFileName);
            InputStreamReader inStream = new InputStreamReader(new FileInputStream(inputFile));
            OutputStreamWriter outStream = new OutputStreamWriter(new FileOutputStream(outputFile));
            int length = (int)inputFile.length();
            char[] input = new char[length];
            inStream.read(input);
            inStream.close();
            String stringIn = new String(input);
            String stringOut = this.engineEncrypt(stringIn);
            outStream.write(stringOut, 0, stringOut.length());
            outStream.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("IOERROR: File not found either " + inFileName + " or " + outFileName);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void engineEncryptFile(String inFileName, String outFileName, String encoding) throws Exception {
        try {
            File inputFile = new File(inFileName);
            File outputFile = new File(outFileName);
            InputStreamReader inStream = new InputStreamReader((InputStream)new FileInputStream(inputFile), encoding);
            OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
            int length = (int)inputFile.length();
            char[] input = new char[length];
            inStream.read(input);
            inStream.close();
            System.out.println("File length = " + length);
            System.out.println("engineEncryptFile: Encoding = " + encoding);
            int k = 0;
            while (k < input.length) {
                System.out.println(String.valueOf((int)input[k]) + " ");
                ++k;
            }
            String stringIn = new String(input);
            String stringOut = this.engineEncrypt(stringIn);
            outStream.write(stringOut, 0, stringOut.length());
            outStream.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("IOERROR: File not found either " + inFileName + " or " + outFileName);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void engineDecryptFile(String inFileName, String outFileName) throws Exception {
        try {
            File inputFile = new File(inFileName);
            File outputFile = new File(outFileName);
            InputStreamReader inStream = new InputStreamReader(new FileInputStream(inputFile));
            OutputStreamWriter outStream = new OutputStreamWriter(new FileOutputStream(outputFile));
            int length = (int)inputFile.length();
            char[] input = new char[length];
            inStream.read(input);
            inStream.close();
            String stringIn = new String(input);
            String stringOut = this.engineDecrypt(stringIn);
            outStream.write(stringOut, 0, stringOut.length());
            outStream.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("IOERROR: File not found either " + inFileName + " or " + outFileName);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void engineDecryptFile(String inFileName, String outFileName, String encoding) throws Exception {
        try {
            File inputFile = new File(inFileName);
            File outputFile = new File(outFileName);
            InputStreamReader inStream = new InputStreamReader((InputStream)new FileInputStream(inputFile), encoding);
            OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
            int length = (int)inputFile.length();
            char[] input = new char[length];
            inStream.read(input);
            inStream.close();
            String stringIn = new String(input);
            String stringOut = this.engineDecrypt(stringIn);
            outStream.write(stringOut, 0, stringOut.length());
            outStream.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("IOERROR: File not found either " + inFileName + " or " + outFileName);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected String engineEncrypt(String s) throws Exception {
        StringBuffer result = new StringBuffer();
        int sLength = s.length();
        int ptr = 0;
        while (ptr + this.blocksize <= sLength) {
            result.append(this.engineEncode(s.substring(ptr, ptr + this.blocksize)));
            ptr += this.blocksize;
        }
        if (ptr < sLength) {
            String tail = s.substring(ptr);
            String padString = this.alphabet.getPadding(this.blocksize - tail.length());
            String encString = this.engineEncode(String.valueOf(tail) + padString);
            result.append(encString);
        } else if (this.blocksize > 1) {
            result.append(this.engineEncode(this.alphabet.getPadding(this.blocksize)));
        }
        return result.toString();
    }

    protected String engineDecrypt(String s) throws Exception {
        StringBuffer result = new StringBuffer();
        int sLength = s.length();
        int ptr = 0;
        while (ptr + this.blocksize < sLength) {
            result.append(this.engineDecode(s.substring(ptr, ptr + this.blocksize)));
            ptr += this.blocksize;
        }
        String lastBlock = s.substring(ptr);
        lastBlock = this.engineDecode(lastBlock);
        if (this.blocksize > 1) {
            lastBlock = this.alphabet.removePadding(lastBlock, this.blocksize);
        }
        if (lastBlock.length() > 0) {
            result.append(lastBlock);
        }
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected char encodeShift(char ch, int k) throws Exception {
        if (this.alphabet.isInAlphabet(ch)) ** GOTO lbl4
        return ch;
lbl-1000:
        // 1 sources

        {
            k += this.alphabet.getSize();
lbl4:
            // 2 sources

            ** while (k < 0)
        }
lbl5:
        // 1 sources

        return this.cipherAlphabet.intToChar((this.alphabet.charToInt(ch) + k) % this.alphabet.getSize());
    }

    /*
     * Unable to fully structure code
     */
    protected char decodeShift(char ch, int k) throws Exception {
        if (this.cipherAlphabet.isInAlphabet(ch)) ** GOTO lbl4
        return ch;
lbl-1000:
        // 1 sources

        {
            k += this.cipherAlphabet.getSize();
lbl4:
            // 2 sources

            ** while (k < 0)
        }
lbl5:
        // 1 sources

        return this.alphabet.intToChar((this.cipherAlphabet.charToInt(ch) + k) % this.cipherAlphabet.getSize());
    }
}

