/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.cipher;

import hcrypto.cipher.CipherEngine;
import hcrypto.cipher.HistoricalKey;
import hcrypto.provider.Provider;

public class Cipher {
    protected CipherEngine engine;
    protected String provider;
    protected String algorithm;

    protected Cipher(CipherEngine engine) {
        this.engine = engine;
    }

    public static final Cipher getInstance(String algorithm, String provider) {
        Provider p = new Provider();
        Cipher cipher = null;
        try {
            String className = p.getCipherEngine(algorithm, provider);
            cipher = new Cipher((CipherEngine)Class.forName(className).newInstance());
            cipher.algorithm = algorithm;
            cipher.provider = p.getName();
        }
        catch (Exception e) {
            System.err.println("Exception getting cipher instance: " + e.getMessage());
            e.printStackTrace();
        }
        return cipher;
    }

    public static final Cipher getInstance(String algorithm) {
        Provider p = new Provider();
        Cipher cipher = null;
        try {
            String className = p.getCipherEngine(algorithm);
            cipher = new Cipher((CipherEngine)Class.forName(className).newInstance());
            cipher.algorithm = algorithm;
            cipher.provider = p.getName();
        }
        catch (Exception e) {
            System.err.println("Exception getting cipher instance: " + e.getMessage());
            e.printStackTrace();
        }
        return cipher;
    }

    public final void init(HistoricalKey key) throws Exception {
        this.engine.engineInit(key);
    }

    public final void encryptFile(String inFileName, String outFileName) throws Exception {
        this.engine.engineEncryptFile(inFileName, outFileName);
    }

    public final void encryptFile(String inFileName, String outFileName, String encoding) throws Exception {
        this.engine.engineEncryptFile(inFileName, outFileName, encoding);
    }

    public final void decryptFile(String inFileName, String outFileName) throws Exception {
        this.engine.engineDecryptFile(inFileName, outFileName);
    }

    public final void decryptFile(String inFileName, String outFileName, String encoding) throws Exception {
        this.engine.engineDecryptFile(inFileName, outFileName, encoding);
    }

    public String encrypt(String s) throws Exception {
        return this.engine.engineEncrypt(s);
    }

    public final String decrypt(String s) throws Exception {
        return this.engine.engineDecrypt(s);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final String getProvider() {
        return this.provider;
    }

    public final String getAlphabetRangeOptions() {
        return this.engine.getAlphabetRangeOptions();
    }
}

