/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.cipher;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.AlphabetFactory;
import hcrypto.provider.Provider;
import java.util.StringTokenizer;

public abstract class HistoricalKey {
    protected String keyspec;
    protected String keyword;
    protected Alphabet alphabet;
    protected Alphabet cipherAlphabet;
    protected char[] plainKey;
    protected char[] cipherKey;
    protected int blocksize = 1;
    protected String keyDescriptorPrompt;

    public static final HistoricalKey getInstance(String algorithm, String provider) {
        Provider p = new Provider();
        HistoricalKey key = null;
        try {
            String className = p.getCipherKeyName(algorithm, provider);
            key = (HistoricalKey)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            System.err.println("Exception getting key instance: " + e.getMessage());
            e.printStackTrace();
        }
        return key;
    }

    public void initKey(String keyspec, boolean removeDuplicates) throws Exception {
        this.keyspec = keyspec;
        if (keyspec.indexOf("/") == -1) {
            throw new Exception("Invalid key specification: " + keyspec);
        }
        if (keyspec.indexOf("/") == 0) {
            throw new Exception("Keyword missing in key specification: " + keyspec);
        }
        StringTokenizer st = new StringTokenizer(keyspec, "/");
        this.keyword = removeDuplicates ? HistoricalKey.removeDuplicateChars(st.nextToken()) : st.nextToken();
        this.alphabet = AlphabetFactory.getInstance(st.nextToken());
        this.cipherAlphabet = st.hasMoreTokens() ? AlphabetFactory.getInstance(st.nextToken()) : this.alphabet;
        this.initKeyArrays();
    }

    public void initKey(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        this.alphabet = alpha1;
        this.cipherAlphabet = alpha2;
        this.keyword = keyword;
        this.initKeyArrays();
    }

    public abstract void init(String var1, Alphabet var2, Alphabet var3) throws Exception;

    public abstract void init(String var1) throws Exception;

    public abstract String getAlgorithm();

    public String getKeyword() {
        return this.keyword;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Alphabet getCTAlphabet() {
        return this.cipherAlphabet;
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public String getKeyDescriptorPrompt() {
        return this.keyDescriptorPrompt;
    }

    public static String removeDuplicateChars(String key) {
        String newKey = "";
        int k = 0;
        while (k < key.length()) {
            if (newKey.indexOf(key.charAt(k)) == -1) {
                newKey = String.valueOf(newKey) + key.charAt(k);
            }
            ++k;
        }
        return newKey;
    }

    protected void initKeyArrays() throws Exception {
        char ch;
        if (this.alphabet.getSize() != this.cipherAlphabet.getSize()) {
            throw new Exception("ERROR: Plain and cipher alphabets must be the same size");
        }
        this.plainKey = new char[this.alphabet.getSize()];
        this.cipherKey = this.cipherAlphabet != this.alphabet ? new char[this.cipherAlphabet.getSize()] : new char[this.alphabet.getSize()];
        StringBuffer keychars = new StringBuffer();
        int k = 0;
        while (k < this.keyword.length()) {
            ch = this.keyword.charAt(k);
            if (this.cipherAlphabet.isInAlphabet(ch)) {
                keychars.append(ch);
            }
            ++k;
        }
        String keycharStr = keychars.toString();
        int k2 = 0;
        while (k2 < this.cipherAlphabet.getSize()) {
            ch = this.cipherAlphabet.intToChar(k2);
            if (keycharStr.indexOf(ch) == -1) {
                keychars.append(ch);
            }
            ++k2;
        }
        if (keychars.length() != this.cipherKey.length) {
            throw new Exception("ERROR: Unable to construct alphabets from keyword " + this.keyword);
        }
        k2 = 0;
        while (k2 < keychars.length()) {
            this.cipherKey[k2] = ch = keychars.charAt(k2);
            this.plainKey[this.cipherAlphabet.charToInt((char)ch)] = this.alphabet.intToChar(k2);
            ++k2;
        }
    }

    public char[] getCipherKey() {
        return this.cipherKey;
    }

    public char[] getPlainKey() {
        return this.plainKey;
    }

    public void printAlphabets() {
        int k = 0;
        while (k < this.cipherAlphabet.getSize()) {
            System.out.print(this.cipherKey[k]);
            ++k;
        }
        System.out.println();
        k = 0;
        while (k < this.alphabet.getSize()) {
            System.out.print(this.plainKey[k]);
            ++k;
        }
        System.out.println();
    }

    public static String invertKey(String key) {
        StringBuffer sb = new StringBuffer();
        int ch = 97;
        while (ch <= 122) {
            sb.append((char)(97 + key.indexOf(ch)));
            ++ch;
        }
        return sb.toString();
    }
}

