/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.cipher;

import java.lang.reflect.Field;

public class UnicodeRanges {
    public static char getRangeLow(Character.UnicodeBlock b) {
        if (b == Character.UnicodeBlock.ARABIC) {
            return '\u0600';
        }
        if (b == Character.UnicodeBlock.DINGBATS) {
            return '\u2700';
        }
        if (b == Character.UnicodeBlock.GREEK) {
            return '\u0370';
        }
        if (b == Character.UnicodeBlock.GREEK_EXTENDED) {
            return '\u1f00';
        }
        if (b == Character.UnicodeBlock.HEBREW) {
            return '\u0590';
        }
        if (b == Character.UnicodeBlock.HIRAGANA) {
            return '\u3040';
        }
        if (b == Character.UnicodeBlock.KATAKANA) {
            return '\u30a0';
        }
        if (b == Character.UnicodeBlock.MATHEMATICAL_OPERATORS) {
            return '\u2200';
        }
        return '\u0000';
    }

    public static char getRangeHigh(Character.UnicodeBlock b) {
        if (b == Character.UnicodeBlock.ARABIC) {
            return '\u06ff';
        }
        if (b == Character.UnicodeBlock.DINGBATS) {
            return '\u27bf';
        }
        if (b == Character.UnicodeBlock.GREEK) {
            return '\u03cf';
        }
        if (b == Character.UnicodeBlock.GREEK_EXTENDED) {
            return '\u1fff';
        }
        if (b == Character.UnicodeBlock.HEBREW) {
            return '\u05ff';
        }
        if (b == Character.UnicodeBlock.HIRAGANA) {
            return '\u309f';
        }
        if (b == Character.UnicodeBlock.KATAKANA) {
            return '\u30ff';
        }
        if (b == Character.UnicodeBlock.MATHEMATICAL_OPERATORS) {
            return '\u22ff';
        }
        return '\u0000';
    }

    public static char getRangeLow(String s) {
        char ch = '\u0000';
        String fieldName = s.substring(s.indexOf(".") + 1);
        try {
            Class<?> c = Class.forName("java.lang.Character$UnicodeBlock");
            Field f = c.getField(fieldName);
            ch = UnicodeRanges.getRangeLow((Character.UnicodeBlock)f.get(c));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            System.err.println("Field = " + fieldName);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ch;
    }

    public static char getRangeHigh(String s) {
        char ch = '\u0000';
        String fieldName = s.substring(s.indexOf(".") + 1);
        try {
            Class<?> c = Class.forName("java.lang.Character$UnicodeBlock");
            Field f = c.getField(fieldName);
            ch = UnicodeRanges.getRangeHigh((Character.UnicodeBlock)f.get(c));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            System.err.println("Field = " + fieldName);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ch;
    }

    public static void main(String[] args) {
        System.out.println("Arabic " + UnicodeRanges.getRangeLow(Character.UnicodeBlock.ARABIC));
        System.out.println("Hebrew " + UnicodeRanges.getRangeLow(Character.UnicodeBlock.HEBREW));
        System.out.println("Hiragana " + UnicodeRanges.getRangeLow(Character.UnicodeBlock.HIRAGANA));
        System.out.println("Katakana " + UnicodeRanges.getRangeLow(Character.UnicodeBlock.KATAKANA));
    }
}

