/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.AffineKey;

public class AffineEngine
extends BlockCipher {
    private AffineKey key;
    private int A_E_Key;
    private int B_E_Key;
    private int A_D_Key;
    private int B_D_Key;

    public AffineEngine() {
        this.alphabetRangeOptions = "110000/110000";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof AffineKey)) {
            throw new Exception("InvalidKey: Affine requires AffineKey");
        }
        AffineKey key = (AffineKey)hKey;
        this.blocksize = key.getBlocksize();
        this.alphabet = key.getAlphabet();
        this.cipherAlphabet = key.getCTAlphabet();
        this.A_E_Key = key.getKeyA();
        this.B_E_Key = key.getKeyB();
        int aSize = this.alphabet.getSize();
        this.A_D_Key = this.getA_D_Key(aSize);
        this.B_D_Key = this.getB_D_Key(aSize);
    }

    public String engineEncode(String s) throws Exception {
        char ch;
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Affine cipher " + this.blocksize);
        }
        char cipherChar = ch = s.charAt(0);
        if (this.alphabet.isInAlphabet(ch)) {
            cipherChar = this.cipherAlphabet.intToChar((this.A_E_Key * this.alphabet.charToInt(ch) + this.B_E_Key) % this.alphabet.getSize());
        }
        return "" + cipherChar;
    }

    public String engineDecode(String s) throws Exception {
        char ch;
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Affine cipher " + this.blocksize);
        }
        char cipherChar = ch = s.charAt(0);
        if (this.cipherAlphabet.isInAlphabet(ch)) {
            cipherChar = this.alphabet.intToChar((this.A_D_Key * this.cipherAlphabet.charToInt(ch) + this.B_D_Key) % this.cipherAlphabet.getSize());
        }
        return "" + cipherChar;
    }

    private int getA_D_Key(int aSize) throws Exception {
        int k = 1;
        while (k < aSize) {
            if (this.A_E_Key * k % aSize == 1) {
                return k;
            }
            ++k;
        }
        throw new Exception("InvalidKey for Affine Cipher: Invalid A_E_Key");
    }

    private int getB_D_Key(int aSize) {
        return aSize - this.A_D_Key * this.B_E_Key % aSize % aSize;
    }
}

