/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.HistoricalKey;

public class AffineKey
extends HistoricalKey {
    private int keyA;
    private int keyB;
    public static final String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "an odd integer between 0-25(with the exception of 13), and any integer from 0-25.  Example: 3,19";
    public static final String DEFAULT_KEYWORD_STRING = "3,19";

    public void init(String keyspec) throws Exception {
        this.initKey(keyspec, false);
        this.blocksize = 1;
        this.keyA = Integer.parseInt(this.keyword.substring(0, this.keyword.indexOf(44)));
        this.keyB = Integer.parseInt(this.keyword.substring(this.keyword.indexOf(44) + 1));
    }

    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        if (alpha1 == null || alpha2 == null) {
            throw new Exception("AffineKey.init(): Null alphabet reference passed");
        }
        this.keyword = keyword;
        this.blocksize = 1;
        this.keyA = Integer.parseInt(keyword.substring(0, keyword.indexOf(44)));
        this.keyB = Integer.parseInt(keyword.substring(keyword.indexOf(44) + 1));
        super.initKey(keyword, alpha1, alpha2);
    }

    public String getAlgorithm() {
        return "Affine";
    }

    public int getKeyA() {
        return this.keyA;
    }

    public int getKeyB() {
        return this.keyB;
    }
}

