/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.HistoricalKey;

public class CaesarKey
extends HistoricalKey {
    public static final String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "a positive integer";
    public static final String DEFAULT_KEYWORD_STRING = "5";
    private int shift;

    public void init(String keyspec) throws Exception {
        this.initKey(keyspec, false);
        this.blocksize = 1;
        this.keyDescriptorPrompt = "positive integer";
        this.shift = Integer.parseInt(this.keyword);
        if (this.shift < 0) {
            throw new Exception("Invalid shift value for Caesar cipher: " + this.shift);
        }
    }

    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        if (alpha1 == null || alpha2 == null) {
            throw new Exception("CaesarKey.init(): Null alphabet reference passed");
        }
        super.initKey(keyword, alpha1, alpha2);
        this.keyword = keyword;
        this.blocksize = 1;
        this.keyDescriptorPrompt = "positive integer";
        this.shift = Integer.parseInt(keyword);
        if (this.shift < 0) {
            throw new Exception("Invalid shift value for Caesar cipher: " + this.shift);
        }
    }

    public int getShift() {
        return this.shift;
    }

    public String getAlgorithm() {
        return "Caesar";
    }
}

