/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.PlayfairKey;

public class PlayfairEngine
extends BlockCipher {
    private PlayfairKey key;

    public PlayfairEngine() {
        this.alphabetRangeOptions = "100000/100000";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof PlayfairKey)) {
            throw new Exception("InvalidKey: Playfair requires PlayfairKey");
        }
        this.key = (PlayfairKey)hKey;
        this.alphabet = this.key.getAlphabet();
        this.cipherAlphabet = this.key.getCTAlphabet();
        this.blocksize = this.key.getBlocksize();
    }

    public String engineEncode(String s) throws Exception {
        char newCh2;
        char newCh1;
        if (s.length() < this.blocksize) {
            return s;
        }
        char ch1 = s.charAt(0);
        char ch2 = s.charAt(1);
        if (!this.alphabet.isInAlphabet(ch1) || !this.alphabet.isInAlphabet(ch2)) {
            return s;
        }
        if (ch1 == 'j') {
            ch1 = 'i';
        }
        if (ch2 == 'j') {
            ch2 = 'i';
        }
        int indexCh1 = this.key.findCharPosition(ch1);
        int indexCh2 = this.key.findCharPosition(ch2);
        if (this.key.getRowIndex(indexCh1) == this.key.getRowIndex(indexCh2)) {
            newCh1 = this.key.getChar(this.key.getRightColIndex(indexCh1));
            newCh2 = this.key.getChar(this.key.getRightColIndex(indexCh2));
        } else if (this.key.getColIndex(indexCh1) == this.key.getColIndex(indexCh2)) {
            newCh1 = this.key.getChar(this.key.getRowBelowIndex(indexCh1));
            newCh2 = this.key.getChar(this.key.getRowBelowIndex(indexCh2));
        } else {
            newCh1 = this.key.getChar(this.key.getRowIndex(indexCh1), this.key.getColIndex(indexCh2));
            newCh2 = this.key.getChar(this.key.getRowIndex(indexCh2), this.key.getColIndex(indexCh1));
        }
        return "" + newCh1 + newCh2;
    }

    public String engineDecode(String s) throws Exception {
        char newCh2;
        char newCh1;
        if (s.length() < this.blocksize) {
            return s;
        }
        char ch1 = s.charAt(0);
        char ch2 = s.charAt(1);
        if (!this.cipherAlphabet.isInAlphabet(ch1) || !this.cipherAlphabet.isInAlphabet(ch2)) {
            return s;
        }
        if (ch1 == 'j') {
            ch1 = 'i';
        }
        if (ch2 == 'j') {
            ch2 = 'i';
        }
        int indexCh1 = this.key.findCharPosition(ch1);
        int indexCh2 = this.key.findCharPosition(ch2);
        if (this.key.getRowIndex(indexCh1) == this.key.getRowIndex(indexCh2)) {
            newCh1 = this.key.getChar(this.key.getLeftColIndex(indexCh1));
            newCh2 = this.key.getChar(this.key.getLeftColIndex(indexCh2));
        } else if (this.key.getColIndex(indexCh1) == this.key.getColIndex(indexCh2)) {
            newCh1 = this.key.getChar(this.key.getRowAboveIndex(indexCh1));
            newCh2 = this.key.getChar(this.key.getRowAboveIndex(indexCh2));
        } else {
            newCh1 = this.key.getChar(this.key.getRowIndex(indexCh1), this.key.getColIndex(indexCh2));
            newCh2 = this.key.getChar(this.key.getRowIndex(indexCh2), this.key.getColIndex(indexCh1));
        }
        return "" + newCh1 + newCh2;
    }
}

