/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.HistoricalKey;

public class PlayfairKey
extends HistoricalKey {
    public static final String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "a keyword";
    public static final String DEFAULT_KEYWORD_STRING = "keyword";
    private static int SQUARE_SIZE = 26;
    private static int SIDE = 5;
    private char[] keySquare;

    public void init(String keyspec) throws Exception {
        super.initKey(keyspec, true);
        this.blocksize = 2;
        if (keyspec.indexOf("/") == -1) {
            throw new Exception("Invalid key specification: " + keyspec);
        }
        if (keyspec.indexOf("/") == 0) {
            throw new Exception("Keyword missing in key specification: " + keyspec);
        }
        if (!this.isKeyAlphabetGood()) {
            throw new Exception("Keyword contains symbols not allowed in the alphabet: " + keyspec);
        }
        if (this.alphabet.getRangeId() != 0) {
            throw new Exception("Invalid alphabet for Playfair key: " + this.alphabet.getRangeDesc());
        }
        this.initKeySquare();
    }

    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        if (!this.isKeyAlphabetGood()) {
            throw new Exception("Keyword contains symbols not allowed in the alphabet: " + this.keyspec);
        }
        if (alpha1 == null || alpha2 == null) {
            throw new Exception("PlayfairKey.init(): Null alphabet reference passed");
        }
        super.initKey(keyword, alpha1, alpha2);
        this.keyword = HistoricalKey.removeDuplicateChars(keyword);
        this.blocksize = 2;
        if (this.alphabet.getRangeId() != 0) {
            throw new Exception("Invalid alphabet for Playfair key: " + this.alphabet.getRangeDesc());
        }
        this.initKeySquare();
    }

    public String getAlgorithm() {
        return "Playfair";
    }

    public int findCharPosition(char ch) throws Exception {
        int k = 0;
        while (this.keySquare[k] != ch && k < this.keySquare.length) {
            ++k;
        }
        if (k == this.keySquare.length) {
            throw new Exception("Invalid character in Playfair " + ch);
        }
        return k;
    }

    public char getChar(int index) {
        return this.keySquare[index];
    }

    public char getChar(int row, int col) {
        return this.keySquare[this.getIndex(row, col)];
    }

    public int getRowIndex(int index) {
        return index / SIDE;
    }

    public int getColIndex(int index) {
        return index % SIDE;
    }

    public int getRightColIndex(int index) {
        return this.getIndex(this.getRowIndex(index), (this.getColIndex(index) + 1) % SIDE);
    }

    public int getLeftColIndex(int index) {
        int newCol = this.getColIndex(index) - 1;
        if (newCol < 0) {
            newCol = SIDE - 1;
        }
        return this.getIndex(this.getRowIndex(index), newCol);
    }

    public int getRowBelowIndex(int index) {
        return this.getIndex((this.getRowIndex(index) + 1) % SIDE, this.getColIndex(index));
    }

    public int getRowAboveIndex(int index) {
        int newRow = this.getRowIndex(index) - 1;
        if (newRow < 0) {
            newRow = SIDE - 1;
        }
        return this.getIndex(newRow, this.getColIndex(index));
    }

    private boolean isKeyAlphabetGood() {
        int i = 0;
        while (i < this.keyspec.indexOf("/")) {
            if (!this.alphabet.isInAlphabet(this.keyspec.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void initKeySquare() throws Exception {
        if (this.alphabet.getRangeId() != 0) {
            throw new Exception("Invalid alphabet for Playfair cipher");
        }
        this.keySquare = new char[PlayfairKey.SQUARE_SIZE];
        inserted = new boolean[PlayfairKey.SQUARE_SIZE];
        k = 0;
        while (k < this.keySquare.length) {
            this.keySquare[k] = 42;
            inserted[k] = false;
            ++k;
        }
        k = 0;
        while (k < this.keyword.length()) {
            ch = this.keyword.charAt(k);
            if (ch == 106) {
                ch = 105;
            }
            if (!inserted[ch - 97]) {
                this.keySquare[k] = ch;
                inserted[ch - 97] = true;
            }
            if (ch == 105) {
                inserted[9] = true;
            }
            ++k;
        }
        ptr = 0;
        k = this.keyword.length();
        ** GOTO lbl36
        {
            ++ptr;
            do {
                if (ptr < inserted.length && inserted[ptr]) continue block2;
                if (ptr == 8) {
                    this.keySquare[k] = 105;
                    inserted[9] = true;
                } else {
                    this.keySquare[k] = ptr == 9 ? 105 : (char)(ptr + 97);
                }
                ++ptr;
                ++k;
lbl36:
                // 2 sources

            } while (k < this.keySquare.length);
        }
    }

    private int getIndex(int rowIndx, int colIndx) {
        return SIDE * rowIndx + colIndx;
    }

    public void testMethods() {
        int k = 0;
        while (k < this.keySquare.length - 1) {
            System.out.println("right " + k + " " + this.getRightColIndex(k));
            System.out.println("left " + k + " " + this.getLeftColIndex(k));
            System.out.println("up " + k + " " + this.getRowAboveIndex(k));
            System.out.println("down " + k + " " + this.getRowBelowIndex(k));
            ++k;
        }
    }

    public void printKeySquare() {
        int k = 0;
        while (k < this.keySquare.length - 1) {
            if (k % SIDE == 0) {
                System.out.println();
            }
            System.out.print(String.valueOf(this.keySquare[k]) + " ");
            ++k;
        }
    }
}

