/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.PolySubstitutionKey;

public class PolySubstitutionEngine
extends BlockCipher {
    private char[] decodingAlphabet;
    private String[] codingAlphabet;
    private PolySubstitutionKey key;
    private static int counter = 0;

    public PolySubstitutionEngine() {
        this.alphabetRangeOptions = "111111/111111";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof PolySubstitutionKey)) {
            throw new Exception("InvalidKey: Substitution requires SubstitutionKey");
        }
        this.key = (PolySubstitutionKey)hKey;
        this.alphabet = this.key.getAlphabet();
        this.cipherAlphabet = this.key.getCTAlphabet();
        this.blocksize = this.key.getBlocksize();
        this.decodingAlphabet = this.key.getDecodingAlphabet();
        this.codingAlphabet = this.key.getCodingAlphabet();
    }

    public String engineEncode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Substitution cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.alphabet.isInAlphabet(ch)) {
            int num = this.alphabet.charToInt(ch);
            int len = this.codingAlphabet[num].length();
            return "" + this.codingAlphabet[num].charAt(counter++ % len);
        }
        return s;
    }

    public String engineDecode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Substitution cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.cipherAlphabet.isInAlphabet(ch)) {
            return "" + this.decodingAlphabet[this.cipherAlphabet.charToInt(ch)];
        }
        return s;
    }
}

