/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.HistoricalKey;

public class PolySubstitutionKey
extends HistoricalKey {
    public static final String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "a plaintext keyword";
    public static final String DEFAULT_KEYWORD_STRING = "keyword";
    private char[] decodingAlphabet;
    private String[] codingAlphabet;

    public void init(String keyspec) throws Exception {
        this.initKey(keyspec, false);
        this.blocksize = 1;
    }

    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        if (alpha1 == null || alpha2 == null) {
            throw new Exception("PolySubstitution.init(): Null alphabet reference passed");
        }
        super.initKey(keyword, alpha1, alpha2);
        this.keyword = keyword;
        this.blocksize = 1;
    }

    public String getAlgorithm() {
        return "PolySubstitution";
    }

    public char[] getDecodingAlphabet() {
        return this.decodingAlphabet;
    }

    public String[] getCodingAlphabet() {
        return this.codingAlphabet;
    }

    protected void initKeyArrays() throws Exception {
        char ch;
        this.codingAlphabet = new String[this.alphabet.getSize()];
        this.decodingAlphabet = new char[this.cipherAlphabet.getSize()];
        String keychars = "";
        int k = 0;
        while (k < this.codingAlphabet.length) {
            this.codingAlphabet[k] = "";
            ++k;
        }
        k = 0;
        while (k < this.keyword.length()) {
            ch = this.keyword.charAt(k);
            if (this.alphabet.isInAlphabet(ch)) {
                keychars = String.valueOf(keychars) + ch;
            }
            ++k;
        }
        String missingChars = "";
        int k2 = 0;
        while (k2 < this.alphabet.getSize()) {
            ch = this.alphabet.intToChar(k2);
            if (keychars.indexOf(ch) == -1) {
                missingChars = String.valueOf(missingChars) + ch;
            }
            ++k2;
        }
        while (keychars.length() + missingChars.length() > this.cipherAlphabet.getSize()) {
            keychars = keychars.substring(0, this.cipherAlphabet.getSize() - missingChars.length());
            missingChars = "";
            k2 = 0;
            while (k2 < this.alphabet.getSize()) {
                ch = this.cipherAlphabet.intToChar(k2);
                if (keychars.indexOf(ch) == -1) {
                    missingChars = String.valueOf(missingChars) + ch;
                }
                ++k2;
            }
        }
        keychars = String.valueOf(keychars) + missingChars;
        while (keychars.length() < this.cipherAlphabet.getSize()) {
            keychars = String.valueOf(keychars) + keychars;
        }
        keychars = keychars.substring(0, this.cipherAlphabet.getSize());
        k2 = 0;
        while (k2 < keychars.length()) {
            this.decodingAlphabet[k2] = ch = keychars.charAt(k2);
            int index = this.alphabet.charToInt(ch);
            this.codingAlphabet[index] = String.valueOf(this.codingAlphabet[index]) + this.cipherAlphabet.intToChar(k2);
            ++k2;
        }
    }

    public void printAlphabets() {
        int k = 0;
        while (k < this.cipherAlphabet.getSize()) {
            System.out.print(this.decodingAlphabet[k]);
            ++k;
        }
        System.out.println();
        k = 0;
        while (k < this.alphabet.getSize()) {
            System.out.print(String.valueOf(this.codingAlphabet[k]) + " ");
            ++k;
        }
        System.out.println();
    }
}

