/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.RailfenceKey;

public class RailfenceEngine
extends BlockCipher {
    private RailfenceKey key;
    private String keyword;

    public RailfenceEngine() {
        this.alphabetRangeOptions = "111111/111111";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof RailfenceKey)) {
            throw new Exception("InvalidKey: Railfence requires RailfenceKey");
        }
        this.key = (RailfenceKey)hKey;
        this.alphabet = this.key.getAlphabet();
        this.cipherAlphabet = this.key.getCTAlphabet();
        this.blocksize = this.key.getBlocksize();
        this.keyword = this.key.getKeyword();
    }

    private String removeWhitespace(String s) {
        StringBuffer sb = new StringBuffer("");
        int k = 0;
        while (k < s.length()) {
            char ch = s.charAt(k);
            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                sb.append(s.charAt(k));
            }
            ++k;
        }
        return sb.toString();
    }

    protected String engineEncrypt(String str) throws Exception {
        return this.engineEncode(this.removeWhitespace(str));
    }

    protected String engineDecrypt(String str) throws Exception {
        return this.engineDecode(this.removeWhitespace(str));
    }

    public String engineEncode(String str) throws Exception {
        StringBuffer sb = new StringBuffer("");
        int length = str.length();
        int nrows = Integer.parseInt(this.keyword);
        int rmdr = length % nrows;
        char padchar = 'a';
        int nchars = nrows - rmdr;
        if (rmdr == 0) {
            padchar = (char)(97 + nrows - 1);
            nchars = nrows;
        } else {
            padchar = (char)(97 + nchars - 1);
        }
        System.out.println("len = " + length + " nrows=" + nrows + " rmdr= " + rmdr + " " + padchar);
        int k = 0;
        while (k < nrows) {
            str = String.valueOf(str) + padchar;
            ++k;
        }
        length = str.length();
        int ncols = length / nrows;
        int row = 0;
        while (row < nrows) {
            int col = 0;
            while (col < ncols) {
                sb.append(str.charAt(row + nrows * col));
                ++col;
            }
            ++row;
        }
        return sb.toString();
    }

    public String engineDecode(String cText) {
        String str = cText;
        StringBuffer sb = new StringBuffer("");
        int length = str.length();
        int nrows = Integer.parseInt(this.keyword);
        int rmdr = length % nrows;
        length = str.length();
        char padchar = str.charAt(str.length() - 1);
        int nchars = padchar - 97 + 1;
        System.out.println("len = " + length + " nrows=" + nrows + " rmdr= " + rmdr + " " + padchar + " nchars= " + nchars);
        int ncols = length / nrows;
        int col = 0;
        while (col < ncols) {
            int row = 0;
            while (row < nrows) {
                sb.append(str.charAt(col + row * ncols));
                ++row;
            }
            ++col;
        }
        return sb.toString().substring(0, str.length() - nchars);
    }
}

