/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.SubstitutionKey;

public class SubstitutionEngine
extends BlockCipher {
    private char[] cipherKey;
    private char[] plainKey;
    private SubstitutionKey key;

    public SubstitutionEngine() {
        this.alphabetRangeOptions = "111111/111111";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof SubstitutionKey)) {
            throw new Exception("InvalidKey: Substitution requires SubstitutionKey");
        }
        this.key = (SubstitutionKey)hKey;
        this.alphabet = this.key.getAlphabet();
        this.cipherAlphabet = this.key.getCTAlphabet();
        this.blocksize = this.key.getBlocksize();
        this.cipherKey = this.key.getCipherKey();
        this.plainKey = this.key.getPlainKey();
    }

    public String engineEncode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Substitution cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.alphabet.isInAlphabet(ch)) {
            return "" + this.cipherKey[this.alphabet.charToInt(ch)];
        }
        return s;
    }

    public String engineDecode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Substitution cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.cipherAlphabet.isInAlphabet(ch)) {
            return "" + this.plainKey[this.cipherAlphabet.charToInt(ch)];
        }
        return s;
    }
}

